/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.sql.pending;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.sql.config.RetryProperties;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.StartExecution;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.orca.q.sql.pending.SqlPendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import de.huxhorn.sulky.ulid.ULID;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TransactionalCallable;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u000223BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0016J \u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J$\u0010+\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00032\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001f0-H\u0016J'\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H/0-H\u0002\u00a2\u0006\u0002\u00101R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u0017*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/netflix/spinnaker/orca/q/sql/pending/SqlPendingExecutionService;", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "shard", "", "jooq", "Lorg/jooq/DSLContext;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "retryProperties", "Lcom/netflix/spinnaker/kork/sql/config/RetryProperties;", "maxDepth", "", "(Ljava/lang/String;Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/kork/sql/config/RetryProperties;I)V", "cancelId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "enqueueId", "popId", "shardCondition", "Lorg/jooq/Condition;", "depth", "pipelineConfigId", "doEnqueue", "", "message", "Lcom/netflix/spinnaker/q/Message;", "enqueue", "pendingIds", "", "pop", "sortField", "Lorg/jooq/SortField;", "", "popNewest", "popOldest", "purge", "callback", "Lkotlin/Function1;", "withRetry", "T", "fn", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "MessageContainer", "orca-queue-sql"})
public final class SqlPendingExecutionService
implements PendingExecutionService {
    private final Id enqueueId;
    private final Id cancelId;
    private final Id popId;
    private Condition shardCondition;
    private final String shard;
    private final DSLContext jooq;
    private final Queue queue;
    private final ExecutionRepository repository;
    private final ObjectMapper mapper;
    private final Clock clock;
    private final Registry registry;
    private final RetryProperties retryProperties;
    private final int maxDepth;
    private static final Table<Record> pendingTable;
    private static final Field<Object> configField;
    private static final Field<Object> idField;
    private static final Field<Object> messageField;
    private static final Field<Object> shardField;
    private static final RetrySupport retrySupport;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    public void enqueue(@NotNull String pipelineConfigId, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PercentileTimer.get((Registry)this.registry, (Id)this.enqueueId).record(new Runnable(this, pipelineConfigId, message){
            final /* synthetic */ SqlPendingExecutionService this$0;
            final /* synthetic */ String $pipelineConfigId;
            final /* synthetic */ Message $message;

            public final void run() {
                SqlPendingExecutionService.access$doEnqueue(this.this$0, this.$pipelineConfigId, this.$message);
            }
            {
                this.this$0 = sqlPendingExecutionService;
                this.$pipelineConfigId = string;
                this.$message = message;
            }
        });
    }

    private final void doEnqueue(String pipelineConfigId, Message message) {
        try {
            int queued = this.depth(pipelineConfigId);
            if (queued >= this.maxDepth) {
                if (message instanceof StartExecution) {
                    log.warn("Canceling execution " + ((StartExecution)message).getExecutionId() + " for pipeline " + pipelineConfigId + " due to pending " + "depth of " + queued + " executions");
                    this.registry.counter(this.cancelId).increment();
                    try {
                        PipelineExecution pipelineExecution = this.repository.retrieve(ExecutionType.PIPELINE, ((StartExecution)message).getExecutionId());
                        boolean bl = false;
                        boolean bl2 = false;
                        PipelineExecution $this$apply = pipelineExecution;
                        boolean bl3 = false;
                        $this$apply.setCanceled(true);
                        $this$apply.setCanceledBy("spinnaker");
                        $this$apply.setCancellationReason("Too many executions (" + queued + ") already waiting to start");
                        $this$apply.setStatus(ExecutionStatus.CANCELED);
                        PipelineExecution pipelineExecution2 = pipelineExecution;
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"repository.retrieve(PIPE\u2026.CANCELED\n              }");
                        PipelineExecution execution = pipelineExecution2;
                        this.repository.store(execution);
                    }
                    catch (ExecutionNotFoundException e) {
                        log.error("Failed to retrieve execution " + ((StartExecution)message).getExecutionId() + " for pipeline " + pipelineConfigId);
                    }
                } else {
                    log.warn("Dropping pending message for pipeline " + pipelineConfigId + " due to pending execution depth of " + queued);
                }
                return;
            }
            this.withRetry((Function1)new Function1<Object, Integer>(this, pipelineConfigId, message){
                final /* synthetic */ SqlPendingExecutionService this$0;
                final /* synthetic */ String $pipelineConfigId;
                final /* synthetic */ Message $message;

                public final int invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return SqlPendingExecutionService.access$getJooq$p(this.this$0).insertInto(SqlPendingExecutionService.access$getPendingTable$cp()).columns(SqlPendingExecutionService.access$getIdField$cp(), SqlPendingExecutionService.access$getConfigField$cp(), SqlPendingExecutionService.access$getShardField$cp(), SqlPendingExecutionService.access$getMessageField$cp()).values((Object)new ULID().nextValue().toString(), (Object)this.$pipelineConfigId, (Object)SqlPendingExecutionService.access$getShard$p(this.this$0), (Object)SqlPendingExecutionService.access$getMapper$p(this.this$0).writeValueAsString((Object)this.$message)).execute();
                }
                {
                    this.this$0 = sqlPendingExecutionService;
                    this.$pipelineConfigId = string;
                    this.$message = message;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to enqueue pending execution for pipeline " + pipelineConfigId);
            throw (Throwable)e;
        }
    }

    @Nullable
    public Message popOldest(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        long start = this.clock.millis();
        SortField sortField = idField.asc();
        Intrinsics.checkNotNullExpressionValue((Object)sortField, (String)"idField.asc()");
        Message message = this.pop(pipelineConfigId, (SortField<Object>)sortField);
        PercentileTimer.get((Registry)this.registry, (Id)this.popId.withTag("purge", "false")).record(this.clock.millis() - start, TimeUnit.MILLISECONDS);
        return message;
    }

    @Nullable
    public Message popNewest(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        long start = this.clock.millis();
        SortField sortField = idField.desc();
        Intrinsics.checkNotNullExpressionValue((Object)sortField, (String)"idField.desc()");
        Message message = this.pop(pipelineConfigId, (SortField<Object>)sortField);
        PercentileTimer.get((Registry)this.registry, (Id)this.popId.withTag("purge", "true")).record(this.clock.millis() - start, TimeUnit.MILLISECONDS);
        return message;
    }

    private final Message pop(String pipelineConfigId, SortField<Object> sortField) {
        try {
            return (Message)this.withRetry((Function1)new Function1<Object, Message>(this, pipelineConfigId, sortField){
                final /* synthetic */ SqlPendingExecutionService this$0;
                final /* synthetic */ String $pipelineConfigId;
                final /* synthetic */ SortField $sortField;

                public final Message invoke(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Message)SqlPendingExecutionService.access$getJooq$p(this.this$0).transactionResult((TransactionalCallable)new TransactionalCallable<Message>(this){
                        final /* synthetic */ pop.1 this$0;

                        public final Message run(Configuration configuration) {
                            DSLContext txn = DSL.using((Configuration)configuration);
                            Object object = (Record2)txn.select((SelectField)SqlPendingExecutionService.access$getIdField$cp(), (SelectField)SqlPendingExecutionService.access$getMessageField$cp()).from((TableLike)SqlPendingExecutionService.access$getPendingTable$cp()).where(new Condition[]{SqlPendingExecutionService.access$getConfigField$cp().eq((Object)this.this$0.$pipelineConfigId), SqlPendingExecutionService.access$getShardCondition$p(this.this$0.this$0)}).orderBy((OrderField)this.this$0.$sortField).limit(1).forUpdate().fetchOne();
                            if (object != null && (object = (MessageContainer)object.into(MessageContainer.class)) != null) {
                                Object object2 = object;
                                boolean bl = false;
                                boolean bl2 = false;
                                Object it = object2;
                                boolean bl3 = false;
                                txn.deleteFrom(SqlPendingExecutionService.access$getPendingTable$cp()).where(SqlPendingExecutionService.access$getIdField$cp().eq((Object)((MessageContainer)it).getId())).execute();
                                return (Message)SqlPendingExecutionService.access$getMapper$p(this.this$0.this$0).readValue(((MessageContainer)it).getMessage(), Message.class);
                            }
                            return null;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = sqlPendingExecutionService;
                    this.$pipelineConfigId = string;
                    this.$sortField = sortField;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed popping pending execution for pipeline " + pipelineConfigId + ", attempting to requeue " + "StartWaitingExecutions message", (Throwable)e);
            boolean purge = sortField.getOrder() == SortOrder.DESC;
            Message message = (Message)new StartWaitingExecutions(pipelineConfigId, purge);
            Duration duration = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofSeconds(10)");
            this.queue.push(message, (TemporalAmount)duration);
            return null;
        }
    }

    public void purge(@NotNull String pipelineConfigId, @NotNull Function1<? super Message, Unit> callback) {
        Message oldest;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        do {
            Message message;
            if ((oldest = this.popOldest(pipelineConfigId)) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            Unit cfr_ignored_0 = (Unit)callback.invoke((Object)message);
        } while (oldest != null);
    }

    public int depth(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        return ((Number)this.withRetry((Function1)new Function1<Object, Integer>(this, pipelineConfigId){
            final /* synthetic */ SqlPendingExecutionService this$0;
            final /* synthetic */ String $pipelineConfigId;

            public final int invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer n = (Integer)SqlPendingExecutionService.access$getJooq$p(this.this$0).selectCount().from((TableLike)SqlPendingExecutionService.access$getPendingTable$cp()).where(new Condition[]{SqlPendingExecutionService.access$getConfigField$cp().eq((Object)this.$pipelineConfigId), SqlPendingExecutionService.access$getShardCondition$p(this.this$0)}).fetchSingle(0, Integer.TYPE);
                return n != null ? n : 0;
            }
            {
                this.this$0 = sqlPendingExecutionService;
                this.$pipelineConfigId = string;
                super(1);
            }
        })).intValue();
    }

    @NotNull
    public List<String> pendingIds() {
        List list = this.jooq.select((SelectField)configField).from((TableLike)pendingTable).where(this.shardCondition).fetch(configField, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n      .select(confi\u2026ield, String::class.java)");
        return CollectionsKt.distinct((Iterable)list);
    }

    private final <T> T withRetry(Function1<Object, ? extends T> fn) {
        return (T)retrySupport.retry(new Supplier<T>(this, fn){
            final /* synthetic */ SqlPendingExecutionService this$0;
            final /* synthetic */ Function1 $fn;

            public final T get() {
                return (T)this.$fn.invoke((Object)this.this$0);
            }
            {
                this.this$0 = sqlPendingExecutionService;
                this.$fn = function1;
            }
        }, this.retryProperties.getMaxRetries(), this.retryProperties.getBackoffMs(), false);
    }

    public SqlPendingExecutionService(@Nullable String shard, @NotNull DSLContext jooq, @NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull ObjectMapper mapper, @NotNull Clock clock, @NotNull Registry registry, @NotNull RetryProperties retryProperties, int maxDepth) {
        Condition condition;
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)retryProperties, (String)"retryProperties");
        this.shard = shard;
        this.jooq = jooq;
        this.queue = queue;
        this.repository = repository;
        this.mapper = mapper;
        this.clock = clock;
        this.registry = registry;
        this.retryProperties = retryProperties;
        this.maxDepth = maxDepth;
        this.enqueueId = this.registry.createId("queue.pending.enqueue");
        this.cancelId = this.registry.createId("queue.pending.cancelled");
        this.popId = this.registry.createId("queue.pending.pop");
        CharSequence charSequence = this.shard;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Field<Object> field = shardField;
            Intrinsics.checkNotNullExpressionValue(field, (String)"shardField");
            condition = field.isNull();
        } else {
            condition = shardField.eq((Object)this.shard);
        }
        this.shardCondition = condition;
    }

    static {
        Companion = new Companion(null);
        pendingTable = DSL.table((String)"pending_executions");
        configField = DSL.field((String)"config_id");
        idField = DSL.field((String)"id");
        messageField = DSL.field((String)"message");
        shardField = DSL.field((String)"shard");
        retrySupport = new RetrySupport();
        Logger logger = LoggerFactory.getLogger(SqlPendingExecutionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026utionService::class.java)");
        log = logger;
    }

    public static final /* synthetic */ void access$doEnqueue(SqlPendingExecutionService $this, String pipelineConfigId, Message message) {
        $this.doEnqueue(pipelineConfigId, message);
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlPendingExecutionService $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ Table access$getPendingTable$cp() {
        return pendingTable;
    }

    public static final /* synthetic */ Field access$getIdField$cp() {
        return idField;
    }

    public static final /* synthetic */ Field access$getConfigField$cp() {
        return configField;
    }

    public static final /* synthetic */ Field access$getShardField$cp() {
        return shardField;
    }

    public static final /* synthetic */ Field access$getMessageField$cp() {
        return messageField;
    }

    public static final /* synthetic */ String access$getShard$p(SqlPendingExecutionService $this) {
        return $this.shard;
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(SqlPendingExecutionService $this) {
        return $this.mapper;
    }

    public static final /* synthetic */ Condition access$getShardCondition$p(SqlPendingExecutionService $this) {
        return $this.shardCondition;
    }

    public static final /* synthetic */ void access$setShardCondition$p(SqlPendingExecutionService $this, Condition condition) {
        $this.shardCondition = condition;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/orca/q/sql/pending/SqlPendingExecutionService$MessageContainer;", "", "id", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "orca-queue-sql"})
    private static final class MessageContainer {
        @NotNull
        private final String id;
        @NotNull
        private final String message;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public MessageContainer(@NotNull String id, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.id = id;
            this.message = message;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final MessageContainer copy(@NotNull String id, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new MessageContainer(id, message);
        }

        public static /* synthetic */ MessageContainer copy$default(MessageContainer messageContainer, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = messageContainer.id;
            }
            if ((n & 2) != 0) {
                string2 = messageContainer.message;
            }
            return messageContainer.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MessageContainer(id=" + this.id + ", message=" + this.message + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.message;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MessageContainer)) break block3;
                    MessageContainer messageContainer = (MessageContainer)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)messageContainer.id) || !Intrinsics.areEqual((Object)this.message, (Object)messageContainer.message)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/spinnaker/orca/q/sql/pending/SqlPendingExecutionService$Companion;", "", "()V", "configField", "Lorg/jooq/Field;", "kotlin.jvm.PlatformType", "idField", "log", "Lorg/slf4j/Logger;", "messageField", "pendingTable", "Lorg/jooq/Table;", "Lorg/jooq/Record;", "retrySupport", "Lcom/netflix/spinnaker/kork/core/RetrySupport;", "shardField", "orca-queue-sql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

