/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.spinnaker.config.ObjectMapperSubtypeProperties;
import com.netflix.spinnaker.config.SpringObjectMapperConfigurer;
import com.netflix.spinnaker.config.SqlQueueConfiguration;
import com.netflix.spinnaker.config.SqlQueueProperties;
import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.q.migration.ExecutionTypeDeserializer;
import com.netflix.spinnaker.orca.q.migration.TaskTypeDeserializer;
import com.netflix.spinnaker.q.metrics.EventPublisher;
import com.netflix.spinnaker.q.migration.SerializationMigrator;
import com.netflix.spinnaker.q.sql.SqlDeadMessageHandler;
import com.netflix.spinnaker.q.sql.SqlQueue;
import java.time.Clock;
import java.util.Collection;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ObjectMapperSubtypeProperties.class})
@ConditionalOnProperty(havingValue="true", matchIfMissing=false, value={"keiko.queue.sql.enabled"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017\u00a8\u0006\u001a"}, d2={"Lcom/netflix/spinnaker/config/SqlOrcaQueueConfiguration;", "Lcom/netflix/spinnaker/config/SqlQueueConfiguration;", "()V", "queue", "Lcom/netflix/spinnaker/q/sql/SqlQueue;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deadMessageHandler", "Lcom/netflix/spinnaker/q/sql/SqlDeadMessageHandler;", "publisher", "Lcom/netflix/spinnaker/q/metrics/EventPublisher;", "serializationMigrator", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/q/migration/SerializationMigrator;", "properties", "Lcom/netflix/spinnaker/config/SqlQueueProperties;", "sqlQueueObjectMapper", "", "objectMapperSubtypeProperties", "Lcom/netflix/spinnaker/config/ObjectMapperSubtypeProperties;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "orca-queue-sql"})
public class SqlOrcaQueueConfiguration
extends SqlQueueConfiguration {
    @Autowired
    public void sqlQueueObjectMapper(@NotNull ObjectMapper mapper, @NotNull ObjectMapperSubtypeProperties objectMapperSubtypeProperties, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)objectMapperSubtypeProperties, (String)"objectMapperSubtypeProperties");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        ObjectMapper objectMapper = mapper;
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        $this$apply.registerModule((Module)new KotlinModule.Builder().build());
        $this$apply.registerModule((Module)new SimpleModule().addDeserializer(ExecutionType.class, (JsonDeserializer)new ExecutionTypeDeserializer()).addDeserializer(Class.class, (JsonDeserializer)new TaskTypeDeserializer(taskResolver)));
        $this$apply.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties2 = objectMapperSubtypeProperties;
        boolean bl4 = false;
        boolean bl5 = false;
        ObjectMapperSubtypeProperties $this$apply2 = objectMapperSubtypeProperties2;
        boolean bl6 = false;
        $this$apply2.setMessagePackages(CollectionsKt.plus((Collection)$this$apply2.getMessagePackages(), (Iterable)CollectionsKt.listOf((Object)"com.netflix.spinnaker.orca.q")));
        $this$apply2.setAttributePackages(CollectionsKt.plus((Collection)$this$apply2.getAttributePackages(), (Iterable)CollectionsKt.listOf((Object)"com.netflix.spinnaker.orca.q")));
        Unit unit = Unit.INSTANCE;
        ObjectMapperSubtypeProperties objectMapperSubtypeProperties3 = objectMapperSubtypeProperties2;
        new SpringObjectMapperConfigurer(objectMapperSubtypeProperties3).registerSubtypes($this$apply);
    }

    @Bean
    @NotNull
    public SqlQueue queue(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper mapper, @NotNull SqlDeadMessageHandler deadMessageHandler, @NotNull EventPublisher publisher, @NotNull Optional<SerializationMigrator> serializationMigrator, @NotNull SqlQueueProperties properties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)deadMessageHandler, (String)"deadMessageHandler");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter(serializationMigrator, (String)"serializationMigrator");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SqlQueue(properties.getQueueName(), 1, jooq, clock, properties.getLockTtlSeconds(), mapper, serializationMigrator, properties.getAckTimeout(), CollectionsKt.listOf((Object)deadMessageHandler), false, publisher, properties.getRetries(), null, null, 12800, null);
    }
}

