/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OrcaSqlProperties;
import com.netflix.spinnaker.config.SqlPendingExecutionProperties;
import com.netflix.spinnaker.kork.sql.config.SqlProperties;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.sql.pending.SqlPendingExecutionService;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SqlProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JP\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017\u00a8\u0006\u0017"}, d2={"Lcom/netflix/spinnaker/config/SqlPendingExecutionConfiguration;", "", "()V", "sqlPendingExecutionService", "Lcom/netflix/spinnaker/orca/q/sql/pending/SqlPendingExecutionService;", "jooq", "Lorg/jooq/DSLContext;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "sqlProperties", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "orcaSqlProperties", "Lcom/netflix/spinnaker/config/OrcaSqlProperties;", "sqlPendingProperties", "Lcom/netflix/spinnaker/config/SqlPendingExecutionProperties;", "orca-queue-sql"})
public class SqlPendingExecutionConfiguration {
    @Bean
    @ConditionalOnProperty(value={"queue.pending-execution-service.sql.enabled"})
    @NotNull
    public SqlPendingExecutionService sqlPendingExecutionService(@NotNull DSLContext jooq, @NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull ObjectMapper mapper, @NotNull Clock clock, @NotNull Registry registry, @NotNull SqlProperties sqlProperties, @NotNull OrcaSqlProperties orcaSqlProperties, @NotNull SqlPendingExecutionProperties sqlPendingProperties) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)sqlProperties, (String)"sqlProperties");
        Intrinsics.checkNotNullParameter((Object)orcaSqlProperties, (String)"orcaSqlProperties");
        Intrinsics.checkNotNullParameter((Object)sqlPendingProperties, (String)"sqlPendingProperties");
        return new SqlPendingExecutionService(orcaSqlProperties.getPartitionName(), jooq, queue, repository, mapper, clock, registry, sqlProperties.getRetries().getTransactions(), sqlPendingProperties.getMaxDepth());
    }
}

