/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="resumeStage")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0015\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/netflix/spinnaker/orca/q/ResumeStage;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "source", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "stageId", "", "(Lcom/netflix/spinnaker/orca/q/ExecutionLevel;Ljava/lang/String;)V", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStageId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class ResumeStage
extends Message
implements StageLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @NotNull
    private final String stageId;

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public String getStageId() {
        return this.stageId;
    }

    public ResumeStage(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.stageId = stageId;
    }

    public ResumeStage(@NotNull ExecutionLevel source, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), stageId);
    }

    public ResumeStage(@NotNull StageExecution source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        PipelineExecution pipelineExecution = source.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"source.execution");
        ExecutionType executionType = pipelineExecution.getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"source.execution.type");
        PipelineExecution pipelineExecution2 = source.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"source.execution");
        String string = pipelineExecution2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.execution.id");
        PipelineExecution pipelineExecution3 = source.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"source.execution");
        String string2 = pipelineExecution3.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"source.execution.application");
        String string3 = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"source.id");
        this(executionType, string, string2, string3);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final String component4() {
        return this.getStageId();
    }

    @NotNull
    public final ResumeStage copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        return new ResumeStage(executionType, executionId, application, stageId);
    }

    public static /* synthetic */ ResumeStage copy$default(ResumeStage resumeStage, ExecutionType executionType, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = resumeStage.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = resumeStage.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = resumeStage.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = resumeStage.getStageId();
        }
        return resumeStage.copy(executionType, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "ResumeStage(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", stageId=" + this.getStageId() + ")";
    }

    public int hashCode() {
        ExecutionType executionType = this.getExecutionType();
        String string = this.getExecutionId();
        String string2 = this.getApplication();
        String string3 = this.getStageId();
        return (((executionType != null ? executionType.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ResumeStage)) break block3;
                ResumeStage resumeStage = (ResumeStage)object;
                if (!Intrinsics.areEqual((Object)this.getExecutionType(), (Object)resumeStage.getExecutionType()) || !Intrinsics.areEqual((Object)this.getExecutionId(), (Object)resumeStage.getExecutionId()) || !Intrinsics.areEqual((Object)this.getApplication(), (Object)resumeStage.getApplication()) || !Intrinsics.areEqual((Object)this.getStageId(), (Object)resumeStage.getStageId())) break block3;
            }
            return true;
        }
        return false;
    }
}

