/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.CancellableStage;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CancelStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RescheduleExecution;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.CancelStageHandler;
import com.netflix.spinnaker.orca.q.handler.CancelStageHandler$handle$1$$special$;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n  *\u0004\u0018\u00010\u001f0\u001f0\u0013*\u00020!8RX\u0092\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/CancelStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/CancelStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "executor", "Ljava/util/concurrent/Executor;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Ljava/util/concurrent/Executor;Lcom/netflix/spinnaker/orca/TaskResolver;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "type", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "kotlin.jvm.PlatformType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "getType$annotations", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)V", "getType", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)Ljava/lang/Class;", "handle", "", "message", "orca-queue"})
public class CancelStageHandler
implements OrcaMessageHandler<CancelStage>,
StageBuilderAware,
AuthenticationAware {
    @NotNull
    private final Class<CancelStage> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final StageNavigator stageNavigator;
    private final Executor executor;
    private final TaskResolver taskResolver;

    @NotNull
    public Class<CancelStage> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull CancelStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this){
            final /* synthetic */ CancelStageHandler this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                if (stage.getStatus() == ExecutionStatus.RUNNING) {
                    void $this$filterTo$iv$iv;
                    List list = stage.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stage.tasks");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TaskExecution it = (TaskExecution)element$iv$iv;
                        boolean bl = false;
                        TaskExecution taskExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
                        if (!(taskExecution.getStatus() == ExecutionStatus.RUNNING)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        TaskExecution it = (TaskExecution)element$iv;
                        boolean bl = false;
                        Queue queue = this.this$0.getQueue();
                        PipelineExecution pipelineExecution = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                        ExecutionType executionType = pipelineExecution.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"stage.execution.type");
                        PipelineExecution pipelineExecution2 = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"stage.execution");
                        String string = pipelineExecution2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.execution.id");
                        PipelineExecution pipelineExecution3 = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"stage.execution");
                        String string2 = pipelineExecution3.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stage.execution.application");
                        String string3 = stage.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stage.id");
                        TaskExecution taskExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
                        String string4 = taskExecution.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.id");
                        queue.reschedule((Message)new RunTask(executionType, string, string2, string3, string4, CancelStageHandler.access$getType$p(this.this$0, it)));
                    }
                }
                ExecutionStatus executionStatus = stage.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"stage.status");
                if (executionStatus.isHalt()) {
                    StageDefinitionBuilder stageDefinitionBuilder = this.this$0.builder(stage);
                    boolean bl = false;
                    boolean bl2 = false;
                    StageDefinitionBuilder builder = stageDefinitionBuilder;
                    boolean bl3 = false;
                    if (builder instanceof CancellableStage) {
                        Callable cancellationClosure = AuthenticatedRequest.propagate((Callable)new Callable<Unit>(builder, this, stage){
                            final /* synthetic */ StageDefinitionBuilder $builder;
                            final /* synthetic */ handle.1 this$0;
                            final /* synthetic */ StageExecution $stage$inlined;
                            {
                                this.$builder = stageDefinitionBuilder;
                                this.this$0 = var2_2;
                                this.$stage$inlined = stageExecution;
                            }

                            public final void call() {
                                this.this$0.this$0.withAuth(this.$stage$inlined, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                                    final /* synthetic */ handle$1$$special$$inlined$let$lambda$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        ((CancellableStage)this.this$0.$builder).cancel(this.this$0.$stage$inlined);
                                    }
                                }));
                                if (StringsKt.equals((String)this.$stage$inlined.getType(), (String)"pipeline", (boolean)true) && this.$stage$inlined.getContext().containsKey("executionId")) {
                                    String childId;
                                    V v = this.$stage$inlined.getContext().get("executionId");
                                    if (!(v instanceof String)) {
                                        v = null;
                                    }
                                    if ((childId = (String)v) != null) {
                                        PipelineExecution pipelineExecution = this.this$0.this$0.getRepository().retrieve(ExecutionType.PIPELINE, childId);
                                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"repository.retrieve(PIPELINE, childId)");
                                        PipelineExecution child = pipelineExecution;
                                        this.this$0.this$0.getQueue().push((Message)new RescheduleExecution(child));
                                    }
                                }
                            }
                        });
                        CancelStageHandler.access$getExecutor$p(this.this$0).execute(new Runnable(cancellationClosure){
                            final /* synthetic */ Callable $cancellationClosure;

                            public final void run() {
                                this.$cancellationClosure.call();
                            }
                            {
                                this.$cancellationClosure = callable;
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = cancelStageHandler;
                super(1);
            }
        }));
    }

    private static /* synthetic */ void getType$annotations(TaskExecution taskExecution) {
    }

    private Class<? extends Task> getType(TaskExecution $this$type) {
        Class clazz = this.taskResolver.getTaskClass($this$type.getImplementingClass());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"taskResolver.getTaskClass(implementingClass)");
        return clazz;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    public CancelStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull StageNavigator stageNavigator, @Qualifier(value="cancellableStageExecutor") @NotNull Executor executor, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        this.queue = queue;
        this.repository = repository;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.stageNavigator = stageNavigator;
        this.executor = executor;
        this.taskResolver = taskResolver;
        this.messageType = CancelStage.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        Intrinsics.checkNotNullParameter((Object)$this$builder, (String)"$this$builder");
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withAuth, (String)"$this$withAuth");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    public static final /* synthetic */ Class access$getType$p(CancelStageHandler $this, TaskExecution $this$access_u24type_u24p) {
        return $this.getType($this$access_u24type_u24p);
    }

    public static final /* synthetic */ Executor access$getExecutor$p(CancelStageHandler $this) {
        return $this.executor;
    }
}

