/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.jackson.OrcaObjectMapper;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.ContinueParentStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.InvalidExecutionId;
import com.netflix.spinnaker.orca.q.InvalidStageId;
import com.netflix.spinnaker.orca.q.InvalidTaskId;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.MessageHandler;
import com.netflix.spinnaker.q.Queue;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func1;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0016J*\u0010\u000b\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u0015*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J \u0010\u001b\u001a\u00020\u0015*\u00020\u001c2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J&\u0010\u001d\u001a\u00020\u0015*\u00020\u001e2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001fH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "M", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/q/MessageHandler;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "shouldQueue", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "shouldRetry", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler$Response;", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "taskName", "", "startNext", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "withExecution", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "block", "Lkotlin/Function1;", "withStage", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "withTask", "Lcom/netflix/spinnaker/orca/q/TaskLevel;", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "Companion", "orca-queue"})
public interface OrcaMessageHandler<M extends Message>
extends MessageHandler<M> {
    public static final Companion Companion = com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler$Companion.$$INSTANCE;

    @NotNull
    public ExecutionRepository getRepository();

    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> var1, @NotNull Exception var2, @Nullable String var3);

    public void withTask(@NotNull TaskLevel var1, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> var2);

    public void withStage(@NotNull StageLevel var1, @NotNull Function1<? super StageExecution, Unit> var2);

    public void withExecution(@NotNull ExecutionLevel var1, @NotNull Function1<? super PipelineExecution, Unit> var2);

    public void startNext(@NotNull StageExecution var1);

    public boolean shouldQueue(@NotNull PipelineExecution var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static <M extends Message> ExceptionHandler.Response shouldRetry(@NotNull OrcaMessageHandler<M> $this, @NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
            ExceptionHandler.Response response;
            ExceptionHandler exceptionHandler;
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                Iterable iterable = $this$shouldRetry;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ExceptionHandler it = (ExceptionHandler)t;
                    boolean bl3 = false;
                    if (!it.handles(ex)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            ExceptionHandler exceptionHandler2 = exceptionHandler = (ExceptionHandler)v0;
            if (exceptionHandler2 != null) {
                String string = taskName;
                if (string == null) {
                    string = "unspecified";
                }
                response = exceptionHandler2.handle(string, ex);
            } else {
                response = null;
            }
            return response;
        }

        public static <M extends Message> void withTask(@NotNull OrcaMessageHandler<M> $this, @NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this.withStage($this$withTask, (Function1<StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>($this, $this$withTask, block){
                final /* synthetic */ OrcaMessageHandler this$0;
                final /* synthetic */ TaskLevel $this_withTask;
                final /* synthetic */ Function2 $block;

                public final void invoke(@NotNull StageExecution stage) {
                    Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                    TaskExecution taskExecution = stage.taskById(this.$this_withTask.getTaskId());
                    boolean bl = false;
                    boolean bl2 = false;
                    TaskExecution task = taskExecution;
                    boolean bl3 = false;
                    if (task == null) {
                        OrcaMessageHandler.Companion.getLog().error("InvalidTaskId: Unable to find task {} in stage '{}' while processing message {}", new Object[]{this.$this_withTask.getTaskId(), OrcaMessageHandler.Companion.getMapper().writeValueAsString((Object)stage), this.$this_withTask});
                        this.this$0.getQueue().push((Message)new InvalidTaskId(this.$this_withTask));
                    } else {
                        this.$block.invoke((Object)stage, (Object)task);
                    }
                }
                {
                    this.this$0 = orcaMessageHandler;
                    this.$this_withTask = taskLevel;
                    this.$block = function2;
                    super(1);
                }
            }));
        }

        public static <M extends Message> void withStage(@NotNull OrcaMessageHandler<M> $this, @NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this.withExecution($this$withStage, (Function1<PipelineExecution, Unit>)((Function1)new Function1<PipelineExecution, Unit>($this, $this$withStage, block){
                final /* synthetic */ OrcaMessageHandler this$0;
                final /* synthetic */ StageLevel $this_withStage;
                final /* synthetic */ Function1 $block;

                public final void invoke(@NotNull PipelineExecution execution) {
                    Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                    try {
                        StageExecution stageExecution = execution.stageById(this.$this_withStage.getStageId());
                        boolean bl = false;
                        boolean bl2 = false;
                        StageExecution it = stageExecution;
                        boolean bl3 = false;
                        StageExecution stageExecution2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)stageExecution2, (String)"it");
                        new StageExecutionImpl(execution, stageExecution2.getType(), it.getContext());
                        Function1 function1 = this.$block;
                        bl2 = false;
                        boolean bl4 = false;
                        function1.invoke((Object)stageExecution);
                    }
                    catch (IllegalArgumentException e) {
                        OrcaMessageHandler.Companion.getLog().error("Failed to locate stage with id: {}", (Object)this.$this_withStage.getStageId(), (Object)e);
                        this.this$0.getQueue().push((Message)new InvalidStageId(this.$this_withStage));
                    }
                }
                {
                    this.this$0 = orcaMessageHandler;
                    this.$this_withStage = stageLevel;
                    this.$block = function1;
                    super(1);
                }
            }));
        }

        public static <M extends Message> void withExecution(@NotNull OrcaMessageHandler<M> $this, @NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                PipelineExecution pipelineExecution = $this.getRepository().retrieve($this$withExecution.getExecutionType(), $this$withExecution.getExecutionId());
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"repository.retrieve(executionType, executionId)");
                PipelineExecution execution = pipelineExecution;
                block.invoke((Object)execution);
            }
            catch (ExecutionNotFoundException e) {
                $this.getQueue().push((Message)new InvalidExecutionId($this$withExecution));
            }
        }

        public static <M extends Message> void startNext(@NotNull OrcaMessageHandler<M> $this, @NotNull StageExecution $this$startNext) {
            Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
            PipelineExecution pipelineExecution = $this$startNext.getExecution();
            boolean bl = false;
            boolean bl2 = false;
            PipelineExecution execution = pipelineExecution;
            boolean bl3 = false;
            List list = $this$startNext.downstreamStages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"downstreamStages()");
            List downstreamStages = list;
            SyntheticStageOwner phase = $this$startNext.getSyntheticStageOwner();
            Collection collection = downstreamStages;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                Iterable $this$forEach$iv = downstreamStages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl5 = false;
                    Queue queue = $this.getQueue();
                    StageExecution stageExecution = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                    queue.push((Message)new StartStage(stageExecution));
                }
            } else if (phase != null) {
                Queue queue = $this.getQueue();
                Message message = new ContinueParentStage(StageKt.parent((StageExecution)$this$startNext), phase);
                Duration duration = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
                queue.ensure(message, (TemporalAmount)duration);
            } else {
                Queue queue = $this.getQueue();
                PipelineExecution pipelineExecution2 = execution;
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"execution");
                queue.push((Message)new CompleteExecution(pipelineExecution2));
            }
        }

        public static <M extends Message> boolean shouldQueue(@NotNull OrcaMessageHandler<M> $this, @NotNull PipelineExecution $this$shouldQueue) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
            String configId = $this$shouldQueue.getPipelineConfigId();
            if (!$this$shouldQueue.isLimitConcurrent()) {
                bl = false;
            } else if (configId == null) {
                bl = false;
            } else {
                ExecutionRepository.ExecutionCriteria executionCriteria = new ExecutionRepository.ExecutionCriteria().setPageSize(2).setStatuses(new ExecutionStatus[]{ExecutionStatus.RUNNING});
                Intrinsics.checkNotNullExpressionValue((Object)executionCriteria, (String)"ExecutionCriteria().setP\u2026e(2).setStatuses(RUNNING)");
                ExecutionRepository.ExecutionCriteria criteria = executionCriteria;
                bl = ((Number)$this.getRepository().retrievePipelinesForPipelineConfigId(configId, criteria).filter((Func1)new Func1<PipelineExecution, Boolean>($this$shouldQueue){
                    final /* synthetic */ PipelineExecution $this_shouldQueue;

                    public final Boolean call(PipelineExecution it) {
                        PipelineExecution pipelineExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"it");
                        return Intrinsics.areEqual((Object)pipelineExecution.getId(), (Object)this.$this_shouldQueue.getId()) ^ true;
                    }
                    {
                        this.$this_shouldQueue = pipelineExecution;
                    }
                }).count().toBlocking().first()).intValue() > 0;
            }
            return bl;
        }

        public static <M extends Message> void invoke(@NotNull OrcaMessageHandler<M> $this, @NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            MessageHandler.DefaultImpls.invoke((MessageHandler)$this, (Message)message);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "orca-queue"})
    public static final class Companion {
        @NotNull
        private static final Logger log;
        @NotNull
        private static final ObjectMapper mapper;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            Logger logger = LoggerFactory.getLogger(companion.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(this::class.java)");
            log = logger;
            ObjectMapper objectMapper = OrcaObjectMapper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"OrcaObjectMapper.getInstance()");
            mapper = objectMapper;
        }
    }
}

