/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RescheduleExecution;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/RescheduleExecutionHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/RescheduleExecution;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/TaskResolver;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "handle", "", "message", "orca-queue"})
public class RescheduleExecutionHandler
implements OrcaMessageHandler<RescheduleExecution> {
    @NotNull
    private final Class<RescheduleExecution> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    private final TaskResolver taskResolver;

    @NotNull
    public Class<RescheduleExecution> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull RescheduleExecution message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withExecution(message, (Function1<? super PipelineExecution, Unit>)((Function1)new Function1<PipelineExecution, Unit>(this, message){
            final /* synthetic */ RescheduleExecutionHandler this$0;
            final /* synthetic */ RescheduleExecution $message;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PipelineExecution execution) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                List list = execution.getStages();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution\n        .stages");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    StageExecution it = (StageExecution)element$iv$iv;
                    boolean bl2 = false;
                    StageExecution stageExecution = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                    if (!(stageExecution.getStatus() == ExecutionStatus.RUNNING)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    void $this$filterTo$iv$iv2;
                    StageExecution stage = (StageExecution)element$iv;
                    boolean bl = false;
                    StageExecution stageExecution = stage;
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"stage");
                    List list2 = stageExecution.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"stage.tasks");
                    Iterable $this$filter$iv2 = list2;
                    boolean $i$f$filter2 = false;
                    Iterable bl2 = $this$filter$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo2 = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv2) {
                        TaskExecution it = (TaskExecution)element$iv$iv;
                        boolean bl3 = false;
                        TaskExecution taskExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
                        if (!(taskExecution.getStatus() == ExecutionStatus.RUNNING)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv2 = (List)destination$iv$iv2;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        TaskExecution it = (TaskExecution)element$iv2;
                        boolean bl4 = false;
                        Queue queue = this.this$0.getQueue();
                        ExecutionLevel executionLevel = this.$message;
                        String string = stage.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.id");
                        TaskExecution taskExecution = it;
                        Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
                        String string2 = taskExecution.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.id");
                        Class clazz = RescheduleExecutionHandler.access$getTaskResolver$p(this.this$0).getTaskClass(it.getImplementingClass());
                        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"taskResolver.getTaskClass(it.implementingClass)");
                        queue.reschedule((Message)new RunTask(executionLevel, string, string2, clazz));
                    }
                }
            }
            {
                this.this$0 = rescheduleExecutionHandler;
                this.$message = rescheduleExecution;
                super(1);
            }
        }));
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    public RescheduleExecutionHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        this.queue = queue;
        this.repository = repository;
        this.taskResolver = taskResolver;
        this.messageType = RescheduleExecution.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    public static final /* synthetic */ TaskResolver access$getTaskResolver$p(RescheduleExecutionHandler $this) {
        return $this.taskResolver;
    }
}

