/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.model.PipelineTrigger;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RestartStage;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0012J\u0016\u0010#\u001a\u00020\u001e*\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0012J\f\u0010&\u001a\u00020\u001e*\u00020\"H\u0012J\f\u0010'\u001a\u00020\u001e*\u00020\"H\u0012J\f\u0010(\u001a\u00020\u001e*\u00020\"H\u0012R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/RestartStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/RestartStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "clock", "Ljava/time/Clock;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;Ljava/time/Clock;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "handle", "", "message", "restartParentPipelineIfNeeded", "topStage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "addRestartDetails", "user", "", "addSkipRestart", "removeSynthetics", "reset", "orca-queue"})
public class RestartStageHandler
implements OrcaMessageHandler<RestartStage>,
StageBuilderAware {
    @NotNull
    private final Class<RestartStage> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    private final PendingExecutionService pendingExecutionService;
    private final Clock clock;

    @NotNull
    public Class<RestartStage> getMessageType() {
        return this.messageType;
    }

    private Logger getLog() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        return logger;
    }

    public void handle(@NotNull RestartStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, message){
            final /* synthetic */ RestartStageHandler this$0;
            final /* synthetic */ RestartStage $message;

            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                PipelineExecution pipelineExecution = stage.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                if (this.this$0.shouldQueue(pipelineExecution)) {
                    PipelineExecution pipelineExecution2 = stage.getExecution();
                    Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"stage.execution");
                    String string = pipelineExecution2.getPipelineConfigId();
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        Logger logger = RestartStageHandler.access$getLog$p(this.this$0);
                        Object[] objectArray = new Object[3];
                        PipelineExecution pipelineExecution3 = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"stage.execution");
                        objectArray[0] = pipelineExecution3.getApplication();
                        PipelineExecution pipelineExecution4 = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution4, (String)"stage.execution");
                        objectArray[1] = pipelineExecution4.getName();
                        PipelineExecution pipelineExecution5 = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution5, (String)"stage.execution");
                        objectArray[2] = pipelineExecution5.getId();
                        logger.info("Queueing restart of {} {} {}", objectArray);
                        RestartStageHandler.access$getPendingExecutionService$p(this.this$0).enqueue(it, this.$message);
                    }
                } else {
                    StageExecution stageExecution = stage.getTopLevelStage();
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"stage.topLevelStage");
                    StageExecution topStage = stageExecution;
                    ExecutionType executionType = this.$message.getExecutionType();
                    String string = this.$message.getExecutionId();
                    String string3 = this.$message.getApplication();
                    String string4 = topStage.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"topStage.id");
                    StartStage startMessage = new StartStage(executionType, string, string3, string4);
                    ExecutionStatus executionStatus = topStage.getStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"topStage.status");
                    if (executionStatus.isComplete()) {
                        RestartStageHandler.access$addRestartDetails(this.this$0, topStage, this.$message.getUser());
                        RestartStageHandler.access$reset(this.this$0, topStage);
                        RestartStageHandler.access$restartParentPipelineIfNeeded(this.this$0, this.$message, topStage);
                        topStage.getExecution().updateStatus(ExecutionStatus.RUNNING);
                        this.this$0.getRepository().updateStatus(topStage.getExecution());
                        this.this$0.getQueue().push((Message)new StartStage(startMessage));
                    }
                }
            }
            {
                this.this$0 = restartStageHandler;
                this.$message = restartStage;
                super(1);
            }
        }));
    }

    private void restartParentPipelineIfNeeded(RestartStage message, StageExecution topStage) {
        StageExecution parentStage;
        PipelineExecution pipelineExecution = topStage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"topStage.execution");
        if (!(pipelineExecution.getTrigger() instanceof PipelineTrigger)) {
            return;
        }
        PipelineExecution pipelineExecution2 = topStage.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"topStage.execution");
        Trigger trigger = pipelineExecution2.getTrigger();
        if (trigger == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.orca.pipeline.model.PipelineTrigger");
        }
        PipelineTrigger trigger2 = (PipelineTrigger)trigger;
        if (trigger2.getParentPipelineStageId() == null) {
            return;
        }
        PipelineExecution pipelineExecution3 = this.getRepository().retrieve(trigger2.getParentExecution().getType(), trigger2.getParentExecution().getId());
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"repository.retrieve(trig\u2026igger.parentExecution.id)");
        PipelineExecution parentExecution = pipelineExecution3;
        if (!parentExecution.getStatus().isComplete()) {
            return;
        }
        StageExecution stageExecution = parentStage = parentExecution.stageById(trigger2.getParentPipelineStageId());
        Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"parentStage");
        this.addSkipRestart(stageExecution);
        this.getRepository().storeStage(parentStage);
        Queue queue = this.getQueue();
        PipelineExecution pipelineExecution4 = trigger2.getParentExecution();
        String string = parentStage.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentStage.id");
        queue.push((Message)new RestartStage(pipelineExecution4, string, message.getUser()));
    }

    private void addSkipRestart(StageExecution $this$addSkipRestart) {
        Map map = $this$addSkipRestart.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context");
        map.put("_skipPipelineRestart", true);
    }

    private void addRestartDetails(StageExecution $this$addRestartDetails, String user) {
        Map map = $this$addRestartDetails.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context");
        Pair[] pairArray = new Pair[3];
        String string = user;
        if (string == null) {
            string = "anonymous";
        }
        pairArray[0] = TuplesKt.to((Object)"restartedBy", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"restartTime", (Object)this.clock.millis());
        pairArray[2] = TuplesKt.to((Object)"previousException", $this$addRestartDetails.getContext().remove("exception"));
        map.put("restartDetails", MapsKt.mapOf((Pair[])pairArray));
    }

    private void reset(StageExecution $this$reset) {
        ExecutionStatus executionStatus = $this$reset.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"status");
        if (executionStatus.isComplete()) {
            $this$reset.setStatus(ExecutionStatus.NOT_STARTED);
            $this$reset.setStartTime((Long)null);
            $this$reset.setEndTime((Long)null);
            $this$reset.setTasks(CollectionsKt.emptyList());
            this.builder($this$reset).prepareStageForRestart($this$reset);
            this.getRepository().storeStage($this$reset);
            this.removeSynthetics($this$reset);
        }
        List list = $this$reset.downstreamStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"downstreamStages()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StageExecution it = (StageExecution)element$iv;
            boolean bl = false;
            StageExecution stageExecution = it;
            Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
            this.reset(stageExecution);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeSynthetics(StageExecution $this$removeSynthetics) {
        void $this$filterTo$iv$iv;
        PipelineExecution pipelineExecution = $this$removeSynthetics.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
        List list = pipelineExecution.getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution\n      .stages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            StageExecution stageExecution = it;
            Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
            if (!Intrinsics.areEqual((Object)stageExecution.getParentStageId(), (Object)$this$removeSynthetics.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StageExecution it = (StageExecution)element$iv;
            boolean bl = false;
            StageExecution stageExecution = it;
            Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
            this.removeSynthetics(stageExecution);
            this.getRepository().removeStage($this$removeSynthetics.getExecution(), it.getId());
        }
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    public RestartStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull PendingExecutionService pendingExecutionService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"pendingExecutionService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.queue = queue;
        this.repository = repository;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.pendingExecutionService = pendingExecutionService;
        this.clock = clock;
        this.messageType = RestartStage.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        Intrinsics.checkNotNullParameter((Object)$this$builder, (String)"$this$builder");
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    public static final /* synthetic */ Logger access$getLog$p(RestartStageHandler $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ PendingExecutionService access$getPendingExecutionService$p(RestartStageHandler $this) {
        return $this.pendingExecutionService;
    }

    public static final /* synthetic */ void access$addRestartDetails(RestartStageHandler $this, StageExecution $this$access_u24addRestartDetails, String user) {
        $this.addRestartDetails($this$access_u24addRestartDetails, user);
    }

    public static final /* synthetic */ void access$reset(RestartStageHandler $this, StageExecution $this$access_u24reset) {
        $this.reset($this$access_u24reset);
    }

    public static final /* synthetic */ void access$restartParentPipelineIfNeeded(RestartStageHandler $this, RestartStage message, StageExecution topStage) {
        $this.restartParentPipelineIfNeeded(message, topStage);
    }
}

