/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.OverridableTimeoutRetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskExecutionInterceptor;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.clouddriver.utils.CloudProviderAware;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.exceptions.TimeoutException;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CompleteTask;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.InvalidTaskType;
import com.netflix.spinnaker.orca.q.PauseTask;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.RunTaskHandler;
import com.netflix.spinnaker.orca.q.handler.RunTaskHandler$WhenMappings;
import com.netflix.spinnaker.orca.q.metrics.MetricsTagHelper;
import com.netflix.spinnaker.orca.time.TimeKt;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004Bi\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020/H\u0012J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0012J\u0010\u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020\u0002H\u0016J(\u0010>\u001a\u0002062\u0006\u00107\u001a\u00020/2\u0006\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0012J\u001c\u0010D\u001a\u00020E*\u00020F2\u0006\u0010@\u001a\u00020A2\u0006\u00107\u001a\u00020/H\u0012J$\u0010G\u001a\u000206*\u00020F2\u0006\u0010@\u001a\u00020A2\u0006\u00107\u001a\u00020/2\u0006\u0010=\u001a\u00020HH\u0012J$\u0010I\u001a\u000206*\u00020F2\u0006\u00107\u001a\u00020/2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020HH\u0012J\u0012\u0010J\u001a\u00020;*\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0012J\u0016\u0010K\u001a\u00020L*\u00020L2\b\u0010M\u001a\u0004\u0018\u00010LH\u0012J\u0016\u0010N\u001a\u00020.*\u00020O2\b\u0010P\u001a\u0004\u0018\u00010QH\u0012J\u0014\u0010R\u001a\u000206*\u00020/2\u0006\u0010S\u001a\u00020LH\u0012J\u001c\u0010T\u001a\u00020;*\u00020U2\u0006\u0010@\u001a\u00020A2\u0006\u00107\u001a\u00020/H\u0012J4\u0010V\u001a\n X*\u0004\u0018\u00010W0W*\u00020\u00192\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u0002092\u0006\u0010\\\u001a\u0002092\u0006\u0010]\u001a\u000209H\u0012J\"\u0010^\u001a\u000206*\u00020/2\u0006\u0010@\u001a\u00020A2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002060`H\u0012J,\u0010a\u001a\u000206*\u00020\u00022\u001e\u0010_\u001a\u001a\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u0002060bH\u0012R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010-\u001a\u00020.*\u00020/8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u0004\u0018\u00010/*\u00020/8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006c"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/RunTaskHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/RunTask;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "clock", "Ljava/time/Clock;", "exceptionHandlers", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "taskExecutionInterceptors", "Lcom/netflix/spinnaker/orca/api/pipeline/TaskExecutionInterceptor;", "registry", "Lcom/netflix/spectator/api/Registry;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lcom/netflix/spinnaker/orca/TaskResolver;Ljava/time/Clock;Ljava/util/List;Ljava/util/List;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "warningInvocationTimeMs", "", "duration", "Ljava/time/Duration;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "getDuration", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)Ljava/time/Duration;", "executionWindow", "getExecutionWindow", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "checkForStageTimeout", "", "stage", "formatTimeout", "", "timeout", "", "handle", "message", "trackResult", "thisInvocationStartTimeMs", "taskModel", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "status", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "backoffPeriod", "Ljava/time/temporal/TemporalAmount;", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "checkForTaskTimeout", "Lcom/netflix/spinnaker/q/Message;", "checkForTimeout", "maxBackoff", "mergeOutputs", "Lcom/netflix/spinnaker/orca/api/pipeline/TaskResult;", "taskResult", "pausedDurationRelativeTo", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "instant", "Ljava/time/Instant;", "processTaskOutput", "result", "retryableBackOffPeriod", "Lcom/netflix/spinnaker/orca/api/pipeline/RetryableTask;", "timeoutCounter", "Lcom/netflix/spectator/api/Counter;", "kotlin.jvm.PlatformType", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "application", "stageType", "taskType", "withLoggingContext", "block", "Lkotlin/Function0;", "withTask", "Lkotlin/Function3;", "orca-queue"})
public class RunTaskHandler
implements OrcaMessageHandler<RunTask>,
ExpressionAware,
AuthenticationAware {
    private final int warningInvocationTimeMs;
    @NotNull
    private final Class<RunTask> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageNavigator stageNavigator;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    private final TaskResolver taskResolver;
    private final Clock clock;
    private final List<ExceptionHandler> exceptionHandlers;
    private final List<TaskExecutionInterceptor> taskExecutionInterceptors;
    private final Registry registry;
    private final DynamicConfigService dynamicConfigService;

    public void handle(@NotNull RunTask message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withTask(message, (Function3<? super StageExecution, ? super TaskExecution, ? super Task, Unit>)((Function3)new Function3<StageExecution, TaskExecution, Task, Unit>(this, message){
            final /* synthetic */ RunTaskHandler this$0;
            final /* synthetic */ RunTask $message;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StageExecution origStage, @NotNull TaskExecution taskModel, @NotNull Task task) {
                void stage;
                Intrinsics.checkNotNullParameter((Object)origStage, (String)"origStage");
                Intrinsics.checkNotNullParameter((Object)taskModel, (String)"taskModel");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = origStage;
                this.this$0.withAuth((StageExecution)stage.element, (Function0<Unit>)((Function0)new Function0<Unit>(this, (Ref.ObjectRef)stage, taskModel, task){
                    final /* synthetic */ handle.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $stage;
                    final /* synthetic */ TaskExecution $taskModel;
                    final /* synthetic */ Task $task;

                    public final void invoke() {
                        RunTaskHandler.access$withLoggingContext(this.this$0.this$0, (StageExecution)this.$stage.element, this.$taskModel, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ handle.1 this$0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke() {
                                block30: {
                                    if (this.this$0.$task.getClass().isAnnotationPresent(Deprecated.class)) {
                                        this.this$0.this$0.this$0.getLog().warn("deprecated-task-run " + this.this$0.$task.getClass().getSimpleName());
                                    }
                                    long thisInvocationStartTimeMs = RunTaskHandler.access$getClock$p(this.this$0.this$0.this$0).millis();
                                    PipelineExecution pipelineExecution = ((StageExecution)this.this$0.$stage.element).getExecution();
                                    Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                                    PipelineExecution execution = pipelineExecution;
                                    TaskResult taskResult = null;
                                    Exception taskException = null;
                                    try {
                                        TaskExecutionInterceptor t;
                                        boolean $i$f$forEach;
                                        Iterable $this$forEach$iv;
                                        block31: {
                                            $this$forEach$iv = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0.this$0.this$0);
                                            $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                t = (TaskExecutionInterceptor)element$iv;
                                                boolean bl = false;
                                                Ref.ObjectRef objectRef = this.this$0.$stage;
                                                Intrinsics.checkNotNullExpressionValue((Object)t.beforeTaskExecution(this.this$0.$task, (StageExecution)this.this$0.$stage.element), (String)"t.beforeTaskExecution(task, stage)");
                                                objectRef.element = objectRef.element;
                                            }
                                            if (execution.isCanceled()) {
                                                TaskResult taskResult2 = this.this$0.$task.onCancelWithResult((StageExecution)this.this$0.$stage.element);
                                                if (taskResult2 != null) {
                                                    $this$forEach$iv = taskResult2;
                                                    $i$f$forEach = false;
                                                    boolean bl = false;
                                                    Iterable $this$run = $this$forEach$iv;
                                                    boolean bl2 = false;
                                                    RunTaskHandler runTaskHandler = this.this$0.this$0.this$0;
                                                    StageExecution stageExecution = (StageExecution)this.this$0.$stage.element;
                                                    Iterable iterable = $this$run;
                                                    Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"this");
                                                    RunTaskHandler.access$processTaskOutput(runTaskHandler, stageExecution, (TaskResult)iterable);
                                                }
                                                this.this$0.this$0.this$0.getQueue().push((Message)new CompleteTask(this.this$0.this$0.$message, ExecutionStatus.CANCELED));
                                                break block30;
                                            }
                                            ExecutionStatus executionStatus = execution.getStatus();
                                            Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"execution.status");
                                            if (executionStatus.isComplete()) {
                                                this.this$0.this$0.this$0.getQueue().push((Message)new CompleteTask(this.this$0.this$0.$message, ExecutionStatus.CANCELED));
                                                break block30;
                                            }
                                            if (execution.getStatus() == ExecutionStatus.PAUSED) {
                                                this.this$0.this$0.this$0.getQueue().push((Message)new PauseTask(this.this$0.this$0.$message));
                                                break block30;
                                            }
                                            if (StageKt.isManuallySkipped((StageExecution)((StageExecution)this.this$0.$stage.element))) {
                                                this.this$0.this$0.this$0.getQueue().push((Message)new CompleteTask(this.this$0.this$0.$message, ExecutionStatus.SKIPPED));
                                                break block30;
                                            }
                                            try {
                                                RunTaskHandler.access$checkForTimeout(this.this$0.this$0.this$0, this.this$0.$task, (StageExecution)this.this$0.$stage.element, this.this$0.$taskModel, this.this$0.this$0.$message);
                                            }
                                            catch (TimeoutException e) {
                                                RunTaskHandler runTaskHandler = this.this$0.this$0.this$0;
                                                Registry registry = RunTaskHandler.access$getRegistry$p(this.this$0.this$0.this$0);
                                                PipelineExecution pipelineExecution2 = ((StageExecution)this.this$0.$stage.element).getExecution();
                                                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"stage.execution");
                                                ExecutionType executionType = pipelineExecution2.getType();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"stage.execution.type");
                                                PipelineExecution pipelineExecution3 = ((StageExecution)this.this$0.$stage.element).getExecution();
                                                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"stage.execution");
                                                String string = pipelineExecution3.getApplication();
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.execution.application");
                                                String string2 = ((StageExecution)this.this$0.$stage.element).getType();
                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stage.type");
                                                String string3 = this.this$0.$taskModel.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"taskModel.name");
                                                RunTaskHandler.access$timeoutCounter(runTaskHandler, registry, executionType, string, string2, string3).increment();
                                                taskResult = this.this$0.$task.onTimeout((StageExecution)this.this$0.$stage.element);
                                                if (taskResult == null) {
                                                    throw (Throwable)e;
                                                }
                                                if (SetsKt.setOf((Object[])new ExecutionStatus[]{ExecutionStatus.TERMINAL, ExecutionStatus.FAILED_CONTINUE}).contains(taskResult.getStatus())) break block31;
                                                this.this$0.this$0.this$0.getLog().error("Task " + this.this$0.$task.getClass().getName() + " returned invalid status (" + taskResult.getStatus() + ") for onTimeout");
                                                throw (Throwable)e;
                                            }
                                        }
                                        if (taskResult == null) {
                                            taskResult = this.this$0.$task.execute(this.this$0.this$0.this$0.withMergedContext((StageExecution)this.this$0.$stage.element));
                                            $this$forEach$iv = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0.this$0.this$0);
                                            $i$f$forEach = false;
                                            for (T element$iv : $this$forEach$iv) {
                                                t = (TaskExecutionInterceptor)element$iv;
                                                boolean bl = false;
                                                taskResult = t.afterTaskExecution(this.this$0.$task, (StageExecution)this.this$0.$stage.element, taskResult);
                                            }
                                        }
                                        TaskResult taskResult3 = taskResult;
                                        Intrinsics.checkNotNull((Object)taskResult3);
                                        $this$forEach$iv = taskResult3;
                                        $i$f$forEach = false;
                                        boolean bl = false;
                                        Iterable result = $this$forEach$iv;
                                        boolean bl3 = false;
                                        switch (RunTaskHandler$WhenMappings.$EnumSwitchMapping$0[result.getStatus().ordinal()]) {
                                            case 1: {
                                                RunTaskHandler.access$processTaskOutput(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, (TaskResult)result);
                                                this.this$0.this$0.this$0.getQueue().push((Message)this.this$0.this$0.$message, RunTaskHandler.access$backoffPeriod(this.this$0.this$0.this$0, this.this$0.$task, this.this$0.$taskModel, (StageExecution)this.this$0.$stage.element));
                                                RunTaskHandler runTaskHandler = this.this$0.this$0.this$0;
                                                StageExecution stageExecution = (StageExecution)this.this$0.$stage.element;
                                                TaskExecution taskExecution = this.this$0.$taskModel;
                                                ExecutionStatus executionStatus = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"result.status");
                                                RunTaskHandler.access$trackResult(runTaskHandler, stageExecution, thisInvocationStartTimeMs, taskExecution, executionStatus);
                                                break;
                                            }
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: {
                                                RunTaskHandler.access$processTaskOutput(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, (TaskResult)result);
                                                Queue queue = this.this$0.this$0.this$0.getQueue();
                                                TaskLevel taskLevel = this.this$0.this$0.$message;
                                                ExecutionStatus executionStatus = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"result.status");
                                                queue.push((Message)new CompleteTask(taskLevel, executionStatus));
                                                RunTaskHandler runTaskHandler = this.this$0.this$0.this$0;
                                                StageExecution stageExecution = (StageExecution)this.this$0.$stage.element;
                                                TaskExecution taskExecution = this.this$0.$taskModel;
                                                ExecutionStatus executionStatus2 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus2, (String)"result.status");
                                                RunTaskHandler.access$trackResult(runTaskHandler, stageExecution, thisInvocationStartTimeMs, taskExecution, executionStatus2);
                                                break;
                                            }
                                            case 7: {
                                                RunTaskHandler.access$processTaskOutput(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, RunTaskHandler.access$mergeOutputs(this.this$0.this$0.this$0, (TaskResult)result, this.this$0.$task.onCancelWithResult((StageExecution)this.this$0.$stage.element)));
                                                StageExecution stageExecution = (StageExecution)this.this$0.$stage.element;
                                                ExecutionStatus executionStatus = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"result.status");
                                                ExecutionStatus status = StageKt.failureStatus((StageExecution)stageExecution, (ExecutionStatus)executionStatus);
                                                Queue queue = this.this$0.this$0.this$0.getQueue();
                                                TaskLevel taskLevel = this.this$0.this$0.$message;
                                                ExecutionStatus executionStatus3 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus3, (String)"result.status");
                                                queue.push((Message)new CompleteTask(taskLevel, status, executionStatus3));
                                                RunTaskHandler.access$trackResult(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, thisInvocationStartTimeMs, this.this$0.$taskModel, status);
                                                break;
                                            }
                                            case 8: {
                                                RunTaskHandler.access$processTaskOutput(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, (TaskResult)result);
                                                StageExecution stageExecution = (StageExecution)this.this$0.$stage.element;
                                                ExecutionStatus executionStatus = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"result.status");
                                                ExecutionStatus status = StageKt.failureStatus((StageExecution)stageExecution, (ExecutionStatus)executionStatus);
                                                Queue queue = this.this$0.this$0.this$0.getQueue();
                                                TaskLevel taskLevel = this.this$0.this$0.$message;
                                                ExecutionStatus executionStatus4 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus4, (String)"result.status");
                                                queue.push((Message)new CompleteTask(taskLevel, status, executionStatus4));
                                                RunTaskHandler.access$trackResult(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, thisInvocationStartTimeMs, this.this$0.$taskModel, status);
                                                break;
                                            }
                                            default: {
                                                RunTaskHandler.access$processTaskOutput(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, (TaskResult)result);
                                                String status = "Unhandled task status " + result.getStatus();
                                                boolean bl4 = false;
                                                throw (Throwable)new NotImplementedError("An operation is not implemented: " + status);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        ExceptionHandler.Response exceptionDetails;
                                        taskException = e;
                                        ExceptionHandler.Response response = exceptionDetails = this.this$0.this$0.this$0.shouldRetry(RunTaskHandler.access$getExceptionHandlers$p(this.this$0.this$0.this$0), e, this.this$0.$taskModel.getName());
                                        if (response != null) {
                                            if (response.getShouldRetry()) {
                                                this.this$0.this$0.this$0.getLog().warn("Error running " + this.this$0.this$0.$message.getTaskType().getSimpleName() + " for " + this.this$0.this$0.$message.getExecutionType() + '[' + this.this$0.this$0.$message.getExecutionId() + ']');
                                                this.this$0.this$0.this$0.getQueue().push((Message)this.this$0.this$0.$message, RunTaskHandler.access$backoffPeriod(this.this$0.this$0.this$0, this.this$0.$task, this.this$0.$taskModel, (StageExecution)this.this$0.$stage.element));
                                                RunTaskHandler.access$trackResult(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, thisInvocationStartTimeMs, this.this$0.$taskModel, ExecutionStatus.RUNNING);
                                            }
                                        }
                                        if (e instanceof TimeoutException && Intrinsics.areEqual(((StageExecution)this.this$0.$stage.element).getContext().get("markSuccessfulOnTimeout"), (Object)true)) {
                                            RunTaskHandler.access$trackResult(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, thisInvocationStartTimeMs, this.this$0.$taskModel, ExecutionStatus.SUCCEEDED);
                                            this.this$0.this$0.this$0.getQueue().push((Message)new CompleteTask(this.this$0.this$0.$message, ExecutionStatus.SUCCEEDED));
                                        }
                                        if (!(e instanceof TimeoutException)) {
                                            if (e instanceof UserException) {
                                                this.this$0.this$0.this$0.getLog().warn(this.this$0.this$0.$message.getTaskType().getSimpleName() + " for " + this.this$0.this$0.$message.getExecutionType() + '[' + this.this$0.this$0.$message.getExecutionId() + "] failed, likely due to user error", (Throwable)e);
                                            } else {
                                                this.this$0.this$0.this$0.getLog().error("Error running " + this.this$0.this$0.$message.getTaskType().getSimpleName() + " for " + this.this$0.this$0.$message.getExecutionType() + '[' + this.this$0.this$0.$message.getExecutionId() + ']', (Throwable)e);
                                            }
                                        }
                                        ExecutionStatus status = StageKt.failureStatus((StageExecution)((StageExecution)this.this$0.$stage.element), (ExecutionStatus)ExecutionStatus.TERMINAL);
                                        Map map = ((StageExecution)this.this$0.$stage.element).getContext();
                                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"stage.context");
                                        map.put("exception", exceptionDetails);
                                        this.this$0.this$0.this$0.getRepository().storeStage((StageExecution)this.this$0.$stage.element);
                                        this.this$0.this$0.this$0.getQueue().push((Message)new CompleteTask(this.this$0.this$0.$message, status, ExecutionStatus.TERMINAL));
                                        RunTaskHandler.access$trackResult(this.this$0.this$0.this$0, (StageExecution)this.this$0.$stage.element, thisInvocationStartTimeMs, this.this$0.$taskModel, status);
                                    }
                                    finally {
                                        Iterable $this$forEach$iv = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0.this$0.this$0);
                                        boolean $i$f$forEach = false;
                                        for (E element$iv : $this$forEach$iv) {
                                            TaskExecutionInterceptor t = (TaskExecutionInterceptor)element$iv;
                                            boolean bl = false;
                                            t.finallyAfterTaskExecution(this.this$0.$task, (StageExecution)this.this$0.$stage.element, taskResult, taskException);
                                        }
                                    }
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$stage = objectRef;
                        this.$taskModel = taskExecution;
                        this.$task = task;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = runTaskHandler;
                this.$message = runTask;
                super(3);
            }
        }));
    }

    private void trackResult(StageExecution stage, long thisInvocationStartTimeMs, TaskExecution taskModel, ExecutionStatus status) {
        try {
            Iterable<BasicTag> commonTags = MetricsTagHelper.Companion.commonTags(stage, taskModel, status);
            Iterable<BasicTag> detailedTags = MetricsTagHelper.Companion.detailedTaskTags(stage, taskModel, status);
            long elapsedMillis = this.clock.millis() - thisInvocationStartTimeMs;
            Pair[] pairArray = new Pair[2];
            PipelineExecution pipelineExecution = stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
            pairArray[0] = TuplesKt.to((Object)"task.invocations.duration", (Object)CollectionsKt.plus(commonTags, (Object)new BasicTag("application", pipelineExecution.getApplication())));
            pairArray[1] = TuplesKt.to((Object)"task.invocations.duration.withType", (Object)CollectionsKt.plus(commonTags, detailedTags));
            MapsKt.hashMapOf((Pair[])pairArray).forEach((BiConsumer)new BiConsumer<String, List<? extends BasicTag>>(this, elapsedMillis){
                final /* synthetic */ RunTaskHandler this$0;
                final /* synthetic */ long $elapsedMillis;

                public final void accept(@NotNull String name, @NotNull List<BasicTag> tags) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter(tags, (String)"tags");
                    RunTaskHandler.access$getRegistry$p(this.this$0).timer(name, (Iterable)tags).record(this.$elapsedMillis, TimeUnit.MILLISECONDS);
                }
                {
                    this.this$0 = runTaskHandler;
                    this.$elapsedMillis = l;
                }
            });
            if (elapsedMillis >= (long)this.warningInvocationTimeMs) {
                this.getLog().info("Task invocation took over " + this.warningInvocationTimeMs + "ms " + "(taskType: " + taskModel.getImplementingClass() + ", stageType: " + stage.getType() + ", stageId: " + stage.getId() + ')');
            }
        }
        catch (Exception e) {
            this.getLog().warn("Failed to track result for stage: " + stage.getId() + ", task: " + taskModel.getId(), (Throwable)e);
        }
    }

    @NotNull
    public Class<RunTask> getMessageType() {
        return this.messageType;
    }

    private void withTask(RunTask $this$withTask, Function3<? super StageExecution, ? super TaskExecution, ? super Task, Unit> block) {
        this.withTask((TaskLevel)$this$withTask, (Function2<? super StageExecution, ? super TaskExecution, Unit>)((Function2)new Function2<StageExecution, TaskExecution, Unit>(this, $this$withTask, block){
            final /* synthetic */ RunTaskHandler this$0;
            final /* synthetic */ RunTask $this_withTask;
            final /* synthetic */ Function3 $block;

            public final void invoke(@NotNull StageExecution stage, @NotNull TaskExecution taskModel) {
                block4: {
                    Task task;
                    Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                    Intrinsics.checkNotNullParameter((Object)taskModel, (String)"taskModel");
                    try {
                        task = RunTaskHandler.access$getTaskResolver$p(this.this$0).getTask(taskModel.getImplementingClass());
                    }
                    catch (TaskResolver.NoSuchTaskException e) {
                        Task task2;
                        try {
                            task2 = RunTaskHandler.access$getTaskResolver$p(this.this$0).getTask(this.$this_withTask.getTaskType());
                        }
                        catch (TaskResolver.NoSuchTaskException e2) {
                            Queue queue = this.this$0.getQueue();
                            StageLevel stageLevel = this.$this_withTask;
                            String string = this.$this_withTask.getTaskType().getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskType.name");
                            queue.push((Message)new InvalidTaskType(stageLevel, string));
                            task2 = null;
                        }
                        task = task2;
                    }
                    Task task3 = task;
                    if (task3 == null) break block4;
                    task = task3;
                    boolean bl = false;
                    boolean bl2 = false;
                    Task it = task;
                    boolean bl3 = false;
                    Task task4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)task4, (String)"it");
                    this.$block.invoke((Object)stage, (Object)taskModel, (Object)task4);
                }
            }
            {
                this.this$0 = runTaskHandler;
                this.$this_withTask = runTask;
                this.$block = function3;
                super(2);
            }
        }));
    }

    private TemporalAmount backoffPeriod(Task $this$backoffPeriod, TaskExecution taskModel, StageExecution stage) {
        TemporalAmount temporalAmount;
        Task task = $this$backoffPeriod;
        if (task instanceof RetryableTask) {
            Duration duration = Duration.ofMillis(RangesKt.coerceAtMost((long)this.retryableBackOffPeriod((RetryableTask)$this$backoffPeriod, taskModel, stage), (long)this.maxBackoff(this.taskExecutionInterceptors)));
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(\n     \u2026ors.maxBackoff())\n      )");
            temporalAmount = duration;
        } else {
            Duration duration = Duration.ofMillis(1000L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ofMillis(1000)");
            temporalAmount = duration;
        }
        return temporalAmount;
    }

    private long retryableBackOffPeriod(RetryableTask $this$retryableBackOffPeriod, TaskExecution taskModel, StageExecution stage) {
        long l = System.currentTimeMillis();
        Long l2 = taskModel.getStartTime();
        if (l2 == null) {
            l2 = 0L;
        }
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"taskModel.startTime ?: 0");
        long dynamicBackOffPeriod = $this$retryableBackOffPeriod.getDynamicBackoffPeriod(stage, Duration.ofMillis(l - l2));
        Object[] objectArray = new Long[2];
        objectArray[0] = dynamicBackOffPeriod;
        Object object = this.dynamicConfigService.getConfig(Long.TYPE, "tasks.global.backOffPeriod", (Object)dynamicBackOffPeriod);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dynamicConfigService.get\u2026amicBackOffPeriod\n      )");
        objectArray[1] = (Long)object;
        List backOffs = CollectionsKt.mutableListOf((Object[])objectArray);
        if ($this$retryableBackOffPeriod instanceof CloudProviderAware && ((CloudProviderAware)$this$retryableBackOffPeriod).hasCloudProvider(stage)) {
            Object object2 = this.dynamicConfigService.getConfig(Long.TYPE, "tasks." + ((CloudProviderAware)$this$retryableBackOffPeriod).getCloudProvider(stage) + ".backOffPeriod", (Object)dynamicBackOffPeriod);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"dynamicConfigService.get\u2026icBackOffPeriod\n        )");
            backOffs.add(object2);
            if (((CloudProviderAware)$this$retryableBackOffPeriod).hasCredentials(stage)) {
                Object object3 = this.dynamicConfigService.getConfig(Long.TYPE, "tasks." + ((CloudProviderAware)$this$retryableBackOffPeriod).getCloudProvider(stage) + '.' + ((CloudProviderAware)$this$retryableBackOffPeriod).getCredentials(stage) + ".backOffPeriod", (Object)dynamicBackOffPeriod);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"dynamicConfigService.get\u2026BackOffPeriod\n          )");
                backOffs.add(object3);
            }
        }
        Long l3 = (Long)CollectionsKt.max((Iterable)backOffs);
        return l3 != null ? l3 : dynamicBackOffPeriod;
    }

    /*
     * WARNING - void declaration
     */
    private long maxBackoff(List<? extends TaskExecutionInterceptor> $this$maxBackoff) {
        void $this$fold$iv;
        Iterable iterable = $this$maxBackoff;
        long initial$iv = Long.MAX_VALUE;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void interceptor;
            TaskExecutionInterceptor taskExecutionInterceptor = (TaskExecutionInterceptor)element$iv;
            long backoff = accumulator$iv;
            boolean bl = false;
            accumulator$iv = RangesKt.coerceAtMost((long)backoff, (long)interceptor.maxTaskBackoff());
        }
        return accumulator$iv;
    }

    private String formatTimeout(long timeout) {
        String string = DurationFormatUtils.formatDurationWords((long)timeout, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DurationFormatUtils.form\u2026ords(timeout, true, true)");
        return string;
    }

    private void checkForTimeout(Task $this$checkForTimeout, StageExecution stage, TaskExecution taskModel, Message message) {
        if (Intrinsics.areEqual((Object)stage.getType(), (Object)"restrictExecutionDuringTimeWindow")) {
            return;
        }
        this.checkForStageTimeout(stage);
        this.checkForTaskTimeout($this$checkForTimeout, taskModel, stage, message);
    }

    /*
     * Unable to fully structure code
     */
    private void checkForTaskTimeout(Task $this$checkForTaskTimeout, TaskExecution taskModel, StageExecution stage, Message message) {
        block3: {
            if (!($this$checkForTaskTimeout instanceof RetryableTask) || (startTime = TimeKt.toInstant(taskModel.getStartTime())) == null) break block3;
            v0 = stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"stage.execution");
            pausedDuration = this.pausedDurationRelativeTo(v0, startTime);
            elapsedTime = Duration.between(startTime, this.clock.instant());
            if (!($this$checkForTaskTimeout instanceof OverridableTimeoutRetryableTask)) ** GOTO lbl-1000
            v1 = stage.getParentWithTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"stage.parentWithTimeout");
            if (v1.isPresent()) {
                v2 = stage.getParentWithTimeout().get();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"stage.parentWithTimeout.get()");
                v3 = ((StageExecution)v2).getTimeout().get();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"stage.parentWithTimeout.get().timeout.get()");
                v4 = TimeKt.toDuration(((Number)v3).longValue());
            } else lbl-1000:
            // 2 sources

            {
                v4 = actualTimeout = TimeKt.toDuration(((RetryableTask)$this$checkForTaskTimeout).getDynamicTimeout(stage));
            }
            if (elapsedTime.minus(pausedDuration).compareTo(actualTimeout) > 0) {
                durationString = this.formatTimeout(elapsedTime.toMillis());
                msg = new StringBuilder(((RetryableTask)$this$checkForTaskTimeout).getClass().getSimpleName() + " of stage " + stage.getName() + " timed out after " + durationString + ". ");
                msg.append("pausedDuration: " + this.formatTimeout(pausedDuration.toMillis()) + ", ");
                msg.append("elapsedTime: " + this.formatTimeout(elapsedTime.toMillis()) + ", ");
                msg.append("timeoutValue: " + this.formatTimeout(actualTimeout.toMillis()));
                this.getLog().info(msg.toString());
                throw (Throwable)new TimeoutException(msg.toString());
            }
        }
    }

    private void checkForStageTimeout(StageExecution stage) {
        stage.getParentWithTimeout().ifPresent((Consumer)new Consumer<StageExecution>(this, stage){
            final /* synthetic */ RunTaskHandler this$0;
            final /* synthetic */ StageExecution $stage;

            public final void accept(@NotNull StageExecution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Instant startTime = TimeKt.toInstant(it.getStartTime());
                if (startTime != null) {
                    Duration elapsedTime = Duration.between(startTime, RunTaskHandler.access$getClock$p(this.this$0).instant());
                    PipelineExecution pipelineExecution = this.$stage.getExecution();
                    Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                    Duration pausedDuration = RunTaskHandler.access$pausedDurationRelativeTo(this.this$0, pipelineExecution, startTime);
                    Object object = RunTaskHandler.access$getExecutionWindow$p(this.this$0, this.$stage);
                    if (object == null || (object = RunTaskHandler.access$getDuration$p(this.this$0, object)) == null) {
                        object = Duration.ZERO;
                    }
                    Object executionWindowDuration = object;
                    T t = it.getTimeout().get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"it.timeout.get()");
                    Duration timeout = Duration.ofMillis(((Number)t).longValue());
                    if (elapsedTime.minus(pausedDuration).minus((Duration)executionWindowDuration).compareTo(timeout) > 0) {
                        throw (Throwable)new TimeoutException("Stage " + this.$stage.getName() + " timed out after " + RunTaskHandler.access$formatTimeout(this.this$0, elapsedTime.toMillis()));
                    }
                }
            }
            {
                this.this$0 = runTaskHandler;
                this.$stage = stageExecution;
            }
        });
    }

    private StageExecution getExecutionWindow(StageExecution $this$executionWindow) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = StageKt.beforeStages((StageExecution)$this$executionWindow);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StageExecution it = (StageExecution)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"restrictExecutionDuringTimeWindow")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private Duration getDuration(StageExecution $this$duration) {
        StageExecution stageExecution = $this$duration;
        boolean bl = false;
        boolean bl2 = false;
        StageExecution $this$run = stageExecution;
        boolean bl3 = false;
        if ($this$run.getStartTime() == null || $this$run.getEndTime() == null) {
            throw (Throwable)new IllegalStateException("Only valid on completed stages");
        }
        Duration duration = Duration.between(TimeKt.toInstant($this$run.getStartTime()), TimeKt.toInstant($this$run.getEndTime()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"run {\n      if (startTim\u2026ndTime.toInstant())\n    }");
        return duration;
    }

    private Counter timeoutCounter(Registry $this$timeoutCounter, ExecutionType executionType, String application, String stageType, String taskType) {
        return $this$timeoutCounter.counter($this$timeoutCounter.createId("queue.task.timeouts").withTags(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"executionType", (Object)executionType.toString()), TuplesKt.to((Object)"application", (Object)application), TuplesKt.to((Object)"stageType", (Object)stageType), TuplesKt.to((Object)"taskType", (Object)taskType)})));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Duration pausedDurationRelativeTo(PipelineExecution $this$pausedDurationRelativeTo, Instant instant) {
        Duration duration;
        PipelineExecution.PausedDetails pausedDetails = $this$pausedDurationRelativeTo.getPaused();
        if (pausedDetails == null) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            return duration;
        }
        Instant instant2 = TimeKt.toInstant(pausedDetails.getPauseTime());
        Duration duration3 = instant2 != null && instant2.isAfter(instant) ? Duration.ofMillis(pausedDetails.getPausedMs()) : Duration.ZERO;
        duration = duration3;
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"if (pausedDetails.pauseT\u2026usedMs)\n      } else ZERO");
        return duration;
    }

    private void processTaskOutput(StageExecution $this$processTaskOutput, TaskResult result) {
        block4: {
            Map filteredOutputs;
            block3: {
                Map map = result.getOutputs();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"result.outputs");
                Map $this$filterKeys$iv = map;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                Map map2 = $this$filterKeys$iv;
                boolean bl = false;
                for (Map.Entry entry$iv : map2.entrySet()) {
                    String it = (String)entry$iv.getKey();
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)"stageTimeoutMs") ^ true)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                filteredOutputs = result$iv;
                Map map3 = result.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"result.context");
                Map map4 = map3;
                boolean bl3 = false;
                if (!map4.isEmpty()) break block3;
                map4 = filteredOutputs;
                bl3 = false;
                if (!(!map4.isEmpty())) break block4;
            }
            Map map = $this$processTaskOutput.getContext();
            Map map5 = result.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)map5, (String)"result.context");
            map.putAll(map5);
            $this$processTaskOutput.getOutputs().putAll(filteredOutputs);
            this.getRepository().storeStage($this$processTaskOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withLoggingContext(StageExecution $this$withLoggingContext, TaskExecution taskModel, Function0<Unit> block) {
        try {
            MDC.put((String)"stageType", (String)$this$withLoggingContext.getType());
            MDC.put((String)"taskType", (String)taskModel.getImplementingClass());
            if (taskModel.getStartTime() != null) {
                MDC.put((String)"taskStartTime", (String)String.valueOf(taskModel.getStartTime()));
            }
            block.invoke();
        }
        finally {
            MDC.remove((String)"stageType");
            MDC.remove((String)"taskType");
            MDC.remove((String)"taskStartTime");
        }
    }

    private TaskResult mergeOutputs(TaskResult $this$mergeOutputs, TaskResult taskResult) {
        Map it;
        if (taskResult == null) {
            return $this$mergeOutputs;
        }
        TaskResult.TaskResultBuilder taskResultBuilder = TaskResult.builder((ExecutionStatus)$this$mergeOutputs.getStatus());
        Map map = $this$mergeOutputs.getOutputs();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.outputs");
        Map map2 = MapsKt.toMutableMap((Map)map);
        boolean bl = false;
        boolean bl2 = false;
        Map map3 = map2;
        TaskResult.TaskResultBuilder taskResultBuilder2 = taskResultBuilder;
        boolean bl3 = false;
        Map map4 = taskResult.getOutputs();
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"taskResult.outputs");
        it.putAll(map4);
        Unit unit = Unit.INSTANCE;
        TaskResult.TaskResultBuilder taskResultBuilder3 = taskResultBuilder2.outputs(map2);
        Map map5 = $this$mergeOutputs.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map5, (String)"this.context");
        map2 = MapsKt.toMutableMap((Map)map5);
        bl = false;
        bl2 = false;
        it = map2;
        taskResultBuilder2 = taskResultBuilder3;
        boolean bl4 = false;
        Map map6 = taskResult.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map6, (String)"taskResult.context");
        it.putAll(map6);
        unit = Unit.INSTANCE;
        TaskResult taskResult2 = taskResultBuilder2.context(map2).build();
        Intrinsics.checkNotNullExpressionValue((Object)taskResult2, (String)"TaskResult.builder(this.\u2026 }\n      )\n      .build()");
        return taskResult2;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    public RunTaskHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageNavigator stageNavigator, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull ContextParameterProcessor contextParameterProcessor, @NotNull TaskResolver taskResolver, @NotNull Clock clock, @NotNull List<? extends ExceptionHandler> exceptionHandlers, @NotNull List<? extends TaskExecutionInterceptor> taskExecutionInterceptors, @NotNull Registry registry, @NotNull DynamicConfigService dynamicConfigService) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter(taskExecutionInterceptors, (String)"taskExecutionInterceptors");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        this.queue = queue;
        this.repository = repository;
        this.stageNavigator = stageNavigator;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.contextParameterProcessor = contextParameterProcessor;
        this.taskResolver = taskResolver;
        this.clock = clock;
        this.exceptionHandlers = exceptionHandlers;
        this.taskExecutionInterceptors = taskExecutionInterceptors;
        this.registry = registry;
        this.dynamicConfigService = dynamicConfigService;
        Object object = this.dynamicConfigService.getConfig(Integer.TYPE, "tasks.warningInvocationTimeMs", (Object)30000);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dynamicConfigService.get\u2026ionTimeMs\",\n    30000\n  )");
        this.warningInvocationTimeMs = ((Number)object).intValue();
        this.messageType = RunTask.class;
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMergedContext, (String)"$this$withMergedContext");
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        Intrinsics.checkNotNullParameter((Object)$this$includeExpressionEvaluationSummary, (String)"$this$includeExpressionEvaluationSummary");
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFailedExpressions, (String)"$this$hasFailedExpressions");
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldFailOnFailedExpressionEvaluation, (String)"$this$shouldFailOnFailedExpressionEvaluation");
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withAuth, (String)"$this$withAuth");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    public static final /* synthetic */ void access$withLoggingContext(RunTaskHandler $this, StageExecution $this$access_u24withLoggingContext, TaskExecution taskModel, Function0 block) {
        $this.withLoggingContext($this$access_u24withLoggingContext, taskModel, (Function0<Unit>)block);
    }

    public static final /* synthetic */ Clock access$getClock$p(RunTaskHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ List access$getTaskExecutionInterceptors$p(RunTaskHandler $this) {
        return $this.taskExecutionInterceptors;
    }

    public static final /* synthetic */ void access$processTaskOutput(RunTaskHandler $this, StageExecution $this$access_u24processTaskOutput, TaskResult result) {
        $this.processTaskOutput($this$access_u24processTaskOutput, result);
    }

    public static final /* synthetic */ void access$checkForTimeout(RunTaskHandler $this, Task $this$access_u24checkForTimeout, StageExecution stage, TaskExecution taskModel, Message message) {
        $this.checkForTimeout($this$access_u24checkForTimeout, stage, taskModel, message);
    }

    public static final /* synthetic */ Counter access$timeoutCounter(RunTaskHandler $this, Registry $this$access_u24timeoutCounter, ExecutionType executionType, String application, String stageType, String taskType) {
        return $this.timeoutCounter($this$access_u24timeoutCounter, executionType, application, stageType, taskType);
    }

    public static final /* synthetic */ Registry access$getRegistry$p(RunTaskHandler $this) {
        return $this.registry;
    }

    public static final /* synthetic */ TemporalAmount access$backoffPeriod(RunTaskHandler $this, Task $this$access_u24backoffPeriod, TaskExecution taskModel, StageExecution stage) {
        return $this.backoffPeriod($this$access_u24backoffPeriod, taskModel, stage);
    }

    public static final /* synthetic */ void access$trackResult(RunTaskHandler $this, StageExecution stage, long thisInvocationStartTimeMs, TaskExecution taskModel, ExecutionStatus status) {
        $this.trackResult(stage, thisInvocationStartTimeMs, taskModel, status);
    }

    public static final /* synthetic */ TaskResult access$mergeOutputs(RunTaskHandler $this, TaskResult $this$access_u24mergeOutputs, TaskResult taskResult) {
        return $this.mergeOutputs($this$access_u24mergeOutputs, taskResult);
    }

    public static final /* synthetic */ List access$getExceptionHandlers$p(RunTaskHandler $this) {
        return $this.exceptionHandlers;
    }

    public static final /* synthetic */ TaskResolver access$getTaskResolver$p(RunTaskHandler $this) {
        return $this.taskResolver;
    }

    public static final /* synthetic */ Duration access$pausedDurationRelativeTo(RunTaskHandler $this, PipelineExecution $this$access_u24pausedDurationRelativeTo, Instant instant) {
        return $this.pausedDurationRelativeTo($this$access_u24pausedDurationRelativeTo, instant);
    }

    public static final /* synthetic */ StageExecution access$getExecutionWindow$p(RunTaskHandler $this, StageExecution $this$access_u24executionWindow_u24p) {
        return $this.getExecutionWindow($this$access_u24executionWindow_u24p);
    }

    public static final /* synthetic */ Duration access$getDuration$p(RunTaskHandler $this, StageExecution $this$access_u24duration_u24p) {
        return $this.getDuration($this$access_u24duration_u24p);
    }

    public static final /* synthetic */ String access$formatTimeout(RunTaskHandler $this, long timeout) {
        return $this.formatTimeout(timeout);
    }
}

