/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.ExecutionComplete;
import com.netflix.spinnaker.orca.events.ExecutionStarted;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.ExecutionKt;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CancelExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartExecution;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J\f\u0010!\u001a\u00020\"*\u00020\u001fH\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/StartExecutionHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/StartExecution;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "handle", "", "message", "start", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "terminate", "isAfterStartTimeExpiry", "", "orca-queue"})
public class StartExecutionHandler
implements OrcaMessageHandler<StartExecution> {
    @NotNull
    private final Class<StartExecution> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    private final PendingExecutionService pendingExecutionService;
    private final ApplicationEventPublisher publisher;
    private final Clock clock;

    @NotNull
    public Class<StartExecution> getMessageType() {
        return this.messageType;
    }

    private Logger getLog() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
        return logger;
    }

    public void handle(@NotNull StartExecution message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withExecution(message, (Function1<? super PipelineExecution, Unit>)((Function1)new Function1<PipelineExecution, Unit>(this, message){
            final /* synthetic */ StartExecutionHandler this$0;
            final /* synthetic */ StartExecution $message;

            public final void invoke(@NotNull PipelineExecution execution) {
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                if (execution.getStatus() == ExecutionStatus.NOT_STARTED && !execution.isCanceled()) {
                    if (this.this$0.shouldQueue(execution)) {
                        String string = execution.getPipelineConfigId();
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            StartExecutionHandler.access$getLog$p(this.this$0).info("Queueing {} {} {}", new Object[]{execution.getApplication(), execution.getName(), execution.getId()});
                            StartExecutionHandler.access$getPendingExecutionService$p(this.this$0).enqueue(it, this.$message);
                        }
                    } else {
                        StartExecutionHandler.access$start(this.this$0, execution);
                    }
                } else {
                    StartExecutionHandler.access$terminate(this.this$0, execution);
                }
            }
            {
                this.this$0 = startExecutionHandler;
                this.$message = startExecution;
                super(1);
            }
        }));
    }

    private void start(PipelineExecution execution) {
        if (this.isAfterStartTimeExpiry(execution)) {
            this.getLog().warn("Execution (type " + execution.getType() + ", id {}, application: {}) start was canceled because" + "start time would be after defined start time expiry (now: " + this.clock.millis() + ", expiry: " + execution.getStartTimeExpiry() + ')', (Object)StructuredArguments.value((String)"executionId", (Object)execution.getId()), (Object)StructuredArguments.value((String)"application", (Object)execution.getApplication()));
            Queue queue = this.getQueue();
            ExecutionType executionType = execution.getType();
            Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"execution.type");
            String string = execution.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execution.id");
            String string2 = execution.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"execution.application");
            queue.push((Message)new CancelExecution(executionType, string, string2, "spinnaker", "Could not begin execution before start time expiry"));
        } else {
            List initialStages = ExecutionKt.initialStages((PipelineExecution)execution);
            if (initialStages.isEmpty()) {
                this.getLog().warn("No initial stages found (executionId: " + execution.getId() + ')');
                execution.updateStatus(ExecutionStatus.TERMINAL);
                this.getRepository().updateStatus(execution);
                this.publisher.publishEvent((ApplicationEvent)new ExecutionComplete((Object)this, execution));
            } else {
                execution.updateStatus(ExecutionStatus.RUNNING);
                this.getRepository().updateStatus(execution);
                Iterable $this$forEach$iv = initialStages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl = false;
                    Queue queue = this.getQueue();
                    StageExecution stageExecution = it;
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                    queue.push((Message)new StartStage(stageExecution));
                }
                this.publisher.publishEvent((ApplicationEvent)new ExecutionStarted((Object)this, execution));
            }
        }
    }

    private void terminate(PipelineExecution execution) {
        if (execution.getStatus() == ExecutionStatus.CANCELED || execution.isCanceled()) {
            this.publisher.publishEvent((ApplicationEvent)new ExecutionComplete((Object)this, execution));
            String string = execution.getPipelineConfigId();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.getQueue().push((Message)new StartWaitingExecutions(it, !execution.isKeepWaitingPipelines()));
            }
        } else {
            this.getLog().warn("Execution (type: " + execution.getType() + ", id: {}, status: " + execution.getStatus() + ", application: {})" + " cannot be started unless state is NOT_STARTED. Ignoring StartExecution message.", (Object)StructuredArguments.value((String)"executionId", (Object)execution.getId()), (Object)StructuredArguments.value((String)"application", (Object)execution.getApplication()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAfterStartTimeExpiry(PipelineExecution $this$isAfterStartTimeExpiry) {
        Long l = $this$isAfterStartTimeExpiry.getStartTimeExpiry();
        Comparable<Long> comparable = l;
        if (l == null) return false;
        Long l2 = comparable;
        boolean bl = false;
        boolean bl2 = false;
        long it = ((Number)l2).longValue();
        boolean bl3 = false;
        Instant instant = Instant.ofEpochMilli(it);
        comparable = instant;
        if (instant == null) return false;
        boolean bl4 = ((Instant)comparable).isBefore(this.clock.instant());
        return bl4;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    public StartExecutionHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull PendingExecutionService pendingExecutionService, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"pendingExecutionService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.queue = queue;
        this.repository = repository;
        this.pendingExecutionService = pendingExecutionService;
        this.publisher = publisher;
        this.clock = clock;
        this.messageType = StartExecution.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    public static final /* synthetic */ Logger access$getLog$p(StartExecutionHandler $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ PendingExecutionService access$getPendingExecutionService$p(StartExecutionHandler $this) {
        return $this.pendingExecutionService;
    }

    public static final /* synthetic */ void access$start(StartExecutionHandler $this, PipelineExecution execution) {
        $this.start(execution);
    }

    public static final /* synthetic */ void access$terminate(StartExecutionHandler $this, PipelineExecution execution) {
        $this.terminate(execution);
    }
}

