/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.pending;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.notifications.AbstractPollingNotificationAgent;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${pollers.pending-execution-service-agent.enabled:false}")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\rH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionAgent;", "Lcom/netflix/spinnaker/orca/notifications/AbstractPollingNotificationAgent;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "registry", "Lcom/netflix/spectator/api/Registry;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "pollingIntervalMs", "", "(Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;J)V", "kickCounter", "Lcom/netflix/spectator/api/Counter;", "lastCompletedCriteria", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository$ExecutionCriteria;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "singleRunningCriteria", "getNotificationType", "", "getPollingInterval", "tick", "", "orca-queue"})
public class PendingExecutionAgent
extends AbstractPollingNotificationAgent {
    private final Logger log;
    private final ExecutionRepository.ExecutionCriteria lastCompletedCriteria;
    private final ExecutionRepository.ExecutionCriteria singleRunningCriteria;
    private final Counter kickCounter;
    private final Queue queue;
    private final PendingExecutionService pendingExecutionService;
    private final ExecutionRepository executionRepository;
    private final long pollingIntervalMs;

    protected long getPollingInterval() {
        return this.pollingIntervalMs;
    }

    @NotNull
    protected String getNotificationType() {
        String string = PendingExecutionAgent.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PendingExecutionAgent::class.java.simpleName");
        return string;
    }

    protected void tick() {
        try {
            List<String> pendingConfigIds = this.pendingExecutionService.pendingIds();
            for (String configId : pendingConfigIds) {
                boolean bl;
                List lastCompletedPipeline;
                List runningPipelines = (List)this.executionRepository.retrievePipelinesForPipelineConfigId(configId, this.singleRunningCriteria).toList().toBlocking().single();
                if (!runningPipelines.isEmpty()) continue;
                List list = lastCompletedPipeline = (List)this.executionRepository.retrievePipelinesForPipelineConfigId(configId, this.lastCompletedCriteria).toList().toBlocking().single();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lastCompletedPipeline");
                if (CollectionsKt.any((Iterable)list)) {
                    Object object = CollectionsKt.first((List)lastCompletedPipeline);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lastCompletedPipeline.first()");
                    bl = !((PipelineExecution)object).isKeepWaitingPipelines();
                } else {
                    bl = false;
                }
                boolean purgeQueue = bl;
                this.queue.push((Message)new StartWaitingExecutions(configId, purgeQueue));
                this.log.info("Found pending execution(s) for pipeline {} with no running pipelines, kick-starting it with purge = {}", (Object)configId, (Object)purgeQueue);
                this.kickCounter.increment();
            }
        }
        catch (Exception e) {
            this.log.error("Agent {} failed to kick-start pending executions", ((Object)((Object)this)).getClass(), (Object)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PendingExecutionAgent(@NotNull NotificationClusterLock clusterLock, @NotNull Registry registry, @NotNull Queue queue, @NotNull PendingExecutionService pendingExecutionService, @NotNull ExecutionRepository executionRepository, @Value(value="${pollers.pending-execution-service-agent.interval-ms:15000}") long pollingIntervalMs) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"pendingExecutionService");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        super(clusterLock);
        this.queue = queue;
        this.pendingExecutionService = pendingExecutionService;
        this.executionRepository = executionRepository;
        this.pollingIntervalMs = pollingIntervalMs;
        this.log = LoggerFactory.getLogger(PendingExecutionAgent.class);
        ExecutionRepository.ExecutionCriteria executionCriteria = new ExecutionRepository.ExecutionCriteria().setPageSize(1);
        Collection collection2 = ExecutionStatus.COMPLETED;
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ExecutionStatus.COMPLETED");
        Iterable iterable = collection2;
        ExecutionRepository.ExecutionCriteria executionCriteria2 = executionCriteria;
        PendingExecutionAgent pendingExecutionAgent = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExecutionStatus executionStatus = (ExecutionStatus)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ExecutionRepository.ExecutionCriteria executionCriteria3 = executionCriteria2.setStatuses((Collection)collection);
        Intrinsics.checkNotNullExpressionValue((Object)executionCriteria3, (String)"ExecutionRepository.Exec\u2026ED.map { it.toString() })");
        pendingExecutionAgent.lastCompletedCriteria = executionCriteria3;
        ExecutionRepository.ExecutionCriteria executionCriteria4 = new ExecutionRepository.ExecutionCriteria().setPageSize(1).setStatuses(new ExecutionStatus[]{ExecutionStatus.RUNNING});
        Intrinsics.checkNotNullExpressionValue((Object)executionCriteria4, (String)"ExecutionRepository.Exec\u2026(ExecutionStatus.RUNNING)");
        this.singleRunningCriteria = executionCriteria4;
        Counter counter = registry.counter("pollers.pendingExecutionAgent.kickedExecutions");
        Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"registry.counter(\"poller\u2026nAgent.kickedExecutions\")");
        this.kickCounter = counter;
    }
}

