/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="startExecution")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/orca/q/StartExecution;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "source", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class StartExecution
extends Message
implements ExecutionLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    public StartExecution(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
    }

    public StartExecution(@NotNull PipelineExecution source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ExecutionType executionType = source.getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"source.type");
        String string = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.id");
        String string2 = source.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"source.application");
        this(executionType, string, string2);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final StartExecution copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new StartExecution(executionType, executionId, application);
    }

    public static /* synthetic */ StartExecution copy$default(StartExecution startExecution, ExecutionType executionType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = startExecution.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = startExecution.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = startExecution.getApplication();
        }
        return startExecution.copy(executionType, string, string2);
    }

    @NotNull
    public String toString() {
        return "StartExecution(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ")";
    }

    public int hashCode() {
        ExecutionType executionType = this.getExecutionType();
        String string = this.getExecutionId();
        String string2 = this.getApplication();
        return ((executionType != null ? executionType.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof StartExecution)) break block3;
                StartExecution startExecution = (StartExecution)object;
                if (!Intrinsics.areEqual((Object)this.getExecutionType(), (Object)startExecution.getExecutionType()) || !Intrinsics.areEqual((Object)this.getExecutionId(), (Object)startExecution.getExecutionId()) || !Intrinsics.areEqual((Object)this.getApplication(), (Object)startExecution.getApplication())) break block3;
            }
            return true;
        }
        return false;
    }
}

