/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ConfigurationError;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.InvalidExecutionId;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/ConfigurationErrorHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/ConfigurationError;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "handle", "", "message", "orca-queue"})
public class ConfigurationErrorHandler
implements OrcaMessageHandler<ConfigurationError> {
    @NotNull
    private final Class<ConfigurationError> messageType;
    private final Logger log;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;

    @NotNull
    public Class<ConfigurationError> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull ConfigurationError message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ConfigurationError configurationError = message;
        if (configurationError instanceof InvalidExecutionId) {
            this.log.error("No such " + message.getExecutionType() + ' ' + message.getExecutionId() + " for " + message.getApplication());
        } else {
            this.log.error(message.getClass().getSimpleName() + " for " + message.getExecutionType() + ' ' + message.getExecutionId() + " for " + message.getApplication());
            this.getRepository().updateStatus(message.getExecutionType(), message.getExecutionId(), ExecutionStatus.TERMINAL);
        }
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    public ConfigurationErrorHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.queue = queue;
        this.repository = repository;
        this.messageType = ConfigurationError.class;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }
}

