/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.ExecutionRunner;
import com.netflix.spinnaker.orca.q.CancelExecution;
import com.netflix.spinnaker.orca.q.RescheduleExecution;
import com.netflix.spinnaker.orca.q.RestartStage;
import com.netflix.spinnaker.orca.q.ResumeExecution;
import com.netflix.spinnaker.orca.q.StartExecution;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/orca/q/QueueExecutionRunner;", "Lcom/netflix/spinnaker/orca/pipeline/ExecutionRunner;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "(Lcom/netflix/spinnaker/q/Queue;)V", "cancel", "", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "user", "", "reason", "reschedule", "restart", "stageId", "start", "unpause", "orca-queue"})
public class QueueExecutionRunner
implements ExecutionRunner {
    private final Queue queue;

    public void start(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        this.queue.push((Message)new StartExecution(execution));
    }

    public void reschedule(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        this.queue.push((Message)new RescheduleExecution(execution));
    }

    public void restart(@NotNull PipelineExecution execution, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.queue.push((Message)new RestartStage(execution, stageId, AuthenticatedRequest.getSpinnakerUser().orElse(null)));
    }

    public void unpause(@NotNull PipelineExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        this.queue.push((Message)new ResumeExecution(execution));
    }

    public void cancel(@NotNull PipelineExecution execution, @NotNull String user, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.queue.push((Message)new CancelExecution(execution, user, reason));
    }

    public QueueExecutionRunner(@NotNull Queue queue) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        this.queue = queue;
    }
}

