/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.TaskComplete;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.q.CompleteStage;
import com.netflix.spinnaker.orca.q.CompleteTask;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.IteratorsKt;
import com.netflix.spinnaker.orca.q.NoDownstreamTasks;
import com.netflix.spinnaker.orca.q.SkipStage;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartTask;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.metrics.MetricsTagHelper;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0002H\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010'H\u0016J \u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0012J\f\u0010-\u001a\u00020 *\u00020+H\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lcom/netflix/spinnaker/orca/q/handler/CompleteTaskHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/CompleteTask;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "handle", "", "message", "shouldCompleteStage", "", "task", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "status", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "originalStatus", "trackResult", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "taskModel", "handleRedirect", "orca-queue"})
public class CompleteTaskHandler
implements OrcaMessageHandler<CompleteTask>,
ExpressionAware {
    @NotNull
    private final Class<CompleteTask> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    private final ApplicationEventPublisher publisher;
    private final Clock clock;
    private final Registry registry;

    public void handle(@NotNull CompleteTask message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withTask(message, (Function2<? super StageExecution, ? super TaskExecution, Unit>)((Function2)new Function2<StageExecution, TaskExecution, Unit>(this, message){
            final /* synthetic */ CompleteTaskHandler this$0;
            final /* synthetic */ CompleteTask $message;

            public final void invoke(@NotNull StageExecution stage, @NotNull TaskExecution task) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                task.setStatus(this.$message.getStatus());
                task.setEndTime(Long.valueOf(CompleteTaskHandler.access$getClock$p(this.this$0).millis()));
                StageExecution mergedContextStage = this.this$0.withMergedContext(stage);
                CompleteTaskHandler.access$trackResult(this.this$0, stage, task, this.$message.getStatus());
                if (this.$message.getStatus() == ExecutionStatus.REDIRECT) {
                    CompleteTaskHandler.access$handleRedirect(this.this$0, mergedContextStage);
                } else {
                    this.this$0.getRepository().storeStage(mergedContextStage);
                    if (StageKt.isManuallySkipped((StageExecution)stage)) {
                        Queue queue = this.this$0.getQueue();
                        StageExecution stageExecution = stage.getTopLevelStage();
                        Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"stage.topLevelStage");
                        queue.push((Message)new SkipStage(stageExecution));
                    } else if (this.this$0.shouldCompleteStage(task, this.$message.getStatus(), this.$message.getOriginalStatus())) {
                        this.this$0.getQueue().push((Message)new CompleteStage(this.$message));
                    } else {
                        TaskExecution taskExecution = StageKt.nextTask((StageExecution)mergedContextStage, (TaskExecution)task);
                        boolean bl = false;
                        boolean bl2 = false;
                        TaskExecution it = taskExecution;
                        boolean bl3 = false;
                        if (it == null) {
                            this.this$0.getQueue().push((Message)new NoDownstreamTasks(this.$message));
                        } else {
                            Queue queue = this.this$0.getQueue();
                            StageLevel stageLevel = this.$message;
                            String string = it.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                            queue.push((Message)new StartTask(stageLevel, string));
                        }
                    }
                    CompleteTaskHandler.access$getPublisher$p(this.this$0).publishEvent((ApplicationEvent)new TaskComplete((Object)this.this$0, mergedContextStage, task));
                }
            }
            {
                this.this$0 = completeTaskHandler;
                this.$message = completeTask;
                super(2);
            }
        }));
    }

    public boolean shouldCompleteStage(@NotNull TaskExecution task, @NotNull ExecutionStatus status, @Nullable ExecutionStatus originalStatus) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (task.isStageEnd()) {
            return true;
        }
        if (originalStatus == ExecutionStatus.FAILED_CONTINUE) {
            return false;
        }
        return status.isHalt();
    }

    @NotNull
    public Class<CompleteTask> getMessageType() {
        return this.messageType;
    }

    private void handleRedirect(StageExecution $this$handleRedirect) {
        int n;
        int start;
        List tasks;
        block5: {
            int n2;
            block4: {
                List list = $this$handleRedirect.getTasks();
                boolean bl = false;
                boolean bl2 = false;
                tasks = list;
                boolean bl3 = false;
                List list2 = tasks;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"tasks");
                List $this$indexOfFirst$iv = list2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    TaskExecution it = (TaskExecution)item$iv;
                    boolean bl4 = false;
                    TaskExecution taskExecution = it;
                    Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
                    if (taskExecution.isLoopStart()) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            start = n2;
            List $this$indexOfLast$iv = tasks;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                TaskExecution it = (TaskExecution)iterator$iv.previous();
                boolean bl = false;
                TaskExecution taskExecution = it;
                Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
                if (!taskExecution.isLoopEnd()) continue;
                n = iterator$iv.nextIndex();
                break block5;
            }
            n = -1;
        }
        int end = n;
        int $this$indexOfLast$iv = start;
        Iterable $this$forEach$iv = IteratorsKt.get(tasks, new IntRange($this$indexOfLast$iv, end));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskExecution it = (TaskExecution)element$iv;
            boolean bl = false;
            TaskExecution taskExecution = it;
            Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"it");
            taskExecution.setEndTime((Long)null);
            it.setStatus(ExecutionStatus.NOT_STARTED);
        }
        this.getRepository().storeStage($this$handleRedirect);
        Queue queue = this.getQueue();
        PipelineExecution pipelineExecution = $this$handleRedirect.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
        ExecutionType executionType = pipelineExecution.getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"execution.type");
        PipelineExecution pipelineExecution2 = $this$handleRedirect.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"execution");
        String string = pipelineExecution2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execution.id");
        PipelineExecution pipelineExecution3 = $this$handleRedirect.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"execution");
        String string2 = pipelineExecution3.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"execution.application");
        String string3 = $this$handleRedirect.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id");
        Object e = tasks.get(start);
        Intrinsics.checkNotNullExpressionValue(e, (String)"tasks[start]");
        String string4 = ((TaskExecution)e).getId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tasks[start].id");
        queue.push((Message)new StartTask(executionType, string, string2, string3, string4));
    }

    private void trackResult(StageExecution stage, TaskExecution taskModel, ExecutionStatus status) {
        try {
            Iterable<BasicTag> commonTags = MetricsTagHelper.Companion.commonTags(stage, taskModel, status);
            Iterable<BasicTag> detailedTags = MetricsTagHelper.Companion.detailedTaskTags(stage, taskModel, status);
            long l = this.clock.millis();
            Long l2 = taskModel.getStartTime();
            if (l2 == null) {
                l2 = 0L;
            }
            Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"taskModel.startTime ?: 0");
            long elapsedMillis = l - l2;
            Pair[] pairArray = new Pair[2];
            PipelineExecution pipelineExecution = stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
            pairArray[0] = TuplesKt.to((Object)"task.completions.duration", (Object)CollectionsKt.plus(commonTags, (Object)new BasicTag("application", pipelineExecution.getApplication())));
            pairArray[1] = TuplesKt.to((Object)"task.completions.duration.withType", (Object)CollectionsKt.plus(commonTags, detailedTags));
            MapsKt.hashMapOf((Pair[])pairArray).forEach((BiConsumer)new BiConsumer<String, List<? extends BasicTag>>(this, elapsedMillis){
                final /* synthetic */ CompleteTaskHandler this$0;
                final /* synthetic */ long $elapsedMillis;

                public final void accept(@NotNull String name, @NotNull List<BasicTag> tags) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter(tags, (String)"tags");
                    CompleteTaskHandler.access$getRegistry$p(this.this$0).timer(name, (Iterable)tags).record(this.$elapsedMillis, TimeUnit.MILLISECONDS);
                }
                {
                    this.this$0 = completeTaskHandler;
                    this.$elapsedMillis = l;
                }
            });
        }
        catch (Exception e) {
            this.getLog().warn("Failed to track result for stage: " + stage.getId() + ", task: " + taskModel.getId(), (Throwable)e);
        }
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    public CompleteTaskHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull ContextParameterProcessor contextParameterProcessor, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull Clock clock, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.queue = queue;
        this.repository = repository;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.contextParameterProcessor = contextParameterProcessor;
        this.publisher = publisher;
        this.clock = clock;
        this.registry = registry;
        this.messageType = CompleteTask.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMergedContext, (String)"$this$withMergedContext");
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        Intrinsics.checkNotNullParameter((Object)$this$includeExpressionEvaluationSummary, (String)"$this$includeExpressionEvaluationSummary");
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFailedExpressions, (String)"$this$hasFailedExpressions");
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldFailOnFailedExpressionEvaluation, (String)"$this$shouldFailOnFailedExpressionEvaluation");
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    public static final /* synthetic */ Clock access$getClock$p(CompleteTaskHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ void access$trackResult(CompleteTaskHandler $this, StageExecution stage, TaskExecution taskModel, ExecutionStatus status) {
        $this.trackResult(stage, taskModel, status);
    }

    public static final /* synthetic */ void access$handleRedirect(CompleteTaskHandler $this, StageExecution $this$access_u24handleRedirect) {
        $this.handleRedirect($this$access_u24handleRedirect);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(CompleteTaskHandler $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ Registry access$getRegistry$p(CompleteTaskHandler $this) {
        return $this.registry;
    }
}

