/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.pending;

import com.netflix.spinnaker.orca.q.pending.InMemoryPendingExecutionService;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J$\u0010\u0013\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0015H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/orca/q/pending/InMemoryPendingExecutionService;", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "()V", "pending", "", "", "Ljava/util/Deque;", "Lcom/netflix/spinnaker/q/Message;", "depth", "", "pipelineConfigId", "enqueue", "", "message", "pendingFor", "pendingIds", "", "popNewest", "popOldest", "purge", "callback", "Lkotlin/Function1;", "orca-queue"})
public final class InMemoryPendingExecutionService
implements PendingExecutionService {
    private final Map<String, Deque<Message>> pending;

    @Override
    public void enqueue(@NotNull String pipelineConfigId, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.pendingFor(pipelineConfigId).addLast(message);
    }

    @Override
    @Nullable
    public Message popOldest(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Deque<Message> deque = this.pendingFor(pipelineConfigId);
        boolean bl = false;
        boolean bl2 = false;
        Deque<Message> it = deque;
        boolean bl3 = false;
        return it.isEmpty() ? null : it.removeFirst();
    }

    @Override
    @Nullable
    public Message popNewest(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Deque<Message> deque = this.pendingFor(pipelineConfigId);
        boolean bl = false;
        boolean bl2 = false;
        Deque<Message> it = deque;
        boolean bl3 = false;
        return it.isEmpty() ? null : it.removeLast();
    }

    @Override
    public void purge(@NotNull String pipelineConfigId, @NotNull Function1<? super Message, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Deque<Message> deque = this.pendingFor(pipelineConfigId);
        boolean bl = false;
        boolean bl2 = false;
        Deque<Message> it = deque;
        boolean bl3 = false;
        while (true) {
            Collection collection = it;
            boolean bl4 = false;
            if (!(!collection.isEmpty())) break;
            Message message = it.removeFirst();
            if (message == null) continue;
            collection = message;
            Function1<? super Message, Unit> function1 = callback;
            boolean bl5 = false;
            boolean bl6 = false;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)collection);
        }
    }

    @Override
    public int depth(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        return this.pendingFor(pipelineConfigId).size();
    }

    @Override
    @NotNull
    public List<String> pendingIds() {
        return CollectionsKt.toList((Iterable)this.pending.keySet());
    }

    private final Deque<Message> pendingFor(String pipelineConfigId) {
        Deque<Message> deque = this.pending.computeIfAbsent(pipelineConfigId, pendingFor.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(deque, (String)"pending.computeIfAbsent(\u2026onfigId) { LinkedList() }");
        return deque;
    }

    public InMemoryPendingExecutionService() {
        boolean bl = false;
        this.pending = new LinkedHashMap();
    }
}

