/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.ZombieExecutionService;
import com.netflix.spinnaker.orca.q.ZombieExecutionService$sam$java_util_function_Supplier$0;
import com.netflix.spinnaker.orca.q.ZombieExecutionService$sam$rx_functions_Func1$0;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.metrics.MonitorableQueue;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

@Component
@ConditionalOnBean(value={MonitorableQueue.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0017H\u0012J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0012\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u0017H\u0016J\u001a\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/orca/q/ZombieExecutionService;", "", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "queue", "Lcom/netflix/spinnaker/q/metrics/MonitorableQueue;", "clock", "Ljava/time/Clock;", "scheduler", "Ljava/util/Optional;", "Lrx/Scheduler;", "(Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/q/metrics/MonitorableQueue;Ljava/time/Clock;Ljava/util/Optional;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "findAllZombies", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "minimumInactivity", "Ljava/time/Duration;", "hasBeenAroundAWhile", "", "execution", "cutoff", "killZombie", "", "killZombies", "minimumActivity", "application", "", "queueHasNoMessages", "orca-queue"})
public class ZombieExecutionService {
    private final Lazy log$delegate;
    private final ExecutionRepository executionRepository;
    private final MonitorableQueue queue;
    private final Clock clock;
    private final Optional<Scheduler> scheduler;

    private Logger getLog() {
        Lazy lazy = this.log$delegate;
        ZombieExecutionService zombieExecutionService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public List<PipelineExecution> findAllZombies(@NotNull Duration minimumInactivity) {
        Function0 function0;
        Intrinsics.checkNotNullParameter((Object)minimumInactivity, (String)"minimumInactivity");
        ExecutionRepository.ExecutionCriteria executionCriteria = new ExecutionRepository.ExecutionCriteria().setStatuses(new ExecutionStatus[]{ExecutionStatus.RUNNING});
        Intrinsics.checkNotNullExpressionValue((Object)executionCriteria, (String)"ExecutionRepository.Exec\u2026(ExecutionStatus.RUNNING)");
        ExecutionRepository.ExecutionCriteria criteria = executionCriteria;
        Observable observable = this.executionRepository.retrieve(ExecutionType.PIPELINE, criteria).mergeWith(this.executionRepository.retrieve(ExecutionType.ORCHESTRATION, criteria));
        Object object = findAllZombies.1.INSTANCE;
        if (object != null) {
            function0 = object;
            object = new ZombieExecutionService$sam$java_util_function_Supplier$0(function0);
        }
        function0 = (Function1)new Function1<PipelineExecution, Boolean>(this){

            public final boolean invoke(@NotNull PipelineExecution p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ZombieExecutionService.access$queueHasNoMessages((ZombieExecutionService)this.receiver, p1);
            }
        };
        Object object2 = observable.subscribeOn(this.scheduler.orElseGet((Supplier)object)).filter((Func1)new Func1<PipelineExecution, Boolean>(this, minimumInactivity){
            final /* synthetic */ ZombieExecutionService this$0;
            final /* synthetic */ Duration $minimumInactivity;

            public final Boolean call(PipelineExecution it) {
                PipelineExecution pipelineExecution = it;
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"it");
                return ZombieExecutionService.access$hasBeenAroundAWhile(this.this$0, pipelineExecution, this.$minimumInactivity);
            }
            {
                this.this$0 = zombieExecutionService;
                this.$minimumInactivity = duration;
            }
        }).filter((Func1)new ZombieExecutionService$sam$rx_functions_Func1$0((Function1)function0)).toList().toBlocking().first();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"executionRepository.retr\u2026Blocking()\n      .first()");
        return (List)object2;
    }

    public void killZombies(@NotNull Duration minimumActivity) {
        Intrinsics.checkNotNullParameter((Object)minimumActivity, (String)"minimumActivity");
        Iterable $this$forEach$iv = this.findAllZombies(minimumActivity);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PipelineExecution it = (PipelineExecution)element$iv;
            boolean bl = false;
            this.killZombie(it);
        }
    }

    public static /* synthetic */ void killZombies$default(ZombieExecutionService zombieExecutionService, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: killZombies");
        }
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofMinutes(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofMinutes(60)");
            duration = duration2;
        }
        zombieExecutionService.killZombies(duration);
    }

    /*
     * WARNING - void declaration
     */
    public void killZombies(@NotNull String application, @NotNull Duration minimumActivity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)minimumActivity, (String)"minimumActivity");
        Iterable $this$filter$iv = this.findAllZombies(minimumActivity);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PipelineExecution it = (PipelineExecution)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getApplication(), (Object)application)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PipelineExecution zombie = (PipelineExecution)element$iv;
            boolean bl = false;
            this.killZombie(zombie);
        }
    }

    public static /* synthetic */ void killZombies$default(ZombieExecutionService zombieExecutionService, String string, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: killZombies");
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofMinutes(60)");
            duration = duration2;
        }
        zombieExecutionService.killZombies(string, duration);
    }

    /*
     * WARNING - void declaration
     */
    public void killZombie(@NotNull PipelineExecution execution) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        this.getLog().warn("Force cancelling zombie execution and all of its stages: " + execution.getApplication() + '/' + execution.getId());
        List list = execution.getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution.stages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            StageExecution stageExecution = it;
            Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
            if (!(stageExecution.getStatus() == ExecutionStatus.RUNNING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StageExecution it = (StageExecution)element$iv;
            boolean bl = false;
            StageExecution stageExecution = it;
            Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
            stageExecution.setStatus(ExecutionStatus.CANCELED);
            it.setEndTime(Long.valueOf(this.clock.millis()));
        }
        execution.setStatus(ExecutionStatus.CANCELED);
        execution.setCancellationReason("Identified as a zombie execution");
        execution.setCanceledBy(AuthenticatedRequest.getSpinnakerUser().orElse("admin"));
    }

    private boolean hasBeenAroundAWhile(PipelineExecution execution, Duration cutoff) {
        Long l = execution.getBuildTime();
        Intrinsics.checkNotNull((Object)l);
        return Instant.ofEpochMilli(l).isBefore(this.clock.instant().minus(cutoff));
    }

    private boolean queueHasNoMessages(PipelineExecution execution) {
        return !this.queue.containsMessage((Function1)new Function1<Message, Boolean>(execution){
            final /* synthetic */ PipelineExecution $execution;

            public final boolean invoke(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return message instanceof ExecutionLevel && Intrinsics.areEqual((Object)((ExecutionLevel)message).getExecutionId(), (Object)this.$execution.getId());
            }
            {
                this.$execution = pipelineExecution;
                super(1);
            }
        });
    }

    public ZombieExecutionService(@NotNull ExecutionRepository executionRepository, @NotNull MonitorableQueue queue, @NotNull Clock clock, @Qualifier(value="scheduler") @NotNull Optional<Scheduler> scheduler) {
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(scheduler, (String)"scheduler");
        this.executionRepository = executionRepository;
        this.queue = queue;
        this.clock = clock;
        this.scheduler = scheduler;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ ZombieExecutionService this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = zombieExecutionService;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ boolean access$hasBeenAroundAWhile(ZombieExecutionService $this, PipelineExecution execution, Duration cutoff) {
        return $this.hasBeenAroundAWhile(execution, cutoff);
    }

    public static final /* synthetic */ boolean access$queueHasNoMessages(ZombieExecutionService $this, PipelineExecution execution) {
        return $this.queueHasNoMessages(execution);
    }
}

