/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.AuthenticatedStage;
import com.netflix.spinnaker.orca.ExecutionContext;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware$sam$java_util_concurrent_Callable$0;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\f\u001a\u00020\r*\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "backtrackStages", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "stage", "retrieveAuthenticatedUser", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution$AuthenticationDetails;", "solveAuthStages", "withAuth", "", "block", "Lkotlin/Function0;", "orca-queue"})
public interface AuthenticationAware {
    @NotNull
    public StageNavigator getStageNavigator();

    public void withAuth(@NotNull StageExecution var1, @NotNull Function0<Unit> var2);

    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution var1);

    @NotNull
    public StageExecution backtrackStages(@NotNull StageExecution var1);

    @NotNull
    public StageExecution solveAuthStages(@NotNull StageExecution var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void withAuth(@NotNull AuthenticationAware $this, @NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withAuth, (String)"$this$withAuth");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            PipelineExecution.AuthenticationDetails authenticationDetails = $this.retrieveAuthenticatedUser($this$withAuth);
            if (authenticationDetails == null) {
                PipelineExecution pipelineExecution = $this$withAuth.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
                authenticationDetails = pipelineExecution.getAuthentication();
            }
            PipelineExecution.AuthenticationDetails currentUser = authenticationDetails;
            String string = $this$withAuth.getContext().getOrDefault("account", "unknown");
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String account = string;
            String string2 = $this$withAuth.getContext().getOrDefault("cloudProvider", "unknown");
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String cloudProvider = string2;
            try {
                PipelineExecution pipelineExecution = $this$withAuth.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
                String string3 = pipelineExecution.getApplication();
                PipelineExecution.AuthenticationDetails authenticationDetails2 = currentUser;
                String string4 = authenticationDetails2 != null ? authenticationDetails2.getUser() : null;
                PipelineExecution pipelineExecution2 = $this$withAuth.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"execution");
                Function0<Unit> function0 = pipelineExecution2.getType().name();
                boolean bl = false;
                Function0<Unit> function02 = function0;
                if (function02 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = function02.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                PipelineExecution pipelineExecution3 = $this$withAuth.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"execution");
                String string6 = pipelineExecution3.getId();
                String string7 = $this$withAuth.getId();
                PipelineExecution pipelineExecution4 = $this$withAuth.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution4, (String)"execution");
                String string8 = pipelineExecution4.getOrigin();
                function0 = account;
                bl = false;
                Function0<Unit> function03 = function0;
                if (function03 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = function03.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                function0 = cloudProvider;
                bl = false;
                Function0<Unit> function04 = function0;
                if (function04 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = function04.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
                ExecutionContext.set((ExecutionContext)new ExecutionContext(string3, string4, string5, string6, string7, string8, string9, string10, $this$withAuth.getStartTime()));
                PipelineExecution.AuthenticationDetails authenticationDetails3 = currentUser;
                if (StringUtils.isNotBlank((CharSequence)(authenticationDetails3 != null ? authenticationDetails3.getUser() : null))) {
                    PipelineExecution.AuthenticationDetails authenticationDetails4 = currentUser;
                    Intrinsics.checkNotNullExpressionValue((Object)authenticationDetails4, (String)"currentUser");
                    function0 = block;
                    AuthenticatedRequest.runAs((String)authenticationDetails4.getUser(), (Collection)currentUser.getAllowedAccounts(), (boolean)false, (Callable)new AuthenticationAware$sam$java_util_concurrent_Callable$0(function0)).call();
                } else {
                    function0 = block;
                    AuthenticatedRequest.propagate((Callable)new AuthenticationAware$sam$java_util_concurrent_Callable$0(function0), (boolean)false).call();
                }
            }
            finally {
                ExecutionContext.clear();
            }
        }

        @Nullable
        public static PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull AuthenticationAware $this, @NotNull StageExecution stage) {
            PipelineExecution.AuthenticationDetails authenticationDetails;
            Object v2;
            block4: {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                List list = $this.getStageNavigator().ancestors(stage);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stageNavigator\n      .ancestors(stage)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    StageNavigator.Result it = (StageNavigator.Result)element$iv;
                    boolean bl = false;
                    StageNavigator.Result result = it;
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"it");
                    if (!(result.getStageBuilder() instanceof AuthenticatedStage)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            StageNavigator.Result result = v2;
            if (result != null) {
                StageNavigator.Result result2 = result;
                boolean bl = false;
                boolean bl2 = false;
                StageNavigator.Result it = result2;
                boolean bl3 = false;
                StageDefinitionBuilder stageDefinitionBuilder = it.getStageBuilder();
                if (stageDefinitionBuilder == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.orca.AuthenticatedStage");
                }
                AuthenticatedStage authenticatedStage = (AuthenticatedStage)stageDefinitionBuilder;
                StageExecution stageExecution = it.getStage();
                Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it.stage");
                authenticationDetails = authenticatedStage.authenticatedUser($this.solveAuthStages(stageExecution)).orElse(null);
            } else {
                authenticationDetails = null;
            }
            return authenticationDetails;
        }

        @NotNull
        public static StageExecution backtrackStages(@NotNull AuthenticationAware $this, @NotNull StageExecution stage) {
            StageExecution stageExecution;
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            if (stage.isManualJudgmentType()) {
                ExecutionStatus executionStatus = stage.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"stage.status");
                if (!executionStatus.isSkipped() && stage.withPropagateAuthentication()) {
                    return stage;
                }
            }
            if ($this.getStageNavigator().ancestors(stage).size() > 1) {
                Object e = $this.getStageNavigator().ancestors(stage).get(1);
                Intrinsics.checkNotNullExpressionValue(e, (String)"stageNavigator.ancestors(stage).get(1)");
                stageExecution = ((StageNavigator.Result)e).getStage();
            } else {
                stageExecution = null;
            }
            StageExecution previousStage = stageExecution;
            return previousStage == null ? stage : $this.backtrackStages(previousStage);
        }

        @NotNull
        public static StageExecution solveAuthStages(@NotNull AuthenticationAware $this, @NotNull StageExecution stage) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            if (stage.isManualJudgmentType()) {
                StageExecution result = $this.backtrackStages(stage);
                stage.setLastModified(result.getLastModified());
                return result;
            }
            return stage;
        }
    }
}

