/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.StageComplete;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.graph.StageGraphBuilderImpl;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CancelStage;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.CompleteStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageDefinitionBuildersKt;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.CompleteStageHandler;
import com.netflix.spinnaker.orca.q.handler.CompleteStageHandlerKt;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005BU\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0012J\f\u0010.\u001a\u00020/*\u00020-H\u0012J\f\u00100\u001a\u00020)*\u00020-H\u0012J\f\u00101\u001a\u000202*\u00020-H\u0012J\f\u00103\u001a\u00020)*\u00020-H\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00064"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/CompleteStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/CompleteStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "exceptionHandlers", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "registry", "Lcom/netflix/spectator/api/Registry;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;Ljava/util/List;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "handle", "", "message", "trackResult", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "determineStatus", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "planAfterStages", "planOnFailureStages", "", "removeNotStartedSynthetics", "orca-queue"})
public class CompleteStageHandler
implements OrcaMessageHandler<CompleteStage>,
StageBuilderAware,
ExpressionAware,
AuthenticationAware {
    @NotNull
    private final Class<CompleteStage> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageNavigator stageNavigator;
    private final ApplicationEventPublisher publisher;
    private final Clock clock;
    private final List<ExceptionHandler> exceptionHandlers;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    private final Registry registry;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;

    public void handle(@NotNull CompleteStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, message){
            final /* synthetic */ CompleteStageHandler this$0;
            final /* synthetic */ CompleteStage $message;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                if (SetsKt.setOf((Object[])new ExecutionStatus[]{ExecutionStatus.RUNNING, ExecutionStatus.NOT_STARTED}).contains(stage.getStatus())) {
                    ExecutionStatus status = CompleteStageHandler.access$determineStatus(this.this$0, stage);
                    if (this.this$0.shouldFailOnFailedExpressionEvaluation(stage)) {
                        Logger logger = this.this$0.getLog();
                        StringBuilder stringBuilder = new StringBuilder().append("Stage ").append(stage.getId()).append(" (").append(stage.getType()).append(") of ");
                        PipelineExecution pipelineExecution = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                        logger.warn(stringBuilder.append(pipelineExecution.getId()).append(' ').append("is set to fail because of failed expressions.").toString());
                        status = ExecutionStatus.TERMINAL;
                    }
                    try {
                        Object hasOnFailureStages;
                        String $this$forEach$iv2;
                        boolean bl;
                        List afterStages;
                        if (SetsKt.setOf((Object[])new ExecutionStatus[]{ExecutionStatus.RUNNING, ExecutionStatus.NOT_STARTED}).contains(status) || status.isComplete() && !status.isHalt()) {
                            afterStages = StageKt.firstAfterStages((StageExecution)stage);
                            if (afterStages.isEmpty()) {
                                this.this$0.withAuth(stage, (Function0<Unit>)((Function0)new Function0<Unit>(this, stage){
                                    final /* synthetic */ handle.1 this$0;
                                    final /* synthetic */ StageExecution $stage;

                                    public final void invoke() {
                                        CompleteStageHandler.access$planAfterStages(this.this$0.this$0, this.$stage);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$stage = stageExecution;
                                        super(0);
                                    }
                                }));
                                afterStages = StageKt.firstAfterStages((StageExecution)stage);
                            }
                            Collection collection = afterStages;
                            bl = false;
                            if (!collection.isEmpty()) {
                                boolean bl2;
                                Iterable $this$any$iv;
                                block42: {
                                    $this$any$iv = afterStages;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            StageExecution it = (StageExecution)element$iv;
                                            boolean bl3 = false;
                                            if (!(it.getStatus() == ExecutionStatus.NOT_STARTED)) continue;
                                            bl2 = true;
                                            break block42;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (bl2) {
                                    Iterator<T> $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    $this$any$iv = afterStages;
                                    boolean $i$f$filter = false;
                                    Iterator<T> iterator = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    Iterator<T> bl3 = $this$filterTo$iv$iv.iterator();
                                    while (bl3.hasNext()) {
                                        T element$iv$iv = bl3.next();
                                        StageExecution it = (StageExecution)element$iv$iv;
                                        boolean bl4 = false;
                                        if (!(it.getStatus() == ExecutionStatus.NOT_STARTED)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    boolean $i$f$forEach = false;
                                    $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
                                    while ($this$filterTo$iv$iv.hasNext()) {
                                        T element$iv;
                                        element$iv = $this$filterTo$iv$iv.next();
                                        StageExecution it = (StageExecution)element$iv;
                                        boolean bl5 = false;
                                        Queue queue = this.this$0.getQueue();
                                        ExecutionLevel executionLevel = this.$message;
                                        String string = it.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                                        queue.push((Message)new StartStage(executionLevel, string));
                                    }
                                    return;
                                }
                            }
                            if (status == ExecutionStatus.NOT_STARTED) {
                                Logger logger = this.this$0.getLog();
                                StringBuilder stringBuilder = new StringBuilder().append("Stage ").append(stage.getId()).append(" (").append(stage.getType()).append(") of ");
                                PipelineExecution pipelineExecution = stage.getExecution();
                                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                                logger.warn(stringBuilder.append(pipelineExecution.getId()).append(" had no tasks or synthetic stages!").toString());
                                status = ExecutionStatus.SKIPPED;
                            }
                        } else if (status.isFailure()) {
                            afterStages = new Ref.BooleanRef();
                            ((Ref.BooleanRef)afterStages).element = false;
                            this.this$0.withAuth(stage, (Function0<Unit>)((Function0)new Function0<Unit>(this, (Ref.BooleanRef)hasOnFailureStages, stage){
                                final /* synthetic */ handle.1 this$0;
                                final /* synthetic */ Ref.BooleanRef $hasOnFailureStages;
                                final /* synthetic */ StageExecution $stage;

                                public final void invoke() {
                                    this.$hasOnFailureStages.element = CompleteStageHandler.access$planOnFailureStages(this.this$0.this$0, this.$stage);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$hasOnFailureStages = booleanRef;
                                    this.$stage = stageExecution;
                                    super(0);
                                }
                            }));
                            if (((Ref.BooleanRef)hasOnFailureStages).element) {
                                Iterable $this$forEach$iv2 = StageKt.firstAfterStages((StageExecution)stage);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv2) {
                                    StageExecution it = (StageExecution)element$iv;
                                    boolean bl6 = false;
                                    this.this$0.getQueue().push((Message)new StartStage(it));
                                }
                                return;
                            }
                        }
                        stage.setStatus(status);
                        if (status == ExecutionStatus.FAILED_CONTINUE) {
                            void $this$forEach$iv3;
                            void $this$filterTo$iv$iv;
                            Object v16;
                            Object v15;
                            Object v13;
                            Object v12;
                            V v = stage.getContext().get("exception");
                            if (!(v instanceof HashMap)) {
                                v = null;
                            }
                            HashMap hashMap = (HashMap)v;
                            if (hashMap != null) {
                                hasOnFailureStages = hashMap;
                                $this$forEach$iv2 = "details";
                                bl = false;
                                v12 = hasOnFailureStages.get($this$forEach$iv2);
                            } else {
                                v12 = v13 = null;
                            }
                            if (!(v12 instanceof HashMap)) {
                                v13 = null;
                            }
                            HashMap hashMap2 = v13;
                            if (hashMap2 != null) {
                                hasOnFailureStages = hashMap2;
                                $this$forEach$iv2 = "errors";
                                bl = false;
                                v15 = hasOnFailureStages.get($this$forEach$iv2);
                            } else {
                                v15 = v16 = null;
                            }
                            if (!(v15 instanceof ArrayList)) {
                                v16 = null;
                            }
                            hasOnFailureStages = v16;
                            boolean $this$forEach$iv2 = false;
                            bl = false;
                            Object $this$apply = hasOnFailureStages;
                            boolean bl7 = false;
                            List list = stage.getTasks();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stage.tasks");
                            Iterable $this$filter$iv = list;
                            boolean $i$f$filter = false;
                            Iterable element$iv$iv = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                                Map map;
                                TaskExecution t = (TaskExecution)element$iv$iv2;
                                boolean bl8 = false;
                                TaskExecution taskExecution = t;
                                Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"t");
                                Intrinsics.checkNotNullExpressionValue((Object)taskExecution.getTaskExceptionDetails(), (String)"t.taskExceptionDetails");
                                boolean bl9 = false;
                                if (!(!map.isEmpty())) continue;
                                destination$iv$iv.add(element$iv$iv2);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv3) {
                                void $this$forEach$iv4;
                                Object element$iv$iv2;
                                TaskExecution y = (TaskExecution)element$iv;
                                boolean bl10 = false;
                                TaskExecution taskExecution = y;
                                Intrinsics.checkNotNullExpressionValue((Object)taskExecution, (String)"y");
                                V v2 = taskExecution.getTaskExceptionDetails().get("exception");
                                if (v2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.HashMap<*, *> /* = java.util.HashMap<*, *> */");
                                }
                                element$iv$iv2 = (HashMap)v2;
                                String t = "details";
                                boolean bl11 = false;
                                V v3 = element$iv$iv2.get(t);
                                if (v3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.HashMap<*, *> /* = java.util.HashMap<*, *> */");
                                }
                                HashMap details = (HashMap)v3;
                                Object object = $this$apply;
                                if (object != null) {
                                    ((ArrayList)object).add(y.getName() + ":");
                                }
                                Object object2 = $this$apply;
                                if (object2 != null) {
                                    element$iv$iv2 = details;
                                    t = "error";
                                    bl11 = false;
                                    V v4 = element$iv$iv2.get(t);
                                    if (v4 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    ((ArrayList)object2).add((String)v4);
                                }
                                element$iv$iv2 = details;
                                t = "errors";
                                bl11 = false;
                                V v5 = element$iv$iv2.get(t);
                                if (v5 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.ArrayList<*> /* = java.util.ArrayList<*> */");
                                }
                                element$iv$iv2 = (ArrayList)v5;
                                boolean $i$f$forEach2 = false;
                                Iterator<T> iterator = $this$forEach$iv4.iterator();
                                while (iterator.hasNext()) {
                                    T element$iv2;
                                    T t2 = element$iv2 = iterator.next();
                                    boolean bl12 = false;
                                    Object object3 = $this$apply;
                                    if (object3 == null) continue;
                                    T t3 = t2;
                                    if (t3 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    ((ArrayList)object3).add((String)t3);
                                }
                            }
                        }
                        stage.setEndTime(Long.valueOf(CompleteStageHandler.access$getClock$p(this.this$0).millis()));
                    }
                    catch (Exception e) {
                        this.this$0.getLog().error("Failed to construct after stages for " + stage.getName() + ' ' + stage.getId(), (Throwable)e);
                        ExceptionHandler.Response exceptionDetails = this.this$0.shouldRetry(CompleteStageHandler.access$getExceptionHandlers$p(this.this$0), e, stage.getName() + ":ConstructAfterStages");
                        Map map = stage.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"stage.context");
                        map.put("exception", exceptionDetails);
                        stage.setStatus(ExecutionStatus.TERMINAL);
                        stage.setEndTime(Long.valueOf(CompleteStageHandler.access$getClock$p(this.this$0).millis()));
                    }
                    this.this$0.includeExpressionEvaluationSummary(stage);
                    this.this$0.getRepository().storeStage(stage);
                    if (stage.getStatus() == ExecutionStatus.FAILED_CONTINUE && stage.getSyntheticStageOwner() != null && !stage.getAllowSiblingStagesToContinueOnFailure()) {
                        Queue queue = this.this$0.getQueue();
                        String string = stage.getParentStageId();
                        Intrinsics.checkNotNull((Object)string);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.parentStageId!!");
                        queue.push((Message)CompleteStage.copy$default(this.$message, null, null, null, string, 7, null));
                    } else if (CollectionsKt.listOf((Object[])new ExecutionStatus[]{ExecutionStatus.SUCCEEDED, ExecutionStatus.FAILED_CONTINUE, ExecutionStatus.SKIPPED}).contains(stage.getStatus())) {
                        this.this$0.startNext(stage);
                    } else {
                        this.this$0.getQueue().push((Message)new CancelStage(this.$message));
                        if (stage.getSyntheticStageOwner() == null) {
                            this.this$0.getLog().debug("Stage has no synthetic owner and status is '" + stage.getStatus() + "', completing execution (original message: " + this.$message + ')');
                            this.this$0.getQueue().push((Message)new CompleteExecution(this.$message));
                        } else {
                            Queue queue = this.this$0.getQueue();
                            String string = stage.getParentStageId();
                            Intrinsics.checkNotNull((Object)string);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.parentStageId!!");
                            queue.push((Message)CompleteStage.copy$default(this.$message, null, null, null, string, 7, null));
                        }
                    }
                    CompleteStageHandler.access$getPublisher$p(this.this$0).publishEvent((ApplicationEvent)new StageComplete((Object)this.this$0, stage));
                    CompleteStageHandler.access$trackResult(this.this$0, stage);
                }
            }
            {
                this.this$0 = completeStageHandler;
                this.$message = completeStage;
                super(1);
            }
        }));
    }

    private void trackResult(StageExecution stage) {
        Map map;
        block12: {
            Id id;
            block11: {
                Object it;
                boolean bl;
                boolean bl2;
                Object object;
                Object object2;
                boolean bl3;
                boolean bl4;
                Object object3;
                block10: {
                    block9: {
                        if (stage.getParentStageId() != null) {
                            return;
                        }
                        object3 = this.registry.createId("stage.invocations.duration").withTag("status", stage.getStatus().toString()).withTag("stageType", stage.getType());
                        bl4 = false;
                        bl3 = false;
                        id = object3;
                        boolean bl5 = false;
                        object2 = stage.getContext().get("cloudProvider");
                        if (object2 == null) break block9;
                        object = object2;
                        bl2 = false;
                        bl = false;
                        it = object;
                        boolean bl6 = false;
                        object2 = id.withTag("cloudProvider", it.toString());
                        if (object2 != null) break block10;
                    }
                    object2 = id;
                }
                object3 = object2;
                bl4 = false;
                bl3 = false;
                id = object3;
                boolean bl7 = false;
                map = stage.getAdditionalMetricTags();
                if (map == null) break block11;
                object = map;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl8 = false;
                map = id.withTags(stage.getAdditionalMetricTags());
                if (map != null) break block12;
            }
            map = id;
        }
        Map id = map;
        Long l = stage.getEndTime();
        if (l == null) {
            l = this.clock.millis();
        }
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"stage.endTime ?: clock.millis()");
        long endTime = l;
        Long l2 = stage.getStartTime();
        if (l2 == null) {
            l2 = endTime;
        }
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"stage.startTime ?: endTime");
        long startTime = l2;
        PercentileTimer.get((Registry)this.registry, (Id)id).record(endTime - startTime, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public Class<CompleteStage> getMessageType() {
        return this.messageType;
    }

    /*
     * WARNING - void declaration
     */
    private void planAfterStages(StageExecution $this$planAfterStages) {
        void hasPlannedStages;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        StageDefinitionBuildersKt.buildAfterStages(this.builder($this$planAfterStages), $this$planAfterStages, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, (Ref.BooleanRef)hasPlannedStages){
            final /* synthetic */ CompleteStageHandler this$0;
            final /* synthetic */ Ref.BooleanRef $hasPlannedStages;

            public final void invoke(@NotNull StageExecution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getRepository().addStage(it);
                this.$hasPlannedStages.element = true;
            }
            {
                this.this$0 = completeStageHandler;
                this.$hasPlannedStages = booleanRef;
                super(1);
            }
        }));
        if (hasPlannedStages.element) {
            ExecutionRepository executionRepository = this.getRepository();
            PipelineExecution pipelineExecution = $this$planAfterStages.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"this.execution");
            ExecutionType executionType = pipelineExecution.getType();
            PipelineExecution pipelineExecution2 = $this$planAfterStages.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"this.execution");
            $this$planAfterStages.setExecution(executionRepository.retrieve(executionType, pipelineExecution2.getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean planOnFailureStages(StageExecution $this$planOnFailureStages) {
        boolean bl;
        boolean alreadyPlanned;
        List onFailureStages;
        block9: {
            boolean bl2;
            boolean bl3;
            void $this$mapTo$iv$iv;
            StageExecution it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = StageKt.afterStages((StageExecution)$this$planOnFailureStages);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (StageExecution)element$iv$iv;
                boolean bl4 = false;
                ExecutionStatus executionStatus = it.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"it.status");
                if (!executionStatus.isComplete()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (StageExecution)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl3 = false;
                String string = it.getName();
                collection.add(string);
            }
            List previouslyPlannedAfterStageNames = (List)destination$iv$iv;
            StageGraphBuilderImpl stageGraphBuilderImpl = StageGraphBuilderImpl.afterStages((StageExecution)$this$planOnFailureStages);
            Intrinsics.checkNotNullExpressionValue((Object)stageGraphBuilderImpl, (String)"StageGraphBuilderImpl.afterStages(this)");
            StageGraphBuilderImpl graph = stageGraphBuilderImpl;
            this.builder($this$planOnFailureStages).onFailureStages($this$planOnFailureStages, (StageGraphBuilder)graph);
            Iterable iterable2 = graph.build();
            Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"graph.build()");
            onFailureStages = CollectionsKt.toList((Iterable)iterable2);
            Iterable $this$forEachIndexed$iv = onFailureStages;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stage;
                int it2 = index$iv++;
                bl3 = false;
                if (it2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                StageExecution stageExecution = (StageExecution)item$iv;
                int index = it2;
                boolean bl5 = false;
                if (index <= 0) continue;
                graph.connect((StageExecution)onFailureStages.get(index - 1), (StageExecution)stage);
            }
            Iterable $this$any$iv = onFailureStages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StageExecution it3 = (StageExecution)element$iv;
                    boolean bl6 = false;
                    StageExecution stageExecution = it3;
                    Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                    if (!previouslyPlannedAfterStageNames.contains(stageExecution.getName())) continue;
                    bl2 = true;
                    break block9;
                }
                bl2 = alreadyPlanned = false;
            }
        }
        if (alreadyPlanned || onFailureStages.isEmpty()) {
            bl = false;
        } else {
            this.removeNotStartedSynthetics($this$planOnFailureStages);
            StageDefinitionBuildersKt.appendAfterStages($this$planOnFailureStages, onFailureStages, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this){
                final /* synthetic */ CompleteStageHandler this$0;

                public final void invoke(@NotNull StageExecution it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getRepository().addStage(it);
                }
                {
                    this.this$0 = completeStageHandler;
                    super(1);
                }
            }));
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void removeNotStartedSynthetics(StageExecution $this$removeNotStartedSynthetics) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StageKt.syntheticStages((StageExecution)$this$removeNotStartedSynthetics);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getStatus() == ExecutionStatus.NOT_STARTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Object element$iv$iv;
            StageExecution stage = (StageExecution)element$iv;
            boolean bl = false;
            PipelineExecution pipelineExecution = $this$removeNotStartedSynthetics.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
            List list = pipelineExecution.getStages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution\n          .stages");
            element$iv$iv = list;
            boolean $i$f$filter2 = false;
            void bl2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                StageExecution it = (StageExecution)element$iv$iv2;
                boolean bl3 = false;
                StageExecution stageExecution = it;
                Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                if (!stageExecution.getRequisiteStageRefIds().contains(stage.getId())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                StageExecution it = (StageExecution)element$iv2;
                boolean bl4 = false;
                StageExecution stageExecution = it;
                Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"it");
                Collection collection = it.getRequisiteStageRefIds();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.requisiteStageRefIds");
                stageExecution.setRequisiteStageRefIds((Collection)CollectionsKt.minus((Iterable)collection, (Object)stage.getId()));
                this.getRepository().addStage(it);
            }
            this.removeNotStartedSynthetics(stage);
            this.getRepository().removeStage($this$removeNotStartedSynthetics.getExecution(), stage.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private ExecutionStatus determineStatus(StageExecution $this$determineStatus) {
        ExecutionStatus executionStatus;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        ExecutionStatus executionStatus2;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv = StageKt.syntheticStages((StageExecution)$this$determineStatus);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void p1;
            StageExecution stageExecution = (StageExecution)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            executionStatus2 = p1.getStatus();
            collection.add(executionStatus2);
        }
        List syntheticStatuses = (List)destination$iv$iv;
        List list = $this$determineStatus.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tasks");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void p1;
            TaskExecution bl = (TaskExecution)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            executionStatus2 = p1.getStatus();
            collection.add(executionStatus2);
        }
        List taskStatuses = (List)destination$iv$iv2;
        List planningStatus = CompleteStageHandlerKt.access$hasPlanningFailure($this$determineStatus) ? CollectionsKt.listOf((Object)StageKt.failureStatus$default((StageExecution)$this$determineStatus, null, (int)1, null)) : CollectionsKt.emptyList();
        List allStatuses = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)syntheticStatuses, (Iterable)taskStatuses), (Iterable)planningStatus);
        Iterable $this$map$iv3 = StageKt.afterStages((StageExecution)$this$determineStatus);
        boolean $i$f$map3 = false;
        item$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void p1;
            StageExecution stageExecution = (StageExecution)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl = false;
            executionStatus2 = p1.getStatus();
            collection.add(executionStatus2);
        }
        List afterStageStatuses = (List)destination$iv$iv3;
        if (allStatuses.isEmpty()) {
            executionStatus = ExecutionStatus.NOT_STARTED;
        } else if (allStatuses.contains(ExecutionStatus.TERMINAL)) {
            executionStatus = StageKt.failureStatus$default((StageExecution)$this$determineStatus, null, (int)1, null);
        } else if (allStatuses.contains(ExecutionStatus.STOPPED)) {
            executionStatus = ExecutionStatus.STOPPED;
        } else if (allStatuses.contains(ExecutionStatus.CANCELED)) {
            executionStatus = ExecutionStatus.CANCELED;
        } else if (allStatuses.contains(ExecutionStatus.FAILED_CONTINUE)) {
            executionStatus = ExecutionStatus.FAILED_CONTINUE;
        } else {
            boolean bl;
            block20: {
                Iterable $this$all$iv = allStatuses;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExecutionStatus it = (ExecutionStatus)element$iv;
                        boolean bl3 = false;
                        if (it == ExecutionStatus.SUCCEEDED || it == ExecutionStatus.SKIPPED) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                executionStatus = ExecutionStatus.SUCCEEDED;
            } else if (afterStageStatuses.contains(ExecutionStatus.NOT_STARTED)) {
                executionStatus = ExecutionStatus.RUNNING;
            } else {
                Logger logger = this.getLog();
                StringBuilder stringBuilder = new StringBuilder().append("Unhandled condition for stage ").append($this$determineStatus.getId()).append(" of ");
                PipelineExecution pipelineExecution = $this$determineStatus.getExecution();
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
                logger.error(stringBuilder.append(pipelineExecution.getId()).append(", marking as TERMINAL. syntheticStatuses=").append(syntheticStatuses).append(", taskStatuses=").append(taskStatuses).append(", planningStatus=").append(planningStatus).append(", afterStageStatuses=").append(afterStageStatuses).toString());
                executionStatus = ExecutionStatus.TERMINAL;
            }
        }
        return executionStatus;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    public CompleteStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageNavigator stageNavigator, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull Clock clock, @NotNull List<? extends ExceptionHandler> exceptionHandlers, @NotNull ContextParameterProcessor contextParameterProcessor, @NotNull Registry registry, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        this.queue = queue;
        this.repository = repository;
        this.stageNavigator = stageNavigator;
        this.publisher = publisher;
        this.clock = clock;
        this.exceptionHandlers = exceptionHandlers;
        this.contextParameterProcessor = contextParameterProcessor;
        this.registry = registry;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.messageType = CompleteStage.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        Intrinsics.checkNotNullParameter((Object)$this$builder, (String)"$this$builder");
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMergedContext, (String)"$this$withMergedContext");
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        Intrinsics.checkNotNullParameter((Object)$this$includeExpressionEvaluationSummary, (String)"$this$includeExpressionEvaluationSummary");
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFailedExpressions, (String)"$this$hasFailedExpressions");
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldFailOnFailedExpressionEvaluation, (String)"$this$shouldFailOnFailedExpressionEvaluation");
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withAuth, (String)"$this$withAuth");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    @Override
    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return AuthenticationAware.DefaultImpls.retrieveAuthenticatedUser(this, stage);
    }

    @Override
    @NotNull
    public StageExecution backtrackStages(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return AuthenticationAware.DefaultImpls.backtrackStages(this, stage);
    }

    @Override
    @NotNull
    public StageExecution solveAuthStages(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return AuthenticationAware.DefaultImpls.solveAuthStages(this, stage);
    }

    public static final /* synthetic */ ExecutionStatus access$determineStatus(CompleteStageHandler $this, StageExecution $this$access_u24determineStatus) {
        return $this.determineStatus($this$access_u24determineStatus);
    }

    public static final /* synthetic */ void access$planAfterStages(CompleteStageHandler $this, StageExecution $this$access_u24planAfterStages) {
        $this.planAfterStages($this$access_u24planAfterStages);
    }

    public static final /* synthetic */ boolean access$planOnFailureStages(CompleteStageHandler $this, StageExecution $this$access_u24planOnFailureStages) {
        return $this.planOnFailureStages($this$access_u24planOnFailureStages);
    }

    public static final /* synthetic */ Clock access$getClock$p(CompleteStageHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ List access$getExceptionHandlers$p(CompleteStageHandler $this) {
        return $this.exceptionHandlers;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(CompleteStageHandler $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ void access$trackResult(CompleteStageHandler $this, StageExecution stage) {
        $this.trackResult(stage);
    }
}

