/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.expressions.ExpressionEvaluationSummary;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.jackson.OrcaObjectMapper;
import com.netflix.spinnaker.orca.pipeline.ExpressionAwareStageDefinitionBuilder;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.expressions.PipelineExpressionEvaluator;
import com.netflix.spinnaker.orca.pipeline.model.StageContext;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\bf\u0018\u0000 \"2\u00020\u0001:\u0001\"J0\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0017H\u0016J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0017H\u0016J#\u0010\u001e\u001a\u00020\u0015*\u00020\u00152\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000fH\u0082\u0002J\f\u0010 \u001a\u00020\u001b*\u00020\u0017H\u0016J\f\u0010!\u001a\u00020\u0017*\u00020\u0017H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "mergedExceptionErrors", "", "exception", "errors", "", "", "processEntries", "Lcom/netflix/spinnaker/orca/pipeline/model/StageContext;", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "summary", "Lcom/netflix/spinnaker/kork/expressions/ExpressionEvaluationSummary;", "hasFailedExpressions", "", "includeExpressionEvaluationSummary", "", "plus", "map", "shouldFailOnFailedExpressionEvaluation", "withMergedContext", "Companion", "orca-queue"})
public interface ExpressionAware {
    @NotNull
    public static final Companion Companion = com.netflix.spinnaker.orca.q.handler.ExpressionAware$Companion.$$INSTANCE;

    @NotNull
    public ContextParameterProcessor getContextParameterProcessor();

    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory();

    @NotNull
    public Logger getLog();

    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution var1);

    public void includeExpressionEvaluationSummary(@NotNull StageExecution var1);

    public boolean hasFailedExpressions(@NotNull StageExecution var1);

    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Logger getLog(@NotNull ExpressionAware $this) {
            Logger logger = LoggerFactory.getLogger($this.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(javaClass)");
            return logger;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static StageExecution withMergedContext(@NotNull ExpressionAware $this, @NotNull StageExecution $this$withMergedContext) {
            Intrinsics.checkNotNullParameter((Object)$this$withMergedContext, (String)"$this$withMergedContext");
            ExpressionEvaluationSummary evalSummary = new ExpressionEvaluationSummary();
            StageContext processed = DefaultImpls.processEntries($this, $this$withMergedContext, evalSummary);
            PipelineExecution pipelineExecution = $this$withMergedContext.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"execution");
            PipelineExecution execution = pipelineExecution;
            StageExecution stage = $this$withMergedContext;
            $this$withMergedContext.setContext((Map)new Map<String, Object>($this, execution, processed, stage){
                private final /* synthetic */ StageContext $$delegate_0;
                final /* synthetic */ ExpressionAware this$0;
                final /* synthetic */ PipelineExecution $execution;
                final /* synthetic */ StageContext $processed;
                final /* synthetic */ StageExecution $stage;

                @Nullable
                public Object get(@NotNull String key) {
                    Object result;
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    if (this.$execution.getType() == ExecutionType.PIPELINE) {
                        if (Intrinsics.areEqual((Object)key, (Object)"trigger")) {
                            return this.$execution.getTrigger();
                        }
                        if (Intrinsics.areEqual((Object)key, (Object)"execution")) {
                            return this.$execution;
                        }
                    }
                    if ((result = this.$processed.get((Object)key)) instanceof String && ContextParameterProcessor.containsExpression((String)((String)result))) {
                        StageContext augmentedContext = this.this$0.getContextParameterProcessor().buildExecutionContext(this.$stage);
                        return this.this$0.getContextParameterProcessor().process(MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)result)), (Map)augmentedContext, true).get(key);
                    }
                    return result;
                }
                {
                    this.this$0 = this$0;
                    this.$execution = $captured_local_variable$1;
                    this.$processed = $captured_local_variable$2;
                    this.$stage = $captured_local_variable$3;
                    this.$$delegate_0 = $captured_local_variable$2;
                }

                @NotNull
                public Set<Map.Entry<String, Object>> getEntries() {
                    Set set = this.$$delegate_0.entrySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
                    return set;
                }

                @NotNull
                public Set<String> getKeys() {
                    Set set = this.$$delegate_0.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
                    return set;
                }

                public int getSize() {
                    return this.$$delegate_0.size();
                }

                @NotNull
                public Collection<Object> getValues() {
                    Collection collection = this.$$delegate_0.values();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
                    return collection;
                }

                public void clear() {
                    this.$$delegate_0.clear();
                }

                public boolean containsKey(@NotNull String key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return this.$$delegate_0.containsKey((Object)key);
                }

                public boolean containsValue(@Nullable Object value) {
                    return this.$$delegate_0.containsValue(value);
                }

                public boolean isEmpty() {
                    return this.$$delegate_0.isEmpty();
                }

                @Nullable
                public Object put(@NotNull String key, @Nullable Object value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return this.$$delegate_0.put((Object)key, value);
                }

                public void putAll(@NotNull Map<? extends String, ? extends Object> from) {
                    Intrinsics.checkNotNullParameter(from, (String)"from");
                    this.$$delegate_0.putAll(from);
                }

                @Nullable
                public Object remove(@NotNull String key) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    return this.$$delegate_0.remove((Object)key);
                }
            });
            if ($this.hasFailedExpressions($this$withMergedContext)) {
                try {
                    void $this$filterTo$iv$iv;
                    Object v = $this$withMergedContext.getContext().get("expressionEvaluationSummary");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, *>");
                    }
                    Map failedExpressions = TypeIntrinsics.asMutableMap(v);
                    Iterable $this$filter$iv = failedExpressions.keySet();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String expressionKey = (String)element$iv$iv;
                        boolean bl = false;
                        if (!(evalSummary.wasAttempted(expressionKey) && !evalSummary.hasFailed(expressionKey))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List keysToRemove = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                    Iterable $this$forEach$iv = keysToRemove;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String expressionKey = (String)element$iv;
                        boolean bl = false;
                        failedExpressions.remove(expressionKey);
                    }
                }
                catch (Exception e) {
                    $this.getLog().error("Failed to remove stale expression errors", (Throwable)e);
                }
            }
            return $this$withMergedContext;
        }

        /*
         * WARNING - void declaration
         */
        public static void includeExpressionEvaluationSummary(@NotNull ExpressionAware $this, @NotNull StageExecution $this$includeExpressionEvaluationSummary) {
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$includeExpressionEvaluationSummary, (String)"$this$includeExpressionEvaluationSummary");
                if (!$this.hasFailedExpressions($this$includeExpressionEvaluationSummary)) break block8;
                try {
                    void $this$flatMapTo$iv$iv;
                    Object v = $this$includeExpressionEvaluationSummary.getContext().get("expressionEvaluationSummary");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                    }
                    Map expressionEvaluationSummary = (Map)v;
                    Iterable $this$flatMap$iv = expressionEvaluationSummary.values();
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    Iterator iterator = $this$flatMapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void $this$mapTo$iv$iv;
                        Object element$iv$iv;
                        Object it = element$iv$iv = iterator.next();
                        boolean bl = false;
                        Object t = it;
                        if (t == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
                        }
                        Iterable $this$map$iv = (List)t;
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void it2;
                            Object item$iv$iv;
                            Object t2 = item$iv$iv = iterator2.next();
                            Collection collection = destination$iv$iv2;
                            boolean bl2 = false;
                            void v2 = it2;
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                            }
                            Map map = (Map)v2;
                            String string = "description";
                            boolean bl3 = false;
                            Object v3 = map.get(string);
                            if (v3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                            }
                            String string2 = (String)v3;
                            collection.add(string2);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    List evaluationErrors = (List)destination$iv$iv;
                    Map map = $this$includeExpressionEvaluationSummary.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.context");
                    map.put("exception", DefaultImpls.mergedExceptionErrors($this, (Map)$this$includeExpressionEvaluationSummary.getContext().get("exception"), evaluationErrors));
                }
                catch (Exception e) {
                    $this.getLog().error("failed to include expression evaluation error in context", (Throwable)e);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean hasFailedExpressions(@NotNull ExpressionAware $this, @NotNull StageExecution $this$hasFailedExpressions) {
            Intrinsics.checkNotNullParameter((Object)$this$hasFailedExpressions, (String)"$this$hasFailedExpressions");
            Map map = $this$hasFailedExpressions.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.context");
            Map map2 = map;
            String string = "expressionEvaluationSummary";
            boolean bl = false;
            Map map3 = map2;
            boolean bl2 = false;
            if (!map3.containsKey(string)) return false;
            Object v = $this$hasFailedExpressions.getContext().get("expressionEvaluationSummary");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            }
            if (((Map)v).size() <= 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean shouldFailOnFailedExpressionEvaluation(@NotNull ExpressionAware $this, @NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
            Intrinsics.checkNotNullParameter((Object)$this$shouldFailOnFailedExpressionEvaluation, (String)"$this$shouldFailOnFailedExpressionEvaluation");
            if (!$this.hasFailedExpressions($this$shouldFailOnFailedExpressionEvaluation)) return false;
            if (!$this$shouldFailOnFailedExpressionEvaluation.getContext().containsKey("failOnFailedExpressions")) return false;
            Object v = $this$shouldFailOnFailedExpressionEvaluation.getContext().get("failOnFailedExpressions");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            if ((Boolean)v == false) return false;
            return true;
        }

        private static Map<?, ?> mergedExceptionErrors(ExpressionAware $this, Map<?, ?> exception, List<String> errors) {
            Map map;
            if (exception == null) {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"details", (Object)ExceptionHandler.responseDetails((String)"Failed Expression Evaluation", errors)));
            } else {
                Map<?, ?> map2 = exception;
                Object object = "details";
                boolean bl = false;
                Map map3 = TypeIntrinsics.asMutableMap(map2.get(object));
                if (map3 == null) {
                    Pair[] pairArray = new Pair[1];
                    Pair[] pairArray2 = new Pair[1];
                    boolean bl2 = false;
                    pairArray2[0] = TuplesKt.to((Object)"errors", (Object)new ArrayList());
                    pairArray[0] = TuplesKt.to((Object)"details", (Object)MapsKt.mutableMapOf((Pair[])pairArray2));
                    map3 = MapsKt.mutableMapOf((Pair[])pairArray);
                }
                Map details = map3;
                object = details;
                String string = "errors";
                boolean bl3 = false;
                List list = (List)object.get(string);
                if (list == null) {
                    boolean bl4 = false;
                    list = new ArrayList();
                }
                List mergedErrors = CollectionsKt.plus((Collection)list, (Iterable)errors);
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"details", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"errors", (Object)mergedErrors))));
            }
            return map;
        }

        private static StageContext processEntries(ExpressionAware $this, StageExecution stage, ExpressionEvaluationSummary summary) {
            boolean shouldContinueProcessing = true;
            ContextParameterProcessor contextParameterProcessor = $this.getContextParameterProcessor();
            PipelineExecution pipelineExecution = stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
            PipelineExpressionEvaluator.SpelEvaluatorVersion spelVersion = contextParameterProcessor.getEffectiveSpelVersionToUse(pipelineExecution.getSpelEvaluator());
            if (PipelineExpressionEvaluator.SpelEvaluatorVersion.V4 == spelVersion) {
                StageDefinitionBuilder stageDefinitionBuilder = $this.getStageDefinitionBuilderFactory().builderFor(stage);
                Intrinsics.checkNotNullExpressionValue((Object)stageDefinitionBuilder, (String)"stageDefinitionBuilderFactory.builderFor(stage)");
                StageDefinitionBuilder stageBuilder = stageDefinitionBuilder;
                if (stageBuilder instanceof ExpressionAwareStageDefinitionBuilder) {
                    shouldContinueProcessing = ((ExpressionAwareStageDefinitionBuilder)stageBuilder).processExpressions(stage, $this.getContextParameterProcessor(), summary);
                }
            }
            if (shouldContinueProcessing) {
                return new StageContext(stage, $this.getContextParameterProcessor().process(stage.getContext(), (Map)$this.getContextParameterProcessor().buildExecutionContext(stage), true, summary));
            }
            return new StageContext(stage, stage.getContext());
        }

        private static StageContext plus(ExpressionAware $this, StageContext $this$plus, Map<String, ? extends Object> map) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
            StageContext stageContext = new StageContext($this$plus);
            boolean bl = false;
            boolean bl2 = false;
            StageContext $this$apply = stageContext;
            boolean bl3 = false;
            $this$apply.putAll(map);
            return stageContext;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "orca-queue"})
    public static final class Companion {
        @NotNull
        private static final ObjectMapper mapper;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            ObjectMapper objectMapper = OrcaObjectMapper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"OrcaObjectMapper.getInstance()");
            mapper = objectMapper;
        }
    }
}

