/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.PauseStage;
import com.netflix.spinnaker.orca.q.PauseTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/PauseTaskHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/PauseTask;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "handle", "", "message", "orca-queue"})
public class PauseTaskHandler
implements OrcaMessageHandler<PauseTask> {
    @NotNull
    private final Class<PauseTask> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;

    @NotNull
    public Class<PauseTask> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull PauseTask message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withTask(message, (Function2<? super StageExecution, ? super TaskExecution, Unit>)((Function2)new Function2<StageExecution, TaskExecution, Unit>(this, message){
            final /* synthetic */ PauseTaskHandler this$0;
            final /* synthetic */ PauseTask $message;

            public final void invoke(@NotNull StageExecution stage, @NotNull TaskExecution task) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                task.setStatus(ExecutionStatus.PAUSED);
                this.this$0.getRepository().storeStage(stage);
                this.this$0.getQueue().push((Message)new PauseStage(this.$message));
            }
            {
                this.this$0 = pauseTaskHandler;
                this.$message = pauseTask;
                super(2);
            }
        }));
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    public PauseTaskHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.queue = queue;
        this.repository = repository;
        this.messageType = PauseTask.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }
}

