/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.TaskImplementationResolver;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.StageStarted;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.model.OptionalStageSupport;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.CompleteStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.SkipStage;
import com.netflix.spinnaker.orca.q.StageDefinitionBuildersKt;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.StartTask;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.orca.q.handler.StartStageHandler;
import com.netflix.spinnaker.orca.q.handler.StartStageHandler$handle$1$1$$special$;
import com.netflix.spinnaker.q.AttemptsAttribute;
import com.netflix.spinnaker.q.Attribute;
import com.netflix.spinnaker.q.MaxAttemptsAttribute;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005Bq\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0001\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0002H\u0016J\u0010\u00104\u001a\u0002022\u0006\u00105\u001a\u000206H\u0012J\f\u00107\u001a\u000208*\u000206H\u0012J\f\u00109\u001a\u000202*\u000206H\u0012J\f\u0010:\u001a\u000208*\u000206H\u0012J\f\u0010;\u001a\u000202*\u000206H\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\n ,*\u0004\u0018\u00010+0+X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/StartStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/StartStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "exceptionHandlers", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "clock", "Ljava/time/Clock;", "registry", "Lcom/netflix/spectator/api/Registry;", "retryDelayMs", "", "taskImplementationResolver", "Lcom/netflix/spinnaker/orca/TaskImplementationResolver;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lorg/springframework/context/ApplicationEventPublisher;Ljava/util/List;Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;JLcom/netflix/spinnaker/orca/TaskImplementationResolver;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "retryDelay", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "handle", "", "message", "trackResult", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "isAfterStartTimeExpiry", "", "plan", "shouldSkip", "start", "orca-queue"})
public class StartStageHandler
implements OrcaMessageHandler<StartStage>,
StageBuilderAware,
ExpressionAware,
AuthenticationAware {
    private final Duration retryDelay;
    @NotNull
    private final Class<StartStage> messageType;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageNavigator stageNavigator;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    private final ApplicationEventPublisher publisher;
    private final List<ExceptionHandler> exceptionHandlers;
    private final ObjectMapper objectMapper;
    private final Clock clock;
    private final Registry registry;
    private final TaskImplementationResolver taskImplementationResolver;

    public void handle(@NotNull StartStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, message){
            final /* synthetic */ StartStageHandler this$0;
            final /* synthetic */ StartStage $message;

            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                try {
                    this.this$0.withAuth(stage, (Function0<Unit>)((Function0)new Function0<Unit>(this, stage){
                        final /* synthetic */ handle.1 this$0;
                        final /* synthetic */ StageExecution $stage;

                        public final void invoke() {
                            block16: {
                                if (StageKt.anyUpstreamStagesFailed((StageExecution)this.$stage)) {
                                    this.this$0.this$0.getLog().warn("Tried to start stage " + this.$stage.getId() + " but something upstream had failed (executionId: " + this.this$0.$message.getExecutionId() + ')');
                                    this.this$0.this$0.getQueue().push((Message)new CompleteExecution(this.this$0.$message));
                                } else if (StageKt.allUpstreamStagesComplete((StageExecution)this.$stage)) {
                                    if (this.$stage.getStatus() != ExecutionStatus.NOT_STARTED) {
                                        this.this$0.this$0.getLog().warn("Ignoring " + this.this$0.$message + " as stage is already " + this.$stage.getStatus());
                                    } else if (StartStageHandler.access$shouldSkip(this.this$0.this$0, this.$stage)) {
                                        this.this$0.this$0.getQueue().push((Message)new SkipStage(this.this$0.$message));
                                    } else if (StartStageHandler.access$isAfterStartTimeExpiry(this.this$0.this$0, this.$stage)) {
                                        this.this$0.this$0.getLog().warn("Stage is being skipped because its start time is after TTL (stageId: " + this.$stage.getId() + ", executionId: " + this.this$0.$message.getExecutionId() + ')');
                                        this.this$0.this$0.getQueue().push((Message)new SkipStage(this.$stage));
                                    } else {
                                        try {
                                            this.$stage.setStartTime(Long.valueOf(StartStageHandler.access$getClock$p(this.this$0.this$0).millis()));
                                            this.this$0.this$0.getRepository().storeStage(this.$stage);
                                            StartStageHandler.access$plan(this.this$0.this$0, this.$stage);
                                            this.$stage.setStatus(ExecutionStatus.RUNNING);
                                            this.this$0.this$0.getRepository().storeStage(this.$stage);
                                            StartStageHandler.access$start(this.this$0.this$0, this.$stage);
                                            StartStageHandler.access$getPublisher$p(this.this$0.this$0).publishEvent((ApplicationEvent)new StageStarted((Object)this.this$0.this$0, this.$stage));
                                            StartStageHandler.access$trackResult(this.this$0.this$0, this.$stage);
                                        }
                                        catch (Exception e) {
                                            ExceptionHandler.Response exceptionDetails;
                                            ExceptionHandler.Response response = exceptionDetails = this.this$0.this$0.shouldRetry(StartStageHandler.access$getExceptionHandlers$p(this.this$0.this$0), e, this.$stage.getName());
                                            if (response != null) {
                                                if (response.getShouldRetry()) {
                                                    Object v1;
                                                    Message this_$iv;
                                                    block15: {
                                                        this_$iv = this.this$0.$message;
                                                        boolean $i$f$getAttribute = false;
                                                        Iterable iterable = this_$iv.getAttributes();
                                                        boolean bl = false;
                                                        Iterable iterable2 = iterable;
                                                        boolean bl2 = false;
                                                        for (T t : iterable2) {
                                                            Attribute it$iv = (Attribute)t;
                                                            boolean bl3 = false;
                                                            if (!(it$iv instanceof AttemptsAttribute)) continue;
                                                            v1 = t;
                                                            break block15;
                                                        }
                                                        v1 = null;
                                                    }
                                                    AttemptsAttribute attemptsAttribute = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v1));
                                                    int attempts = attemptsAttribute != null ? attemptsAttribute.getAttempts() : 0;
                                                    this.this$0.this$0.getLog().warn("Error planning " + this.$stage.getType() + " stage for " + this.this$0.$message.getExecutionType() + '[' + this.this$0.$message.getExecutionId() + "] (attempts: " + attempts + ')');
                                                    this_$iv = this.this$0.$message;
                                                    Attribute attribute$iv = (Attribute)new MaxAttemptsAttribute(40);
                                                    boolean $i$f$setAttribute = false;
                                                    this_$iv.getAttributes().removeIf(handle$1$1$$special$$inlined$setAttribute$1.INSTANCE);
                                                    this_$iv.getAttributes().add(attribute$iv);
                                                    Queue queue = this.this$0.this$0.getQueue();
                                                    Message message = this.this$0.$message;
                                                    Duration duration = StartStageHandler.access$getRetryDelay$p(this.this$0.this$0);
                                                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"retryDelay");
                                                    queue.push(message, (TemporalAmount)duration);
                                                    break block16;
                                                }
                                            }
                                            this.this$0.this$0.getLog().error("Error running " + this.$stage.getType() + '[' + this.$stage.getId() + "] stage for " + this.this$0.$message.getExecutionType() + '[' + this.this$0.$message.getExecutionId() + ']', (Throwable)e);
                                            StageExecution stageExecution = this.$stage;
                                            boolean bl = false;
                                            boolean bl4 = false;
                                            StageExecution $this$apply = stageExecution;
                                            boolean bl5 = false;
                                            Map map = $this$apply.getContext();
                                            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context");
                                            map.put("exception", exceptionDetails);
                                            Map map2 = $this$apply.getContext();
                                            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"context");
                                            map2.put("beforeStagePlanningFailed", true);
                                            this.this$0.this$0.getRepository().storeStage(this.$stage);
                                            this.this$0.this$0.getQueue().push((Message)new CompleteStage(this.this$0.$message));
                                        }
                                    }
                                } else {
                                    this.this$0.this$0.getLog().info("Re-queuing " + this.this$0.$message + " as upstream stages are not yet complete");
                                    Queue queue = this.this$0.this$0.getQueue();
                                    Message message = this.this$0.$message;
                                    Duration duration = StartStageHandler.access$getRetryDelay$p(this.this$0.this$0);
                                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"retryDelay");
                                    queue.push(message, (TemporalAmount)duration);
                                }
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$stage = stageExecution;
                            super(0);
                        }
                    }));
                }
                catch (Exception e) {
                    this.this$0.withStage(this.$message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, e){
                        final /* synthetic */ handle.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void invoke(@NotNull StageExecution stage) {
                            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                            this.this$0.this$0.getLog().error("Error running " + stage.getType() + '[' + stage.getId() + "] stage for " + this.this$0.$message.getExecutionType() + '[' + this.this$0.$message.getExecutionId() + ']', (Throwable)this.$e);
                            StageExecution stageExecution = stage;
                            boolean bl = false;
                            boolean bl2 = false;
                            StageExecution $this$apply = stageExecution;
                            boolean bl3 = false;
                            ExceptionHandler.Response exceptionDetails = this.this$0.this$0.shouldRetry(StartStageHandler.access$getExceptionHandlers$p(this.this$0.this$0), this.$e, stage.getName());
                            Map map = $this$apply.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context");
                            map.put("exception", exceptionDetails);
                            Map map2 = $this$apply.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"context");
                            map2.put("beforeStagePlanningFailed", true);
                            this.this$0.this$0.getRepository().storeStage(stage);
                            this.this$0.this$0.getQueue().push((Message)new CompleteStage(this.this$0.$message));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                            super(1);
                        }
                    }));
                }
            }
            {
                this.this$0 = startStageHandler;
                this.$message = startStage;
                super(1);
            }
        }));
    }

    private void trackResult(StageExecution stage) {
        Map map;
        block10: {
            Id id;
            block9: {
                Object it;
                boolean bl;
                boolean bl2;
                Object object;
                Object object2;
                boolean bl3;
                boolean bl4;
                Object object3;
                block8: {
                    block7: {
                        if (stage.getParentStageId() != null) {
                            return;
                        }
                        Id id2 = this.registry.createId("stage.invocations").withTag("type", stage.getType());
                        PipelineExecution pipelineExecution = stage.getExecution();
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                        object3 = id2.withTag("application", pipelineExecution.getApplication());
                        bl4 = false;
                        bl3 = false;
                        id = object3;
                        boolean bl5 = false;
                        object2 = stage.getContext().get("cloudProvider");
                        if (object2 == null) break block7;
                        object = object2;
                        bl2 = false;
                        bl = false;
                        it = object;
                        boolean bl6 = false;
                        object2 = id.withTag("cloudProvider", it.toString());
                        if (object2 != null) break block8;
                    }
                    object2 = id;
                }
                object3 = object2;
                bl4 = false;
                bl3 = false;
                id = object3;
                boolean bl7 = false;
                map = stage.getAdditionalMetricTags();
                if (map == null) break block9;
                object = map;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl8 = false;
                map = id.withTags(stage.getAdditionalMetricTags());
                if (map != null) break block10;
            }
            map = id;
        }
        Map id = map;
        this.registry.counter((Id)id).increment();
    }

    @NotNull
    public Class<StartStage> getMessageType() {
        return this.messageType;
    }

    private void plan(StageExecution $this$plan) {
        StageDefinitionBuilder stageDefinitionBuilder = this.builder($this$plan);
        boolean bl = false;
        boolean bl2 = false;
        StageDefinitionBuilder builder = stageDefinitionBuilder;
        boolean bl3 = false;
        StageExecution mergedStage = $this$plan.getParentStageId() == null ? this.withMergedContext($this$plan) : $this$plan;
        StageDefinitionBuildersKt.addContextFlags(builder, mergedStage);
        StageDefinitionBuildersKt.buildTasks(builder, mergedStage, this.taskImplementationResolver);
        StageDefinitionBuildersKt.buildBeforeStages(builder, mergedStage, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, $this$plan){
            final /* synthetic */ StartStageHandler this$0;
            final /* synthetic */ StageExecution $this_plan$inlined;
            {
                this.this$0 = startStageHandler;
                this.$this_plan$inlined = stageExecution;
                super(1);
            }

            public final void invoke(@NotNull StageExecution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getRepository().addStage(this.this$0.withMergedContext(it));
            }
        }));
    }

    private void start(StageExecution $this$start) {
        List beforeStages = StageKt.firstBeforeStages((StageExecution)$this$start);
        if (beforeStages.isEmpty()) {
            TaskExecution task = StageKt.firstTask((StageExecution)$this$start);
            if (task == null) {
                List afterStages = StageKt.firstAfterStages((StageExecution)$this$start);
                if (afterStages.isEmpty()) {
                    this.getQueue().push((Message)new CompleteStage($this$start));
                } else {
                    Iterable $this$forEach$iv = afterStages;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        StageExecution it = (StageExecution)element$iv;
                        boolean bl = false;
                        this.getQueue().push((Message)new StartStage(it));
                    }
                }
            } else {
                Queue queue = this.getQueue();
                String string = task.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.id");
                queue.push((Message)new StartTask($this$start, string));
            }
        } else {
            Iterable $this$forEach$iv = beforeStages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StageExecution it = (StageExecution)element$iv;
                boolean bl = false;
                this.getQueue().push((Message)new StartStage(it));
            }
        }
    }

    private boolean shouldSkip(StageExecution $this$shouldSkip) {
        PipelineExecution pipelineExecution = $this$shouldSkip.getExecution();
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"this.execution");
        if (pipelineExecution.getType() != ExecutionType.PIPELINE) {
            return false;
        }
        Map map = $this$shouldSkip.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.context");
        Map clonedContext = MapsKt.toMutableMap((Map)map);
        StageExecutionImpl stageExecutionImpl = new StageExecutionImpl($this$shouldSkip.getExecution(), $this$shouldSkip.getType(), clonedContext);
        boolean bl = false;
        boolean bl2 = false;
        StageExecutionImpl it = stageExecutionImpl;
        boolean bl3 = false;
        it.setRefId($this$shouldSkip.getRefId());
        it.setRequisiteStageRefIds($this$shouldSkip.getRequisiteStageRefIds());
        it.setSyntheticStageOwner($this$shouldSkip.getSyntheticStageOwner());
        it.setParentStageId($this$shouldSkip.getParentStageId());
        StageExecutionImpl clonedStage = stageExecutionImpl;
        if (clonedStage.getContext().containsKey("expressionEvaluationSummary")) {
            $this$shouldSkip.getContext().put("expressionEvaluationSummary", clonedStage.getContext().get("expressionEvaluationSummary"));
        }
        return OptionalStageSupport.isOptional((StageExecution)this.withMergedContext((StageExecution)clonedStage), (ContextParameterProcessor)this.getContextParameterProcessor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAfterStartTimeExpiry(StageExecution $this$isAfterStartTimeExpiry) {
        Long l = $this$isAfterStartTimeExpiry.getStartTimeExpiry();
        Comparable<Long> comparable = l;
        if (l == null) return false;
        Long l2 = comparable;
        boolean bl = false;
        boolean bl2 = false;
        Long it = l2;
        boolean bl3 = false;
        Long l3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"it");
        Instant instant = Instant.ofEpochMilli(l3);
        comparable = instant;
        if (instant == null) return false;
        boolean bl4 = ((Instant)comparable).isBefore(this.clock.instant());
        return bl4;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    public StartStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageNavigator stageNavigator, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull ContextParameterProcessor contextParameterProcessor, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull List<? extends ExceptionHandler> exceptionHandlers, @Qualifier(value="mapper") @NotNull ObjectMapper objectMapper, @NotNull Clock clock, @NotNull Registry registry, @Value(value="${queue.retry.delay.ms:15000}") long retryDelayMs, @NotNull TaskImplementationResolver taskImplementationResolver) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)taskImplementationResolver, (String)"taskImplementationResolver");
        this.queue = queue;
        this.repository = repository;
        this.stageNavigator = stageNavigator;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.contextParameterProcessor = contextParameterProcessor;
        this.publisher = publisher;
        this.exceptionHandlers = exceptionHandlers;
        this.objectMapper = objectMapper;
        this.clock = clock;
        this.registry = registry;
        this.taskImplementationResolver = taskImplementationResolver;
        this.retryDelay = Duration.ofMillis(retryDelayMs);
        this.messageType = StartStage.class;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        Intrinsics.checkNotNullParameter($this$shouldRetry, (String)"$this$shouldRetry");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withTask, (String)"$this$withTask");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withStage, (String)"$this$withStage");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withExecution, (String)"$this$withExecution");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        Intrinsics.checkNotNullParameter((Object)$this$startNext, (String)"$this$startNext");
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldQueue, (String)"$this$shouldQueue");
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        Intrinsics.checkNotNullParameter((Object)$this$builder, (String)"$this$builder");
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withMergedContext, (String)"$this$withMergedContext");
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        Intrinsics.checkNotNullParameter((Object)$this$includeExpressionEvaluationSummary, (String)"$this$includeExpressionEvaluationSummary");
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFailedExpressions, (String)"$this$hasFailedExpressions");
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldFailOnFailedExpressionEvaluation, (String)"$this$shouldFailOnFailedExpressionEvaluation");
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withAuth, (String)"$this$withAuth");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    @Override
    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return AuthenticationAware.DefaultImpls.retrieveAuthenticatedUser(this, stage);
    }

    @Override
    @NotNull
    public StageExecution backtrackStages(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return AuthenticationAware.DefaultImpls.backtrackStages(this, stage);
    }

    @Override
    @NotNull
    public StageExecution solveAuthStages(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return AuthenticationAware.DefaultImpls.solveAuthStages(this, stage);
    }

    public static final /* synthetic */ boolean access$shouldSkip(StartStageHandler $this, StageExecution $this$access_u24shouldSkip) {
        return $this.shouldSkip($this$access_u24shouldSkip);
    }

    public static final /* synthetic */ boolean access$isAfterStartTimeExpiry(StartStageHandler $this, StageExecution $this$access_u24isAfterStartTimeExpiry) {
        return $this.isAfterStartTimeExpiry($this$access_u24isAfterStartTimeExpiry);
    }

    public static final /* synthetic */ Clock access$getClock$p(StartStageHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ void access$plan(StartStageHandler $this, StageExecution $this$access_u24plan) {
        $this.plan($this$access_u24plan);
    }

    public static final /* synthetic */ void access$start(StartStageHandler $this, StageExecution $this$access_u24start) {
        $this.start($this$access_u24start);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(StartStageHandler $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ void access$trackResult(StartStageHandler $this, StageExecution stage) {
        $this.trackResult(stage);
    }

    public static final /* synthetic */ List access$getExceptionHandlers$p(StartStageHandler $this) {
        return $this.exceptionHandlers;
    }

    public static final /* synthetic */ Duration access$getRetryDelay$p(StartStageHandler $this) {
        return $this.retryDelay;
    }
}

