/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.q.NoopQueue;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ComponentScan(basePackages={"com.netflix.spinnaker.orca.q", "com.netflix.spinnaker.orca.q.handler"})
@EnableScheduling
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/config/OrcaQueueConfiguration;", "", "()V", "queue", "Lcom/netflix/spinnaker/q/Queue;", "systemClock", "Ljava/time/Clock;", "orca-queue"})
public class OrcaQueueConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Clock.class})
    @NotNull
    public Clock systemClock() {
        Clock clock = Clock.systemDefaultZone();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemDefaultZone()");
        return clock;
    }

    @Bean
    @ConditionalOnMissingBean(value={Queue.class})
    @NotNull
    public Queue queue() {
        return (Queue)new NoopQueue();
    }
}

