/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="cancelExecution")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bB1\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0018\u001a\u00020\rH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J?\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00062\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u000f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/netflix/spinnaker/orca/q/CancelExecution;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "source", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "user", "", "reason", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;Ljava/lang/String;Ljava/lang/String;)V", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;)V", "(Lcom/netflix/spinnaker/orca/q/ExecutionLevel;)V", "(Lcom/netflix/spinnaker/orca/q/ExecutionLevel;Ljava/lang/String;Ljava/lang/String;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getReason", "getUser", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class CancelExecution
extends Message
implements ExecutionLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @Nullable
    private final String user;
    @Nullable
    private final String reason;

    public CancelExecution(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @Nullable String user, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.user = user;
        this.reason = reason;
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getReason() {
        return this.reason;
    }

    public CancelExecution(@NotNull PipelineExecution source, @Nullable String user, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.type");
        ExecutionType executionType = object;
        object = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.id");
        Object object2 = object;
        object = source.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.application");
        this(executionType, (String)object2, (String)object, user, reason);
    }

    public CancelExecution(@NotNull PipelineExecution source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.type");
        ExecutionType executionType = object;
        object = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.id");
        Object object2 = object;
        object = source.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.application");
        this(executionType, (String)object2, (String)object, null, null);
    }

    public CancelExecution(@NotNull ExecutionLevel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), null, null);
    }

    public CancelExecution(@NotNull ExecutionLevel source, @Nullable String user, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), user, reason);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @Nullable
    public final String component4() {
        return this.user;
    }

    @Nullable
    public final String component5() {
        return this.reason;
    }

    @NotNull
    public final CancelExecution copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @Nullable String user, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new CancelExecution(executionType, executionId, application, user, reason);
    }

    public static /* synthetic */ CancelExecution copy$default(CancelExecution cancelExecution, ExecutionType executionType, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = cancelExecution.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = cancelExecution.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = cancelExecution.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = cancelExecution.user;
        }
        if ((n & 0x10) != 0) {
            string4 = cancelExecution.reason;
        }
        return cancelExecution.copy(executionType, string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "CancelExecution(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", user=" + this.user + ", reason=" + this.reason + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CancelExecution)) {
            return false;
        }
        CancelExecution cancelExecution = (CancelExecution)other;
        if (this.getExecutionType() != cancelExecution.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)cancelExecution.getExecutionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getApplication(), (Object)cancelExecution.getApplication())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)cancelExecution.user)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.reason, (Object)cancelExecution.reason);
    }
}

