/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="cancelStage")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u000bH\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u000bH\u00d6\u0001R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\r\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/netflix/spinnaker/orca/q/CancelStage;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "source", "(Lcom/netflix/spinnaker/orca/q/StageLevel;)V", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "", "application", "stageId", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStageId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class CancelStage
extends Message
implements StageLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @NotNull
    private final String stageId;

    public CancelStage(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.stageId = stageId;
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public String getStageId() {
        return this.stageId;
    }

    public CancelStage(@NotNull StageLevel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), source.getStageId());
    }

    public CancelStage(@NotNull StageExecution stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        Object object = stage.getExecution().getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.execution.type");
        ExecutionType executionType = object;
        object = stage.getExecution().getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.execution.id");
        Object object2 = object;
        object = stage.getExecution().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.execution.application");
        Object object3 = object;
        object = stage.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.id");
        this(executionType, (String)object2, (String)object3, (String)object);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final String component4() {
        return this.getStageId();
    }

    @NotNull
    public final CancelStage copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        return new CancelStage(executionType, executionId, application, stageId);
    }

    public static /* synthetic */ CancelStage copy$default(CancelStage cancelStage, ExecutionType executionType, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = cancelStage.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = cancelStage.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = cancelStage.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = cancelStage.getStageId();
        }
        return cancelStage.copy(executionType, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "CancelStage(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", stageId=" + this.getStageId() + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        result = result * 31 + this.getStageId().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CancelStage)) {
            return false;
        }
        CancelStage cancelStage = (CancelStage)other;
        if (this.getExecutionType() != cancelStage.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)cancelStage.getExecutionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getApplication(), (Object)cancelStage.getApplication())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getStageId(), (Object)cancelStage.getStageId());
    }
}

