/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.AuthenticatedStage;
import com.netflix.spinnaker.orca.ExecutionContext;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "retrieveAuthenticatedUser", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution$AuthenticationDetails;", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "withAuth", "", "block", "Lkotlin/Function0;", "orca-queue"})
public interface AuthenticationAware {
    @NotNull
    public StageNavigator getStageNavigator();

    public void withAuth(@NotNull StageExecution var1, @NotNull Function0<Unit> var2);

    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void withAuth(@NotNull AuthenticationAware this_, @NotNull StageExecution receiver, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            PipelineExecution.AuthenticationDetails authenticationDetails = this_.retrieveAuthenticatedUser(receiver);
            PipelineExecution.AuthenticationDetails currentUser = authenticationDetails == null ? receiver.getExecution().getAuthentication() : authenticationDetails;
            String string = receiver.getContext().getOrDefault("account", "unknown");
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String account = string;
            Function0<Unit> function0 = receiver.getContext().getOrDefault("cloudProvider", "unknown");
            if (function0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Function0<Unit> cloudProvider = function0;
            try {
                String string2 = receiver.getExecution().getApplication();
                function0 = currentUser;
                String string3 = function0 == null ? null : function0.getUser();
                function0 = receiver.getExecution().getType().name();
                boolean bl = false;
                Function0<Unit> function02 = function0;
                if (function02 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = function02.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                String string5 = receiver.getExecution().getId();
                String string6 = receiver.getId();
                String string7 = receiver.getExecution().getOrigin();
                function0 = account;
                bl = false;
                String string8 = function0.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
                function0 = cloudProvider;
                bl = false;
                String string9 = function0.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                ExecutionContext.set((ExecutionContext)new ExecutionContext(string2, string3, string4, string5, string6, string7, string8, string9, receiver.getStartTime()));
                function0 = currentUser;
                if (StringUtils.isNotBlank((CharSequence)(function0 == null ? null : function0.getUser()))) {
                    function0 = block;
                    AuthenticatedRequest.runAs((String)currentUser.getUser(), (Collection)currentUser.getAllowedAccounts(), (boolean)false, () -> DefaultImpls.withAuth$lambda-0(function0)).call();
                } else {
                    function0 = block;
                    AuthenticatedRequest.propagate(() -> DefaultImpls.withAuth$lambda-1(function0), (boolean)false).call();
                }
            }
            finally {
                ExecutionContext.clear();
            }
        }

        @Nullable
        public static PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull AuthenticationAware this_, @NotNull StageExecution stage) {
            Object v1;
            List list;
            block5: {
                Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                list = this_.getStageNavigator().ancestors(stage);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stageNavigator\n      .ancestors(stage)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    StageNavigator.Result it = (StageNavigator.Result)element$iv;
                    boolean bl = false;
                    boolean bl2 = it.getStageBuilder() instanceof AuthenticatedStage && it.getStage().isManualJudgmentType() && !it.getStage().getStatus().isSkipped() && it.getStage().withPropagateAuthentication();
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            StageNavigator.Result result = v1;
            if (result != null) {
                PipelineExecution.AuthenticationDetails authenticationDetails;
                list = result;
                boolean bl = false;
                boolean bl3 = false;
                List it = list;
                boolean bl4 = false;
                StageExecution authStage = it.getStage();
                if (authStage != null) {
                    StageDefinitionBuilder stageDefinitionBuilder = it.getStageBuilder();
                    if (stageDefinitionBuilder == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.orca.AuthenticatedStage");
                    }
                    authenticationDetails = ((AuthenticatedStage)stageDefinitionBuilder).authenticatedUser(authStage).orElse(null);
                } else {
                    authenticationDetails = null;
                }
                return authenticationDetails;
            }
            return null;
        }

        private static final Unit withAuth$lambda-0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Unit)$tmp0.invoke();
        }

        private static final Unit withAuth$lambda-1(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Unit)$tmp0.invoke();
        }
    }
}

