/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.ExecutionComplete;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CancelStage;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.AttemptsAttribute;
import com.netflix.spinnaker.q.Attribute;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0002H\u0016J(\u0010&\u001a\u00020$*\u00020\u00022\u0006\u0010'\u001a\u00020 2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020$0)H\u0002J\u0012\u0010+\u001a\u00020,*\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\f\u0010-\u001a\u00020,*\u00020 H\u0002R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u0010*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020 8RX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006."}, d2={"Lcom/netflix/spinnaker/orca/q/handler/CompleteExecutionHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/CompleteExecution;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "registry", "Lcom/netflix/spectator/api/Registry;", "retryDelayMs", "", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lorg/springframework/context/ApplicationEventPublisher;Lcom/netflix/spectator/api/Registry;J)V", "completedId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "retryDelay", "Ljava/time/Duration;", "topLevelStages", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "getTopLevelStages", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;)Ljava/util/List;", "handle", "", "message", "determineFinalStatus", "execution", "block", "Lkotlin/Function1;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "otherBranchesIncomplete", "", "shouldOverrideSuccess", "orca-queue"})
public class CompleteExecutionHandler
implements OrcaMessageHandler<CompleteExecution> {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final ApplicationEventPublisher publisher;
    @NotNull
    private final Registry registry;
    private final Logger log;
    private final Duration retryDelay;
    private final Id completedId;
    @NotNull
    private final Class<CompleteExecution> messageType;

    public CompleteExecutionHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull Registry registry, @Value(value="${queue.retry.delay.ms:30000}") long retryDelayMs) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.queue = queue;
        this.repository = repository;
        this.publisher = publisher;
        this.registry = registry;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.retryDelay = Duration.ofMillis(retryDelayMs);
        this.completedId = this.registry.createId("executions.completed");
        this.messageType = CompleteExecution.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    public void handle(@NotNull CompleteExecution message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withExecution(message, (Function1<? super PipelineExecution, Unit>)((Function1)new Function1<PipelineExecution, Unit>(this, message){
            final /* synthetic */ CompleteExecutionHandler this$0;
            final /* synthetic */ CompleteExecution $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull PipelineExecution execution) {
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                if (execution.getStatus().isComplete()) {
                    CompleteExecutionHandler.access$getLog$p(this.this$0).info("Execution " + execution.getId() + " already completed with " + execution.getStatus() + " status");
                } else {
                    CompleteExecutionHandler.access$determineFinalStatus(this.this$0, this.$message, execution, (Function1)new Function1<ExecutionStatus, Unit>(execution, this.this$0){
                        final /* synthetic */ PipelineExecution $execution;
                        final /* synthetic */ CompleteExecutionHandler this$0;
                        {
                            this.$execution = $execution;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull ExecutionStatus status) {
                            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                            this.$execution.updateStatus(status);
                            this.this$0.getRepository().updateStatus(this.$execution);
                            CompleteExecutionHandler.access$getPublisher$p(this.this$0).publishEvent((ApplicationEvent)new ExecutionComplete((Object)this.this$0, this.$execution));
                            String[] stringArray = new String[8];
                            stringArray[0] = "status";
                            stringArray[1] = status.name();
                            stringArray[2] = "executionType";
                            stringArray[3] = this.$execution.getType().name();
                            stringArray[4] = "application";
                            stringArray[5] = this.$execution.getApplication();
                            stringArray[6] = "origin";
                            String string = this.$execution.getOrigin();
                            stringArray[7] = string == null ? "unknown" : string;
                            CompleteExecutionHandler.access$getRegistry$p(this.this$0).counter(CompleteExecutionHandler.access$getCompletedId$p(this.this$0).withTags(stringArray)).increment();
                            if (status != ExecutionStatus.SUCCEEDED) {
                                void $this$forEach$iv;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv = CompleteExecutionHandler.access$getTopLevelStages(this.this$0, this.$execution);
                                boolean $i$f$filter = false;
                                Iterable iterable = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    StageExecution it = (StageExecution)element$iv$iv;
                                    boolean bl = false;
                                    if (!(it.getStatus() == ExecutionStatus.RUNNING)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                CompleteExecutionHandler completeExecutionHandler = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    StageExecution it = (StageExecution)element$iv;
                                    boolean bl = false;
                                    completeExecutionHandler.getQueue().push((Message)new CancelStage(it));
                                }
                            }
                        }
                    });
                }
                CompleteExecutionHandler.access$getLog$p(this.this$0).debug("Execution " + execution.getId() + " is with " + execution.getStatus() + " status and  Disabled concurrent executions is " + execution.isLimitConcurrent());
                if (execution.getStatus() != ExecutionStatus.RUNNING) {
                    String string = execution.getPipelineConfigId();
                    if (string != null) {
                        String string2 = string;
                        CompleteExecutionHandler completeExecutionHandler = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        completeExecutionHandler.getQueue().push((Message)new StartWaitingExecutions(it, !execution.isKeepWaitingPipelines()));
                    }
                } else {
                    CompleteExecutionHandler.access$getLog$p(this.this$0).debug("Not starting waiting executions as execution " + execution.getId() + " is currently RUNNING.");
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void determineFinalStatus(CompleteExecution $this$determineFinalStatus, PipelineExecution execution, Function1<? super ExecutionStatus, Unit> block) {
        Object object;
        boolean bl;
        List<StageExecution> stages;
        block22: {
            Iterator $this$mapTo$iv$iv;
            List<StageExecution> list = this.getTopLevelStages(execution);
            boolean bl2 = false;
            boolean bl3 = false;
            stages = list;
            boolean bl4 = false;
            Iterable $this$map$iv = stages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                StageExecution stageExecution = (StageExecution)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                ExecutionStatus executionStatus = it.getStatus();
                collection.add(executionStatus);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ExecutionStatus it = (ExecutionStatus)element$iv;
                    boolean bl6 = false;
                    object = new ExecutionStatus[]{ExecutionStatus.SUCCEEDED, ExecutionStatus.SKIPPED, ExecutionStatus.FAILED_CONTINUE};
                    if (SetsKt.setOf((Object[])object).contains(it)) continue;
                    bl = false;
                    break block22;
                }
                bl = true;
            }
        }
        if (bl) {
            block.invoke((Object)ExecutionStatus.SUCCEEDED);
        } else {
            boolean bl7;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block23: {
                $this$any$iv = stages;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StageExecution it = (StageExecution)element$iv;
                        boolean bl8 = false;
                        if (!(it.getStatus() == ExecutionStatus.TERMINAL)) continue;
                        bl7 = true;
                        break block23;
                    }
                    bl7 = false;
                }
            }
            if (bl7) {
                block.invoke((Object)ExecutionStatus.TERMINAL);
            } else {
                boolean bl9;
                block24: {
                    $this$any$iv = stages;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl9 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            StageExecution it = (StageExecution)element$iv;
                            boolean bl10 = false;
                            if (!(it.getStatus() == ExecutionStatus.CANCELED)) continue;
                            bl9 = true;
                            break block24;
                        }
                        bl9 = false;
                    }
                }
                if (bl9) {
                    block.invoke((Object)ExecutionStatus.CANCELED);
                } else {
                    boolean bl11;
                    block25: {
                        $this$any$iv = stages;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl11 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                StageExecution it = (StageExecution)element$iv;
                                boolean bl12 = false;
                                if (!(it.getStatus() == ExecutionStatus.STOPPED)) continue;
                                bl11 = true;
                                break block25;
                            }
                            bl11 = false;
                        }
                    }
                    if (bl11 && !this.otherBranchesIncomplete(stages)) {
                        block.invoke((Object)(this.shouldOverrideSuccess(execution) ? ExecutionStatus.TERMINAL : ExecutionStatus.SUCCEEDED));
                    } else {
                        int n;
                        Object object2;
                        Object v4;
                        block26: {
                            Message this_$iv = $this$determineFinalStatus;
                            boolean $i$f$getAttribute = false;
                            Iterable iterable = this_$iv.getAttributes();
                            boolean bl13 = false;
                            object = iterable;
                            boolean bl14 = false;
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                Object t = iterator.next();
                                Attribute it$iv = (Attribute)t;
                                boolean bl15 = false;
                                if (!(it$iv instanceof AttemptsAttribute)) continue;
                                v4 = t;
                                break block26;
                            }
                            v4 = null;
                        }
                        int attempts = (object2 = (AttemptsAttribute)((Attribute)((AttemptsAttribute)v4))) == null ? 0 : (n = object2.getAttempts());
                        this.log.info("Re-queuing " + $this$determineFinalStatus + " as the execution is not yet complete (attempts: " + attempts + ")");
                        Queue queue = this.getQueue();
                        Message message = $this$determineFinalStatus;
                        object2 = this.retryDelay;
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"retryDelay");
                        queue.push(message, (TemporalAmount)object2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<StageExecution> getTopLevelStages(PipelineExecution $this$topLevelStages) {
        void $this$filterTo$iv$iv;
        List list = $this$topLevelStages.getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!(it.getParentStageId() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldOverrideSuccess(PipelineExecution $this$shouldOverrideSuccess) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            List list = $this$shouldOverrideSuccess.getStages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stages");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                StageExecution it = (StageExecution)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getStatus() == ExecutionStatus.STOPPED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getContext().get("completeOtherBranchesThenFail"), (Object)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean otherBranchesIncomplete(List<? extends StageExecution> $this$otherBranchesIncomplete) {
        boolean bl;
        StageExecution it;
        boolean bl2;
        Iterable $this$any$iv = $this$otherBranchesIncomplete;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (StageExecution)element$iv;
                boolean bl3 = false;
                if (it.getStatus() == ExecutionStatus.RUNNING) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = $this$otherBranchesIncomplete;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (StageExecution)element$iv;
            boolean bl5 = false;
            if (it.getStatus() == ExecutionStatus.NOT_STARTED && StageKt.allUpstreamStagesComplete((StageExecution)it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public Class<CompleteExecution> getMessageType() {
        return this.messageType;
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    public static final /* synthetic */ Logger access$getLog$p(CompleteExecutionHandler $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$determineFinalStatus(CompleteExecutionHandler $this, CompleteExecution $receiver, PipelineExecution execution, Function1 block) {
        $this.determineFinalStatus($receiver, execution, (Function1<? super ExecutionStatus, Unit>)block);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(CompleteExecutionHandler $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ Registry access$getRegistry$p(CompleteExecutionHandler $this) {
        return $this.registry;
    }

    public static final /* synthetic */ Id access$getCompletedId$p(CompleteExecutionHandler $this) {
        return $this.completedId;
    }

    public static final /* synthetic */ List access$getTopLevelStages(CompleteExecutionHandler $this, PipelineExecution $receiver) {
        return $this.getTopLevelStages($receiver);
    }
}

