/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.StageComplete;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.graph.StageGraphBuilderImpl;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CancelStage;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.CompleteStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageDefinitionBuildersKt;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.CompleteStageHandlerKt;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005BU\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0002J\f\u0010.\u001a\u00020/*\u00020-H\u0002J\f\u00100\u001a\u00020)*\u00020-H\u0002J\f\u00101\u001a\u000202*\u00020-H\u0002J\f\u00103\u001a\u00020)*\u00020-H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00064"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/CompleteStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/CompleteStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "exceptionHandlers", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "registry", "Lcom/netflix/spectator/api/Registry;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;Ljava/util/List;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "handle", "", "message", "trackResult", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "determineStatus", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "planAfterStages", "planOnFailureStages", "", "removeNotStartedSynthetics", "orca-queue"})
public class CompleteStageHandler
implements OrcaMessageHandler<CompleteStage>,
StageBuilderAware,
ExpressionAware,
AuthenticationAware {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageNavigator stageNavigator;
    @NotNull
    private final ApplicationEventPublisher publisher;
    @NotNull
    private final Clock clock;
    @NotNull
    private final List<ExceptionHandler> exceptionHandlers;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    @NotNull
    private final Registry registry;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final Class<CompleteStage> messageType;

    public CompleteStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageNavigator stageNavigator, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull Clock clock, @NotNull List<? extends ExceptionHandler> exceptionHandlers, @NotNull ContextParameterProcessor contextParameterProcessor, @NotNull Registry registry, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        this.queue = queue;
        this.repository = repository;
        this.stageNavigator = stageNavigator;
        this.publisher = publisher;
        this.clock = clock;
        this.exceptionHandlers = exceptionHandlers;
        this.contextParameterProcessor = contextParameterProcessor;
        this.registry = registry;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.messageType = CompleteStage.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    public void handle(@NotNull CompleteStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, message){
            final /* synthetic */ CompleteStageHandler this$0;
            final /* synthetic */ CompleteStage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.RUNNING, ExecutionStatus.NOT_STARTED};
                if (SetsKt.setOf((Object[])objectArray).contains(stage.getStatus())) {
                    Object object;
                    ExecutionStatus status = CompleteStageHandler.access$determineStatus(this.this$0, stage);
                    if (this.this$0.shouldFailOnFailedExpressionEvaluation(stage)) {
                        this.this$0.getLog().warn("Stage " + stage.getId() + " (" + stage.getType() + ") of " + stage.getExecution().getId() + " is set to fail because of failed expressions.");
                        status = ExecutionStatus.TERMINAL;
                    }
                    try {
                        Object hasOnFailureStages;
                        HashMap $this$forEach$iv22;
                        object = new ExecutionStatus[]{ExecutionStatus.RUNNING, ExecutionStatus.NOT_STARTED};
                        if (SetsKt.setOf((Object[])object).contains(status) || status.isComplete() && !status.isHalt()) {
                            List afterStages = StageKt.firstAfterStages((StageExecution)stage);
                            if (afterStages.isEmpty()) {
                                this.this$0.withAuth(stage, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, stage){
                                    final /* synthetic */ CompleteStageHandler this$0;
                                    final /* synthetic */ StageExecution $stage;
                                    {
                                        this.this$0 = $receiver;
                                        this.$stage = $stage;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        CompleteStageHandler.access$planAfterStages(this.this$0, this.$stage);
                                    }
                                }));
                                afterStages = StageKt.firstAfterStages((StageExecution)stage);
                            }
                            Collection collection = afterStages;
                            boolean bl = false;
                            if (!collection.isEmpty()) {
                                boolean bl2;
                                Iterable $this$any$iv;
                                block39: {
                                    $this$any$iv = afterStages;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            StageExecution it = (StageExecution)element$iv;
                                            boolean bl3 = false;
                                            if (!(it.getStatus() == ExecutionStatus.NOT_STARTED)) continue;
                                            bl2 = true;
                                            break block39;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (bl2) {
                                    CompleteStage $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    $this$any$iv = afterStages;
                                    boolean $i$f$filter = false;
                                    Iterator<T> iterator = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterTo22 = false;
                                    Iterator<T> bl3 = $this$filterTo$iv$iv.iterator();
                                    while (bl3.hasNext()) {
                                        T element$iv$iv = bl3.next();
                                        StageExecution it = (StageExecution)element$iv$iv;
                                        boolean bl4 = false;
                                        if (!(it.getStatus() == ExecutionStatus.NOT_STARTED)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    CompleteStageHandler completeStageHandler = this.this$0;
                                    $this$filterTo$iv$iv = this.$message;
                                    boolean $i$f$forEach22 = false;
                                    Iterator<T> $i$f$filterTo22 = $this$forEach$iv22.iterator();
                                    while ($i$f$filterTo22.hasNext()) {
                                        T element$iv = $i$f$filterTo22.next();
                                        StageExecution it = (StageExecution)element$iv;
                                        boolean bl5 = false;
                                        Queue queue = completeStageHandler.getQueue();
                                        ExecutionLevel executionLevel = $this$filterTo$iv$iv;
                                        String bl4 = it.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"it.id");
                                        queue.push((Message)new StartStage(executionLevel, bl4));
                                    }
                                    return;
                                }
                            }
                            if (status == ExecutionStatus.NOT_STARTED) {
                                this.this$0.getLog().warn("Stage " + stage.getId() + " (" + stage.getType() + ") of " + stage.getExecution().getId() + " had no tasks or synthetic stages!");
                                status = ExecutionStatus.SKIPPED;
                            }
                        } else if (status.isFailure()) {
                            hasOnFailureStages = new Ref.BooleanRef();
                            this.this$0.withAuth(stage, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.BooleanRef)hasOnFailureStages, this.this$0, stage){
                                final /* synthetic */ Ref.BooleanRef $hasOnFailureStages;
                                final /* synthetic */ CompleteStageHandler this$0;
                                final /* synthetic */ StageExecution $stage;
                                {
                                    this.$hasOnFailureStages = $hasOnFailureStages;
                                    this.this$0 = $receiver;
                                    this.$stage = $stage;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$hasOnFailureStages.element = CompleteStageHandler.access$planOnFailureStages(this.this$0, this.$stage);
                                }
                            }));
                            if (((Ref.BooleanRef)hasOnFailureStages).element) {
                                Iterable $this$forEach$iv = StageKt.firstAfterStages((StageExecution)stage);
                                CompleteStageHandler completeStageHandler = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    StageExecution it = (StageExecution)element$iv;
                                    boolean bl7 = false;
                                    completeStageHandler.getQueue().push((Message)new StartStage(it));
                                }
                                return;
                            }
                        }
                        stage.setStatus(status);
                        if (status == ExecutionStatus.FAILED_CONTINUE) {
                            void $this$forEach$iv;
                            Object object2;
                            void $this$filterTo$iv$iv;
                            Object v6;
                            Object element$iv;
                            Map map;
                            Object $i$f$forEach;
                            Object $i$f$forEach22 = stage.getContext().get("exception");
                            Object object3 = $i$f$forEach = $i$f$forEach22 instanceof HashMap ? (HashMap)$i$f$forEach22 : null;
                            if ($i$f$forEach == null) {
                                map = null;
                            } else {
                                $i$f$forEach22 = (Map)$i$f$forEach;
                                element$iv = "details";
                                boolean it = false;
                                map = (Map)$i$f$forEach22.get(element$iv);
                            }
                            Map map2 = map;
                            HashMap hashMap = $this$forEach$iv22 = map2 instanceof HashMap ? (HashMap)map2 : null;
                            if ($this$forEach$iv22 == null) {
                                v6 = null;
                            } else {
                                map2 = $this$forEach$iv22;
                                $i$f$forEach = "errors";
                                boolean $i$f$forEach22 = false;
                                v6 = map2.get($i$f$forEach);
                            }
                            hasOnFailureStages = v6;
                            hasOnFailureStages = hasOnFailureStages instanceof ArrayList ? (ArrayList)hasOnFailureStages : null;
                            boolean $this$forEach$iv22 = false;
                            boolean bl = false;
                            Object $this$invoke_u24lambda_u2d7 = hasOnFailureStages;
                            boolean bl6 = false;
                            element$iv = stage.getTasks();
                            Intrinsics.checkNotNullExpressionValue((Object)element$iv, (String)"stage.tasks");
                            Iterable $this$filter$iv = (Iterable)element$iv;
                            boolean $i$f$filter = false;
                            Iterable bl7 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                TaskExecution t = (TaskExecution)element$iv$iv;
                                boolean bl82 = false;
                                object2 = t.getTaskExceptionDetails();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"t.taskExceptionDetails");
                                boolean bl9 = false;
                                boolean bl10 = !object2.isEmpty();
                                if (!bl10) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach3 = false;
                            for (T element$iv2 : $this$forEach$iv) {
                                TaskExecution y = (TaskExecution)element$iv2;
                                boolean bl11 = false;
                                Object element$iv$iv = y.getTaskExceptionDetails().get("exception");
                                if (element$iv$iv == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
                                }
                                element$iv$iv = (HashMap)element$iv$iv;
                                Iterator<T> iterator = "details";
                                boolean bl82 = false;
                                object2 = element$iv$iv.get(iterator);
                                if (object2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<*, *>{ kotlin.collections.TypeAliasesKt.HashMap<*, *> }");
                                }
                                HashMap details = (HashMap)object2;
                                object2 = $this$invoke_u24lambda_u2d7;
                                if (object2 != null) {
                                    ((ArrayList)object2).add(y.getName() + ":");
                                }
                                object2 = $this$invoke_u24lambda_u2d7;
                                if (object2 != null) {
                                    iterator = details;
                                    String bl82 = "error";
                                    boolean bl12 = false;
                                    element$iv$iv = iterator.get(bl82);
                                    if (element$iv$iv == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    ((ArrayList)object2).add((String)element$iv$iv);
                                }
                                element$iv$iv = details;
                                iterator = "errors";
                                boolean bl82 = false;
                                object2 = element$iv$iv.get(iterator);
                                if (object2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
                                }
                                Iterable $this$forEach$iv3 = (ArrayList)object2;
                                boolean $i$f$forEach4 = false;
                                iterator = $this$forEach$iv3.iterator();
                                while (iterator.hasNext()) {
                                    T element$iv3;
                                    T t = element$iv3 = iterator.next();
                                    boolean bl13 = false;
                                    Object object4 = $this$invoke_u24lambda_u2d7;
                                    if (object4 == null) continue;
                                    if (t == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                                    }
                                    ((ArrayList)object4).add((String)t);
                                }
                            }
                        }
                        stage.setEndTime(Long.valueOf(CompleteStageHandler.access$getClock$p(this.this$0).millis()));
                    }
                    catch (Exception e) {
                        this.this$0.getLog().error("Failed to construct after stages for " + stage.getName() + " " + stage.getId(), (Throwable)e);
                        ExceptionHandler.Response exceptionDetails = this.this$0.shouldRetry(CompleteStageHandler.access$getExceptionHandlers$p(this.this$0), e, stage.getName() + ":ConstructAfterStages");
                        Map map = stage.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"stage.context");
                        String string = "exception";
                        boolean bl = false;
                        map.put(string, exceptionDetails);
                        stage.setStatus(ExecutionStatus.TERMINAL);
                        stage.setEndTime(Long.valueOf(CompleteStageHandler.access$getClock$p(this.this$0).millis()));
                    }
                    this.this$0.includeExpressionEvaluationSummary(stage);
                    this.this$0.getRepository().storeStage(stage);
                    if (stage.getStatus() == ExecutionStatus.FAILED_CONTINUE && stage.getSyntheticStageOwner() != null && !stage.getAllowSiblingStagesToContinueOnFailure()) {
                        Queue queue = this.this$0.getQueue();
                        String string = stage.getParentStageId();
                        Intrinsics.checkNotNull((Object)string);
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.parentStageId!!");
                        queue.push((Message)CompleteStage.copy$default(this.$message, null, null, null, (String)object, 7, null));
                    } else {
                        object = new ExecutionStatus[]{ExecutionStatus.SUCCEEDED, ExecutionStatus.FAILED_CONTINUE, ExecutionStatus.SKIPPED};
                        if (CollectionsKt.listOf((Object[])object).contains(stage.getStatus())) {
                            this.this$0.startNext(stage);
                        } else {
                            this.this$0.getQueue().push((Message)new CancelStage(this.$message));
                            if (stage.getSyntheticStageOwner() == null) {
                                this.this$0.getLog().debug("Stage has no synthetic owner and status is '" + stage.getStatus() + "', completing execution (original message: " + this.$message + ")");
                                this.this$0.getQueue().push((Message)new CompleteExecution(this.$message));
                            } else {
                                Queue queue = this.this$0.getQueue();
                                String string = stage.getParentStageId();
                                Intrinsics.checkNotNull((Object)string);
                                object = string;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.parentStageId!!");
                                queue.push((Message)CompleteStage.copy$default(this.$message, null, null, null, (String)object, 7, null));
                            }
                        }
                    }
                    CompleteStageHandler.access$getPublisher$p(this.this$0).publishEvent((ApplicationEvent)new StageComplete((Object)this.this$0, stage));
                    CompleteStageHandler.access$trackResult(this.this$0, stage);
                }
            }
        }));
    }

    private final void trackResult(StageExecution stage) {
        Id id;
        Id id2;
        Object it;
        boolean bl;
        boolean bl2;
        Object v;
        Id id3;
        if (stage.getParentStageId() != null) {
            return;
        }
        Id id4 = this.registry.createId("stage.invocations.duration").withTag("status", stage.getStatus().toString()).withTag("stageType", stage.getType());
        boolean bl3 = false;
        boolean bl4 = false;
        Id id5 = id4;
        boolean bl5 = false;
        Object object = stage.getContext().get("cloudProvider");
        if (object == null) {
            id3 = id5;
        } else {
            v = object;
            bl2 = false;
            bl = false;
            it = v;
            boolean bl6 = false;
            id2 = id5.withTag("cloudProvider", it.toString());
            id3 = id2 == null ? id5 : id2;
        }
        id4 = id3;
        bl3 = false;
        bl4 = false;
        id5 = id4;
        boolean bl7 = false;
        object = stage.getAdditionalMetricTags();
        if (object == null) {
            id = id5;
        } else {
            v = object;
            bl2 = false;
            bl = false;
            it = v;
            boolean bl8 = false;
            id2 = id5.withTags(stage.getAdditionalMetricTags());
            id = id2 == null ? id5 : id2;
        }
        Id id6 = id;
        Long l = stage.getEndTime();
        Long l2 = l == null ? Long.valueOf(this.clock.millis()) : l;
        long endTime = ((Number)l2).longValue();
        object = stage.getStartTime();
        Object object2 = object == null ? Long.valueOf(endTime) : object;
        long startTime = ((Number)object2).longValue();
        PercentileTimer.get((Registry)this.registry, (Id)id6).record(endTime - startTime, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public Class<CompleteStage> getMessageType() {
        return this.messageType;
    }

    private final void planAfterStages(StageExecution $this$planAfterStages) {
        Ref.BooleanRef hasPlannedStages = new Ref.BooleanRef();
        StageDefinitionBuildersKt.buildAfterStages(this.builder($this$planAfterStages), $this$planAfterStages, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, hasPlannedStages){
            final /* synthetic */ CompleteStageHandler this$0;
            final /* synthetic */ Ref.BooleanRef $hasPlannedStages;
            {
                this.this$0 = $receiver;
                this.$hasPlannedStages = $hasPlannedStages;
                super(1);
            }

            public final void invoke(@NotNull StageExecution it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getRepository().addStage(it);
                this.$hasPlannedStages.element = true;
            }
        }));
        if (hasPlannedStages.element) {
            $this$planAfterStages.setExecution(this.getRepository().retrieve($this$planAfterStages.getExecution().getType(), $this$planAfterStages.getExecution().getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean planOnFailureStages(StageExecution $this$planOnFailureStages) {
        boolean bl;
        boolean alreadyPlanned;
        List onFailureStages;
        block9: {
            boolean bl2;
            boolean bl3;
            Iterable $this$mapTo$iv$iv;
            StageExecution it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = StageKt.afterStages((StageExecution)$this$planOnFailureStages);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (StageExecution)element$iv$iv;
                boolean bl4 = false;
                if (!it.getStatus().isComplete()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (StageExecution)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl3 = false;
                String string = it.getName();
                collection.add(string);
            }
            List previouslyPlannedAfterStageNames = (List)destination$iv$iv;
            StageGraphBuilderImpl $i$f$map22 = StageGraphBuilderImpl.afterStages((StageExecution)$this$planOnFailureStages);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"afterStages(this)");
            StageGraphBuilderImpl graph = $i$f$map22;
            this.builder($this$planOnFailureStages).onFailureStages($this$planOnFailureStages, (StageGraphBuilder)graph);
            $this$mapTo$iv$iv = graph.build();
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"graph.build()");
            onFailureStages = CollectionsKt.toList((Iterable)$this$mapTo$iv$iv);
            Iterable $this$forEachIndexed$iv = onFailureStages;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void stage;
                int it2 = index$iv++;
                bl3 = false;
                if (it2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                StageExecution stageExecution = (StageExecution)item$iv;
                int index = it2;
                boolean bl5 = false;
                if (index <= 0) continue;
                graph.connect((StageExecution)onFailureStages.get(index - 1), (StageExecution)stage);
            }
            Iterable $this$any$iv = onFailureStages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StageExecution it3 = (StageExecution)element$iv;
                    boolean bl6 = false;
                    if (!previouslyPlannedAfterStageNames.contains(it3.getName())) continue;
                    bl2 = true;
                    break block9;
                }
                bl2 = alreadyPlanned = false;
            }
        }
        if (alreadyPlanned || onFailureStages.isEmpty()) {
            bl = false;
        } else {
            this.removeNotStartedSynthetics($this$planOnFailureStages);
            StageDefinitionBuildersKt.appendAfterStages($this$planOnFailureStages, onFailureStages, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this){
                final /* synthetic */ CompleteStageHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull StageExecution it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getRepository().addStage(it);
                }
            }));
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeNotStartedSynthetics(StageExecution $this$removeNotStartedSynthetics) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StageKt.syntheticStages((StageExecution)$this$removeNotStartedSynthetics);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getStatus() == ExecutionStatus.NOT_STARTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Object element$iv$iv;
            StageExecution stage = (StageExecution)element$iv;
            boolean bl = false;
            element$iv$iv = $this$removeNotStartedSynthetics.getExecution().getStages();
            Intrinsics.checkNotNullExpressionValue(element$iv$iv, (String)"execution\n          .stages");
            element$iv$iv = (Iterable)element$iv$iv;
            boolean $i$f$filter2 = false;
            void bl2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                StageExecution it = (StageExecution)element$iv$iv2;
                boolean bl3 = false;
                if (!it.getRequisiteStageRefIds().contains(stage.getId())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                StageExecution it = (StageExecution)element$iv2;
                boolean bl4 = false;
                Collection collection = it.getRequisiteStageRefIds();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.requisiteStageRefIds");
                it.setRequisiteStageRefIds((Collection)CollectionsKt.minus((Iterable)collection, (Object)stage.getId()));
                this.getRepository().addStage(it);
            }
            this.removeNotStartedSynthetics(stage);
            this.getRepository().removeStage($this$removeNotStartedSynthetics.getExecution(), stage.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionStatus determineStatus(StageExecution $this$determineStatus) {
        ExecutionStatus executionStatus;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        ExecutionStatus executionStatus2;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv = StageKt.syntheticStages((StageExecution)$this$determineStatus);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void p0;
            StageExecution stageExecution = (StageExecution)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            executionStatus2 = p0.getStatus();
            collection.add(executionStatus2);
        }
        List syntheticStatuses = (List)destination$iv$iv;
        List $i$f$map22 = $this$determineStatus.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"tasks");
        Iterable $this$map$iv2 = $i$f$map22;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void p0;
            TaskExecution bl = (TaskExecution)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            executionStatus2 = p0.getStatus();
            collection.add(executionStatus2);
        }
        List taskStatuses = (List)destination$iv$iv2;
        List planningStatus = CompleteStageHandlerKt.access$hasPlanningFailure($this$determineStatus) ? CollectionsKt.listOf((Object)StageKt.failureStatus$default((StageExecution)$this$determineStatus, null, (int)1, null)) : CollectionsKt.emptyList();
        List allStatuses = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)syntheticStatuses, (Iterable)taskStatuses), (Iterable)planningStatus);
        Iterable $this$map$iv3 = StageKt.afterStages((StageExecution)$this$determineStatus);
        boolean $i$f$map3 = false;
        item$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void p0;
            StageExecution stageExecution = (StageExecution)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl = false;
            executionStatus2 = p0.getStatus();
            collection.add(executionStatus2);
        }
        List afterStageStatuses = (List)destination$iv$iv3;
        if (allStatuses.isEmpty()) {
            executionStatus = ExecutionStatus.NOT_STARTED;
        } else if (allStatuses.contains(ExecutionStatus.TERMINAL)) {
            executionStatus = StageKt.failureStatus$default((StageExecution)$this$determineStatus, null, (int)1, null);
        } else if (allStatuses.contains(ExecutionStatus.STOPPED)) {
            executionStatus = ExecutionStatus.STOPPED;
        } else if (allStatuses.contains(ExecutionStatus.CANCELED)) {
            executionStatus = ExecutionStatus.CANCELED;
        } else if (allStatuses.contains(ExecutionStatus.FAILED_CONTINUE)) {
            executionStatus = ExecutionStatus.FAILED_CONTINUE;
        } else {
            boolean bl;
            block20: {
                Iterable $this$all$iv = allStatuses;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExecutionStatus it = (ExecutionStatus)element$iv;
                        boolean bl3 = false;
                        if (it == ExecutionStatus.SUCCEEDED || it == ExecutionStatus.SKIPPED) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                executionStatus = ExecutionStatus.SUCCEEDED;
            } else if (afterStageStatuses.contains(ExecutionStatus.NOT_STARTED)) {
                executionStatus = ExecutionStatus.RUNNING;
            } else {
                this.getLog().error("Unhandled condition for stage " + $this$determineStatus.getId() + " of " + $this$determineStatus.getExecution().getId() + ", marking as TERMINAL. syntheticStatuses=" + syntheticStatuses + ", taskStatuses=" + taskStatuses + ", planningStatus=" + planningStatus + ", afterStageStatuses=" + afterStageStatuses);
                executionStatus = ExecutionStatus.TERMINAL;
            }
        }
        return executionStatus;
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution stage) {
        return AuthenticationAware.DefaultImpls.retrieveAuthenticatedUser(this, stage);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    public static final /* synthetic */ ExecutionStatus access$determineStatus(CompleteStageHandler $this, StageExecution $receiver) {
        return $this.determineStatus($receiver);
    }

    public static final /* synthetic */ void access$planAfterStages(CompleteStageHandler $this, StageExecution $receiver) {
        $this.planAfterStages($receiver);
    }

    public static final /* synthetic */ boolean access$planOnFailureStages(CompleteStageHandler $this, StageExecution $receiver) {
        return $this.planOnFailureStages($receiver);
    }

    public static final /* synthetic */ Clock access$getClock$p(CompleteStageHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ List access$getExceptionHandlers$p(CompleteStageHandler $this) {
        return $this.exceptionHandlers;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(CompleteStageHandler $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ void access$trackResult(CompleteStageHandler $this, StageExecution stage) {
        $this.trackResult(stage);
    }
}

