/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CompleteStage;
import com.netflix.spinnaker.orca.q.ContinueParentStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartTask;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u001bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/ContinueParentStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/ContinueParentStage;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "retryDelayMs", "", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;J)V", "log", "Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "retryDelay", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "handle", "", "message", "runFirstTask", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "orca-queue"})
public class ContinueParentStageHandler
implements OrcaMessageHandler<ContinueParentStage> {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final Logger log;
    private final Duration retryDelay;
    @NotNull
    private final Class<ContinueParentStage> messageType;

    public ContinueParentStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @Value(value="${queue.retry.delay.ms:5000}") long retryDelayMs) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.queue = queue;
        this.repository = repository;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        this.log = logger;
        this.retryDelay = Duration.ofMillis(retryDelayMs);
        this.messageType = ContinueParentStage.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    public void handle(@NotNull ContinueParentStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(message, this){
            final /* synthetic */ ContinueParentStage $message;
            final /* synthetic */ ContinueParentStageHandler this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                if (this.$message.getPhase() == SyntheticStageOwner.STAGE_BEFORE) {
                    if (StageKt.allBeforeStagesSuccessful((StageExecution)stage)) {
                        if (StageKt.hasTasks((StageExecution)stage)) {
                            ContinueParentStageHandler.access$runFirstTask(this.this$0, stage);
                        } else {
                            this.this$0.getQueue().push((Message)new CompleteStage(stage));
                        }
                    } else if (!StageKt.anyBeforeStagesFailed((StageExecution)stage)) {
                        ContinueParentStageHandler.access$getLog$p(this.this$0).info("Re-queuing " + this.$message + " as other " + this.$message.getPhase() + " stages are still running");
                        Queue queue = this.this$0.getQueue();
                        Message message = this.$message;
                        Duration duration = ContinueParentStageHandler.access$getRetryDelay$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"retryDelay");
                        queue.push(message, (TemporalAmount)duration);
                    }
                } else if (StageKt.allAfterStagesComplete((StageExecution)stage)) {
                    this.this$0.getQueue().push((Message)new CompleteStage(stage));
                } else {
                    ContinueParentStageHandler.access$getLog$p(this.this$0).info("Re-queuing " + this.$message + " as other " + this.$message.getPhase() + " stages are still running");
                    Queue queue = this.this$0.getQueue();
                    Message message = this.$message;
                    Duration duration = ContinueParentStageHandler.access$getRetryDelay$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"retryDelay");
                    queue.push(message, (TemporalAmount)duration);
                }
            }
        }));
    }

    private final void runFirstTask(StageExecution $this$runFirstTask) {
        List list = $this$runFirstTask.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tasks");
        TaskExecution firstTask = (TaskExecution)CollectionsKt.first((List)list);
        if (firstTask.getStatus() == ExecutionStatus.NOT_STARTED) {
            Queue queue = this.getQueue();
            Intrinsics.checkNotNullExpressionValue((Object)firstTask, (String)"firstTask");
            queue.push((Message)new StartTask($this$runFirstTask, firstTask));
        } else {
            this.log.warn("Ignoring " + this.getMessageType() + " for " + $this$runFirstTask.getId() + " as tasks are already running");
        }
    }

    @NotNull
    public Class<ContinueParentStage> getMessageType() {
        return this.messageType;
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    public static final /* synthetic */ void access$runFirstTask(ContinueParentStageHandler $this, StageExecution $receiver) {
        $this.runFirstTask($receiver);
    }

    public static final /* synthetic */ Logger access$getLog$p(ContinueParentStageHandler $this) {
        return $this.log;
    }

    public static final /* synthetic */ Duration access$getRetryDelay$p(ContinueParentStageHandler $this) {
        return $this.retryDelay;
    }
}

