/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="abortStage")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\nH\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/orca/q/AbortStage;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "source", "(Lcom/netflix/spinnaker/orca/q/StageLevel;)V", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "", "application", "stageId", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStageId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class AbortStage
extends Message
implements StageLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @NotNull
    private final String stageId;

    public AbortStage(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.stageId = stageId;
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public String getStageId() {
        return this.stageId;
    }

    public AbortStage(@NotNull StageLevel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), source.getStageId());
    }

    public AbortStage(@NotNull StageExecution source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object object = source.getExecution().getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.execution.type");
        ExecutionType executionType = object;
        object = source.getExecution().getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.execution.id");
        Object object2 = object;
        object = source.getExecution().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.execution.application");
        Object object3 = object;
        object = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.id");
        this(executionType, (String)object2, (String)object3, (String)object);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final String component4() {
        return this.getStageId();
    }

    @NotNull
    public final AbortStage copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        return new AbortStage(executionType, executionId, application, stageId);
    }

    public static /* synthetic */ AbortStage copy$default(AbortStage abortStage, ExecutionType executionType, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = abortStage.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = abortStage.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = abortStage.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = abortStage.getStageId();
        }
        return abortStage.copy(executionType, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "AbortStage(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", stageId=" + this.getStageId() + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        result = result * 31 + this.getStageId().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbortStage)) {
            return false;
        }
        AbortStage abortStage = (AbortStage)other;
        if (this.getExecutionType() != abortStage.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)abortStage.getExecutionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getApplication(), (Object)abortStage.getApplication())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getStageId(), (Object)abortStage.getStageId());
    }
}

