/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="restartStage")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bB/\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0018\u001a\u00020\rH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J=\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u000f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/netflix/spinnaker/orca/q/RestartStage;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "source", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "stageId", "", "user", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;Ljava/lang/String;Ljava/lang/String;)V", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;Ljava/lang/String;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStageId", "getUser", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class RestartStage
extends Message
implements StageLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @NotNull
    private final String stageId;
    @Nullable
    private final String user;

    public RestartStage(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.stageId = stageId;
        this.user = user;
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public String getStageId() {
        return this.stageId;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public RestartStage(@NotNull PipelineExecution source, @NotNull String stageId, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Object object = source.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.type");
        ExecutionType executionType = object;
        object = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.id");
        Object object2 = object;
        object = source.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.application");
        this(executionType, (String)object2, (String)object, stageId, user);
    }

    public RestartStage(@NotNull StageExecution stage, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        Object object = stage.getExecution().getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.execution.type");
        ExecutionType executionType = object;
        object = stage.getExecution().getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.execution.id");
        Object object2 = object;
        object = stage.getExecution().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.execution.application");
        Object object3 = object;
        object = stage.getId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stage.id");
        this(executionType, (String)object2, (String)object3, (String)object, user);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final String component4() {
        return this.getStageId();
    }

    @Nullable
    public final String component5() {
        return this.user;
    }

    @NotNull
    public final RestartStage copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId, @Nullable String user) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        return new RestartStage(executionType, executionId, application, stageId, user);
    }

    public static /* synthetic */ RestartStage copy$default(RestartStage restartStage, ExecutionType executionType, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = restartStage.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = restartStage.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = restartStage.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = restartStage.getStageId();
        }
        if ((n & 0x10) != 0) {
            string4 = restartStage.user;
        }
        return restartStage.copy(executionType, string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "RestartStage(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", stageId=" + this.getStageId() + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        result = result * 31 + this.getStageId().hashCode();
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RestartStage)) {
            return false;
        }
        RestartStage restartStage = (RestartStage)other;
        if (this.getExecutionType() != restartStage.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)restartStage.getExecutionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getApplication(), (Object)restartStage.getApplication())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStageId(), (Object)restartStage.getStageId())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)restartStage.user);
    }
}

