/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.jackson.OrcaObjectMapper;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.ContinueParentStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.InvalidExecutionId;
import com.netflix.spinnaker.orca.q.InvalidStageId;
import com.netflix.spinnaker.orca.q.InvalidTaskId;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.MessageHandler;
import com.netflix.spinnaker.q.Queue;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0016J*\u0010\u000b\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u0015*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J \u0010\u001b\u001a\u00020\u0015*\u00020\u001c2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J&\u0010\u001d\u001a\u00020\u0015*\u00020\u001e2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001fH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "M", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/q/MessageHandler;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "shouldQueue", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "shouldRetry", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler$Response;", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "taskName", "", "startNext", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "withExecution", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "block", "Lkotlin/Function1;", "withStage", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "withTask", "Lcom/netflix/spinnaker/orca/q/TaskLevel;", "Lkotlin/Function2;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "Companion", "orca-queue"})
public interface OrcaMessageHandler<M extends Message>
extends MessageHandler<M> {
    @NotNull
    public static final Companion Companion = com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler$Companion.$$INSTANCE;

    @NotNull
    public ExecutionRepository getRepository();

    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> var1, @NotNull Exception var2, @Nullable String var3);

    public void withTask(@NotNull TaskLevel var1, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> var2);

    public void withStage(@NotNull StageLevel var1, @NotNull Function1<? super StageExecution, Unit> var2);

    public void withExecution(@NotNull ExecutionLevel var1, @NotNull Function1<? super PipelineExecution, Unit> var2);

    public void startNext(@NotNull StageExecution var1);

    public boolean shouldQueue(@NotNull PipelineExecution var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler$Companion;", "", "()V", "MIN_PAGE_SIZE", "", "getMIN_PAGE_SIZE", "()I", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "orca-queue"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger log;
        @NotNull
        private static final ObjectMapper mapper;
        private static final int MIN_PAGE_SIZE;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public final int getMIN_PAGE_SIZE() {
            return MIN_PAGE_SIZE;
        }

        static {
            $$INSTANCE = new Companion();
            Logger logger = LoggerFactory.getLogger($$INSTANCE.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
            log = logger;
            logger = OrcaObjectMapper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance()");
            mapper = logger;
            MIN_PAGE_SIZE = 2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static <M extends Message> ExceptionHandler.Response shouldRetry(@NotNull OrcaMessageHandler<M> this_, @NotNull Collection<? extends ExceptionHandler> receiver, @NotNull Exception ex, @Nullable String taskName) {
            String string;
            Object v0;
            Iterable iterable;
            block1: {
                Intrinsics.checkNotNullParameter(this_, (String)"this");
                Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                iterable = receiver;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ExceptionHandler it = (ExceptionHandler)t;
                    boolean bl3 = false;
                    if (!it.handles(ex)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            ExceptionHandler exceptionHandler = v0;
            iterable = exceptionHandler;
            return iterable == null ? null : iterable.handle((string = taskName) == null ? "unspecified" : string, ex);
        }

        public static <M extends Message> void withTask(@NotNull OrcaMessageHandler<M> this_, @NotNull TaskLevel receiver, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this_.withStage(receiver, (Function1<StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(receiver, this_, block){
                final /* synthetic */ TaskLevel $this_withTask;
                final /* synthetic */ OrcaMessageHandler<M> this$0;
                final /* synthetic */ Function2<StageExecution, TaskExecution, Unit> $block;
                {
                    this.$this_withTask = $receiver;
                    this.this$0 = $receiver2;
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(@NotNull StageExecution stage) {
                    Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                    TaskExecution taskExecution = stage.taskById(this.$this_withTask.getTaskId());
                    TaskLevel taskLevel = this.$this_withTask;
                    OrcaMessageHandler<M> orcaMessageHandler = this.this$0;
                    Function2<StageExecution, TaskExecution, Unit> function2 = this.$block;
                    boolean bl = false;
                    boolean bl2 = false;
                    TaskExecution task = taskExecution;
                    boolean bl3 = false;
                    if (task == null) {
                        Object[] objectArray = new Object[]{taskLevel.getTaskId(), OrcaMessageHandler.Companion.getMapper().writeValueAsString((Object)stage), taskLevel};
                        OrcaMessageHandler.Companion.getLog().error("InvalidTaskId: Unable to find task {} in stage '{}' while processing message {}", objectArray);
                        orcaMessageHandler.getQueue().push((Message)new InvalidTaskId(taskLevel));
                    } else {
                        function2.invoke((Object)stage, (Object)task);
                    }
                }
            }));
        }

        public static <M extends Message> void withStage(@NotNull OrcaMessageHandler<M> this_, @NotNull StageLevel receiver, @NotNull Function1<? super StageExecution, Unit> block) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this_.withExecution(receiver, (Function1<PipelineExecution, Unit>)((Function1)new Function1<PipelineExecution, Unit>(receiver, block, this_){
                final /* synthetic */ StageLevel $this_withStage;
                final /* synthetic */ Function1<StageExecution, Unit> $block;
                final /* synthetic */ OrcaMessageHandler<M> this$0;
                {
                    this.$this_withStage = $receiver;
                    this.$block = $block;
                    this.this$0 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull PipelineExecution execution) {
                    Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                    try {
                        StageExecution stageExecution = execution.stageById(this.$this_withStage.getStageId());
                        boolean bl = false;
                        boolean bl2 = false;
                        StageExecution it = stageExecution;
                        boolean bl3 = false;
                        new StageExecutionImpl(execution, it.getType(), it.getContext());
                        Function1<StageExecution, Unit> function1 = this.$block;
                        bl2 = false;
                        boolean bl4 = false;
                        function1.invoke((Object)stageExecution);
                    }
                    catch (IllegalArgumentException e) {
                        OrcaMessageHandler.Companion.getLog().error("Failed to locate stage with id: {}", (Object)this.$this_withStage.getStageId(), (Object)e);
                        this.this$0.getQueue().push((Message)new InvalidStageId(this.$this_withStage));
                    }
                }
            }));
        }

        public static <M extends Message> void withExecution(@NotNull OrcaMessageHandler<M> this_, @NotNull ExecutionLevel receiver, @NotNull Function1<? super PipelineExecution, Unit> block) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                PipelineExecution pipelineExecution = this_.getRepository().retrieve(receiver.getExecutionType(), receiver.getExecutionId());
                Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"repository.retrieve(executionType, executionId)");
                PipelineExecution execution = pipelineExecution;
                block.invoke((Object)execution);
            }
            catch (ExecutionNotFoundException e) {
                this_.getQueue().push((Message)new InvalidExecutionId(receiver));
            }
        }

        public static <M extends Message> void startNext(@NotNull OrcaMessageHandler<M> this_, @NotNull StageExecution receiver) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            PipelineExecution pipelineExecution = receiver.getExecution();
            boolean bl = false;
            boolean bl2 = false;
            PipelineExecution execution = pipelineExecution;
            boolean bl3 = false;
            List list = receiver.downstreamStages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"downstreamStages()");
            List downstreamStages = list;
            SyntheticStageOwner phase = receiver.getSyntheticStageOwner();
            Object object = downstreamStages;
            boolean bl4 = false;
            if (!object.isEmpty()) {
                Iterable $this$forEach$iv = downstreamStages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl5 = false;
                    Queue queue = this_.getQueue();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    queue.push((Message)new StartStage(it));
                }
            } else if (phase != null) {
                Queue queue = this_.getQueue();
                Message message = new ContinueParentStage(StageKt.parent((StageExecution)receiver), phase);
                object = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ZERO");
                queue.ensure(message, (TemporalAmount)object);
            } else {
                Queue queue = this_.getQueue();
                Intrinsics.checkNotNullExpressionValue((Object)execution, (String)"execution");
                queue.push((Message)new CompleteExecution(execution));
            }
        }

        public static <M extends Message> boolean shouldQueue(@NotNull OrcaMessageHandler<M> this_, @NotNull PipelineExecution receiver) {
            boolean bl;
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            String configId = receiver.getPipelineConfigId();
            if (configId == null) {
                bl = false;
            } else {
                if (!receiver.isLimitConcurrent()) {
                    boolean bl2;
                    if (receiver.getMaxConcurrentExecutions() > 0) {
                        ExecutionStatus[] executionStatusArray = new ExecutionStatus[]{ExecutionStatus.RUNNING};
                        Object object = new ExecutionRepository.ExecutionCriteria().setPageSize(receiver.getMaxConcurrentExecutions() + Companion.getMIN_PAGE_SIZE()).setStatuses(executionStatusArray);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ExecutionCriteria().setP\u2026IZE).setStatuses(RUNNING)");
                        ExecutionRepository.ExecutionCriteria criteria = object;
                        object = this_.getRepository().retrievePipelinesForPipelineConfigId(configId, criteria).filter(arg_0 -> DefaultImpls.shouldQueue$lambda-3(receiver, arg_0)).count().toBlocking().first();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"repository\n             \u2026()\n              .first()");
                        bl2 = ((Number)object).intValue() >= receiver.getMaxConcurrentExecutions();
                    } else {
                        bl2 = false;
                    }
                    return bl2;
                }
                ExecutionStatus[] executionStatusArray = new ExecutionStatus[]{ExecutionStatus.RUNNING};
                Object object = new ExecutionRepository.ExecutionCriteria().setPageSize(Companion.getMIN_PAGE_SIZE()).setStatuses(executionStatusArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ExecutionCriteria().setP\u2026IZE).setStatuses(RUNNING)");
                ExecutionRepository.ExecutionCriteria criteria = object;
                object = this_.getRepository().retrievePipelinesForPipelineConfigId(configId, criteria).filter(arg_0 -> DefaultImpls.shouldQueue$lambda-4(receiver, arg_0)).count().toBlocking().first();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"repository\n          .re\u2026king()\n          .first()");
                bl = ((Number)object).intValue() > 0;
            }
            return bl;
        }

        public static <M extends Message> void invoke(@NotNull OrcaMessageHandler<M> this_, @NotNull Message message) {
            Intrinsics.checkNotNullParameter(this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            MessageHandler.DefaultImpls.invoke((MessageHandler)this_, (Message)message);
        }

        private static final Boolean shouldQueue$lambda-3(PipelineExecution $this_shouldQueue, PipelineExecution it) {
            Intrinsics.checkNotNullParameter((Object)$this_shouldQueue, (String)"$this_shouldQueue");
            return !Intrinsics.areEqual((Object)it.getId(), (Object)$this_shouldQueue.getId());
        }

        private static final Boolean shouldQueue$lambda-4(PipelineExecution $this_shouldQueue, PipelineExecution it) {
            Intrinsics.checkNotNullParameter((Object)$this_shouldQueue, (String)"$this_shouldQueue");
            return !Intrinsics.areEqual((Object)it.getId(), (Object)$this_shouldQueue.getId());
        }
    }
}

