/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.model.PipelineTrigger;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RestartStage;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u001e*\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\f\u0010&\u001a\u00020\u001e*\u00020\"H\u0002J\f\u0010'\u001a\u00020\u001e*\u00020\"H\u0002J\f\u0010(\u001a\u00020\u001e*\u00020\"H\u0002J\f\u0010)\u001a\u00020\u001e*\u00020\"H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108RX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/RestartStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/RestartStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "clock", "Ljava/time/Clock;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;Ljava/time/Clock;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "handle", "", "message", "restartParentPipelineIfNeeded", "topStage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "addRestartDetails", "user", "", "addSkipRestart", "removeSynthetics", "reset", "resetChildren", "orca-queue"})
public class RestartStageHandler
implements OrcaMessageHandler<RestartStage>,
StageBuilderAware {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final PendingExecutionService pendingExecutionService;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Class<RestartStage> messageType;

    public RestartStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull PendingExecutionService pendingExecutionService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"pendingExecutionService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.queue = queue;
        this.repository = repository;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.pendingExecutionService = pendingExecutionService;
        this.clock = clock;
        this.messageType = RestartStage.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @NotNull
    public Class<RestartStage> getMessageType() {
        return this.messageType;
    }

    private Logger getLog() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        return logger;
    }

    public void handle(@NotNull RestartStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(message, this){
            final /* synthetic */ RestartStage $message;
            final /* synthetic */ RestartStageHandler this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull StageExecution stage) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                StageExecution stageExecution = stage.getTopLevelStage();
                Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"stage.topLevelStage");
                StageExecution topStage = stageExecution;
                ExecutionType executionType = this.$message.getExecutionType();
                String string = this.$message.getExecutionId();
                String string2 = this.$message.getApplication();
                Object[] objectArray = topStage.getId();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"topStage.id");
                StartStage startMessage = new StartStage(executionType, string, string2, (String)objectArray);
                if (topStage.getStatus().isComplete() || topStage.getStatus() == ExecutionStatus.NOT_STARTED) {
                    RestartStageHandler.access$addRestartDetails(this.this$0, topStage, this.$message.getUser());
                    RestartStageHandler.access$reset(this.this$0, topStage);
                    RestartStageHandler.access$resetChildren(this.this$0, topStage);
                    objectArray = stage.getExecution();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"stage.execution");
                    if (this.this$0.shouldQueue((PipelineExecution)objectArray)) {
                        if (topStage.getExecution().getStatus() == ExecutionStatus.NOT_STARTED) {
                            objectArray = new Object[]{stage.getExecution().getApplication(), stage.getExecution().getName(), stage.getExecution().getId()};
                            RestartStageHandler.access$getLog(this.this$0).info("Skipping queueing restart of {} {} {}", objectArray);
                            return;
                        }
                        topStage.getExecution().updateStatus(ExecutionStatus.NOT_STARTED);
                        this.this$0.getRepository().updateStatus(topStage.getExecution());
                        objectArray = stage.getExecution().getPipelineConfigId();
                        if (objectArray != null) {
                            Object[] objectArray2 = objectArray;
                            RestartStageHandler restartStageHandler = this.this$0;
                            RestartStage restartStage = this.$message;
                            boolean bl = false;
                            boolean bl2 = false;
                            Object[] it = objectArray2;
                            boolean bl3 = false;
                            Object[] objectArray3 = new Object[]{stage.getExecution().getApplication(), stage.getExecution().getName(), stage.getExecution().getId()};
                            RestartStageHandler.access$getLog(restartStageHandler).info("Queueing restart of {} {} {}", objectArray3);
                            RestartStageHandler.access$getPendingExecutionService$p(restartStageHandler).enqueue((String)it, restartStage);
                        }
                    } else {
                        RestartStageHandler.access$restartParentPipelineIfNeeded(this.this$0, this.$message, topStage);
                        topStage.getExecution().updateStatus(ExecutionStatus.RUNNING);
                        this.this$0.getRepository().updateStatus(topStage.getExecution());
                        this.this$0.getQueue().push((Message)new StartStage(startMessage));
                    }
                }
            }
        }));
    }

    private final void restartParentPipelineIfNeeded(RestartStage message, StageExecution topStage) {
        if (!(topStage.getExecution().getTrigger() instanceof PipelineTrigger)) {
            return;
        }
        Trigger trigger = topStage.getExecution().getTrigger();
        if (trigger == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.orca.pipeline.model.PipelineTrigger");
        }
        PipelineTrigger trigger2 = (PipelineTrigger)trigger;
        if (trigger2.getParentPipelineStageId() == null) {
            return;
        }
        PipelineExecution pipelineExecution = this.getRepository().retrieve(trigger2.getParentExecution().getType(), trigger2.getParentExecution().getId());
        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"repository.retrieve(trig\u2026igger.parentExecution.id)");
        PipelineExecution parentExecution = pipelineExecution;
        if (!parentExecution.getStatus().isComplete()) {
            return;
        }
        StageExecution parentStage = parentExecution.stageById(trigger2.getParentPipelineStageId());
        Intrinsics.checkNotNullExpressionValue((Object)parentStage, (String)"parentStage");
        this.addSkipRestart(parentStage);
        this.getRepository().storeStage(parentStage);
        Queue queue = this.getQueue();
        PipelineExecution pipelineExecution2 = trigger2.getParentExecution();
        String string = parentStage.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentStage.id");
        queue.push((Message)new RestartStage(pipelineExecution2, string, message.getUser()));
    }

    private final void addSkipRestart(StageExecution $this$addSkipRestart) {
        Map map = $this$addSkipRestart.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context");
        String string = "_skipPipelineRestart";
        Boolean bl = true;
        boolean bl2 = false;
        map.put(string, bl);
    }

    private final void addRestartDetails(StageExecution $this$addRestartDetails, String user) {
        Map map = $this$addRestartDetails.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"context");
        String string = "restartDetails";
        Object object = new Pair[3];
        String string2 = user;
        object[0] = TuplesKt.to((Object)"restartedBy", (Object)(string2 == null ? "anonymous" : string2));
        object[1] = TuplesKt.to((Object)"restartTime", (Object)this.clock.millis());
        object[2] = TuplesKt.to((Object)"previousException", $this$addRestartDetails.getContext().remove("exception"));
        object = MapsKt.mapOf((Pair[])object);
        boolean bl = false;
        map.put(string, object);
    }

    private final void reset(StageExecution $this$reset) {
        if ($this$reset.getStatus().isComplete()) {
            $this$reset.setStatus(ExecutionStatus.NOT_STARTED);
            $this$reset.setStartTime(null);
            $this$reset.setEndTime(null);
            $this$reset.setTasks(CollectionsKt.emptyList());
            this.builder($this$reset).prepareStageForRestart($this$reset);
            this.getRepository().storeStage($this$reset);
            this.removeSynthetics($this$reset);
        }
    }

    private final void resetChildren(StageExecution $this$resetChildren) {
        List list = $this$resetChildren.allDownstreamStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allDownstreamStages()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StageExecution it = (StageExecution)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.reset(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeSynthetics(StageExecution $this$removeSynthetics) {
        void $this$filterTo$iv$iv;
        List list = $this$removeSynthetics.getExecution().getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution\n      .stages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getParentStageId(), (Object)$this$removeSynthetics.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StageExecution it = (StageExecution)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.removeSynthetics(it);
            this.getRepository().removeStage($this$removeSynthetics.getExecution(), it.getId());
        }
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    public static final /* synthetic */ void access$addRestartDetails(RestartStageHandler $this, StageExecution $receiver, String user) {
        $this.addRestartDetails($receiver, user);
    }

    public static final /* synthetic */ void access$reset(RestartStageHandler $this, StageExecution $receiver) {
        $this.reset($receiver);
    }

    public static final /* synthetic */ void access$resetChildren(RestartStageHandler $this, StageExecution $receiver) {
        $this.resetChildren($receiver);
    }

    public static final /* synthetic */ Logger access$getLog(RestartStageHandler $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ void access$restartParentPipelineIfNeeded(RestartStageHandler $this, RestartStage message, StageExecution topStage) {
        $this.restartParentPipelineIfNeeded(message, topStage);
    }

    public static final /* synthetic */ PendingExecutionService access$getPendingExecutionService$p(RestartStageHandler $this) {
        return $this.pendingExecutionService;
    }
}

