/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.ResumeTask;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0012\u001a\u0012\u0012\u000e\b\u0001\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u000b*\u00020\u00158RX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/ResumeTaskHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/ResumeTask;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/TaskResolver;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "type", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "kotlin.jvm.PlatformType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "getType$annotations", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)V", "getType", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)Ljava/lang/Class;", "handle", "", "message", "orca-queue"})
public class ResumeTaskHandler
implements OrcaMessageHandler<ResumeTask> {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final TaskResolver taskResolver;
    @NotNull
    private final Class<ResumeTask> messageType;

    public ResumeTaskHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        this.queue = queue;
        this.repository = repository;
        this.taskResolver = taskResolver;
        this.messageType = ResumeTask.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public Class<ResumeTask> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull ResumeTask message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this, message){
            final /* synthetic */ ResumeTaskHandler this$0;
            final /* synthetic */ ResumeTask $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StageExecution stage) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                List list = stage.getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stage\n        .tasks");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TaskExecution it = (TaskExecution)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getStatus() == ExecutionStatus.PAUSED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                ResumeTaskHandler resumeTaskHandler = this.this$0;
                object = this.$message;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TaskExecution it = (TaskExecution)element$iv;
                    boolean bl = false;
                    it.setStatus(ExecutionStatus.RUNNING);
                    Queue queue = resumeTaskHandler.getQueue();
                    TaskLevel taskLevel = (TaskLevel)object;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    queue.push((Message)new RunTask(taskLevel, ResumeTaskHandler.access$getType(resumeTaskHandler, it)));
                }
                this.this$0.getRepository().storeStage(stage);
            }
        }));
    }

    private Class<? extends Task> getType(TaskExecution $this$type) {
        Class clazz = this.taskResolver.getTaskClass($this$type.getImplementingClass());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"taskResolver.getTaskClass(implementingClass)");
        return clazz;
    }

    private static /* synthetic */ void getType$annotations(TaskExecution $this$getType_u24annotations) {
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    public static final /* synthetic */ Class access$getType(ResumeTaskHandler $this, TaskExecution $receiver) {
        return $this.getType($receiver);
    }
}

