/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.OverridableTimeoutRetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskExecutionInterceptor;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.clouddriver.utils.CloudProviderAware;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.exceptions.TimeoutException;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.lock.RetriableLock;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CompleteTask;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.InvalidTaskType;
import com.netflix.spinnaker.orca.q.PauseTask;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.RunTaskHandler;
import com.netflix.spinnaker.orca.q.metrics.MetricsTagHelper;
import com.netflix.spinnaker.orca.time.TimeKt;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004Bq\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000201H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020\u0002H\u0016J(\u0010@\u001a\u0002082\u0006\u00109\u001a\u0002012\u0006\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u001c\u0010F\u001a\u00020G*\u00020H2\u0006\u0010B\u001a\u00020C2\u0006\u00109\u001a\u000201H\u0002J$\u0010I\u001a\u000208*\u00020H2\u0006\u0010B\u001a\u00020C2\u0006\u00109\u001a\u0002012\u0006\u0010?\u001a\u00020JH\u0002J$\u0010K\u001a\u000208*\u00020H2\u0006\u00109\u001a\u0002012\u0006\u0010B\u001a\u00020C2\u0006\u0010?\u001a\u00020JH\u0002J\u0012\u0010L\u001a\u00020=*\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0002J\u0016\u0010M\u001a\u00020N*\u00020N2\b\u0010O\u001a\u0004\u0018\u00010NH\u0002J\u0016\u0010P\u001a\u000200*\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J\u0014\u0010T\u001a\u000208*\u0002012\u0006\u0010U\u001a\u00020NH\u0002J\u001c\u0010V\u001a\u00020=*\u00020W2\u0006\u0010B\u001a\u00020C2\u0006\u00109\u001a\u000201H\u0002J4\u0010X\u001a\n Z*\u0004\u0018\u00010Y0Y*\u00020\u00192\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020;2\u0006\u0010^\u001a\u00020;2\u0006\u0010_\u001a\u00020;H\u0002J\u0014\u0010`\u001a\u000208*\u00020\u00022\u0006\u0010a\u001a\u00020bH\u0002J\"\u0010c\u001a\u000208*\u0002012\u0006\u0010B\u001a\u00020C2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002080eH\u0002J,\u0010f\u001a\u000208*\u00020\u00022\u001e\u0010d\u001a\u001a\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u0002080gH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\u000200*\u0002018RX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u00104\u001a\u0004\u0018\u000101*\u0002018RX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006h"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/RunTaskHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/RunTask;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "clock", "Ljava/time/Clock;", "exceptionHandlers", "", "Lcom/netflix/spinnaker/orca/exceptions/ExceptionHandler;", "taskExecutionInterceptors", "Lcom/netflix/spinnaker/orca/api/pipeline/TaskExecutionInterceptor;", "registry", "Lcom/netflix/spectator/api/Registry;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "retriableLock", "Lcom/netflix/spinnaker/orca/lock/RetriableLock;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lcom/netflix/spinnaker/orca/TaskResolver;Ljava/time/Clock;Ljava/util/List;Ljava/util/List;Lcom/netflix/spectator/api/Registry;Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;Lcom/netflix/spinnaker/orca/lock/RetriableLock;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "warningInvocationTimeMs", "", "duration", "Ljava/time/Duration;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "getDuration", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)Ljava/time/Duration;", "executionWindow", "getExecutionWindow", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "checkForStageTimeout", "", "stage", "formatTimeout", "", "timeout", "", "handle", "message", "trackResult", "thisInvocationStartTimeMs", "taskModel", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "status", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "backoffPeriod", "Ljava/time/temporal/TemporalAmount;", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "checkForTaskTimeout", "Lcom/netflix/spinnaker/q/Message;", "checkForTimeout", "maxBackoff", "mergeOutputs", "Lcom/netflix/spinnaker/orca/api/pipeline/TaskResult;", "taskResult", "pausedDurationRelativeTo", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "instant", "Ljava/time/Instant;", "processTaskOutput", "result", "retryableBackOffPeriod", "Lcom/netflix/spinnaker/orca/api/pipeline/RetryableTask;", "timeoutCounter", "Lcom/netflix/spectator/api/Counter;", "kotlin.jvm.PlatformType", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "application", "stageType", "taskType", "withLocking", "action", "Ljava/lang/Runnable;", "withLoggingContext", "block", "Lkotlin/Function0;", "withTask", "Lkotlin/Function3;", "orca-queue"})
public class RunTaskHandler
implements OrcaMessageHandler<RunTask>,
ExpressionAware,
AuthenticationAware {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageNavigator stageNavigator;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    @NotNull
    private final TaskResolver taskResolver;
    @NotNull
    private final Clock clock;
    @NotNull
    private final List<ExceptionHandler> exceptionHandlers;
    @NotNull
    private final List<TaskExecutionInterceptor> taskExecutionInterceptors;
    @NotNull
    private final Registry registry;
    @NotNull
    private final DynamicConfigService dynamicConfigService;
    @NotNull
    private final RetriableLock retriableLock;
    private final int warningInvocationTimeMs;
    @NotNull
    private final Class<RunTask> messageType;

    public RunTaskHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageNavigator stageNavigator, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull ContextParameterProcessor contextParameterProcessor, @NotNull TaskResolver taskResolver, @NotNull Clock clock, @NotNull List<? extends ExceptionHandler> exceptionHandlers, @NotNull List<? extends TaskExecutionInterceptor> taskExecutionInterceptors, @NotNull Registry registry, @NotNull DynamicConfigService dynamicConfigService, @NotNull RetriableLock retriableLock) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(exceptionHandlers, (String)"exceptionHandlers");
        Intrinsics.checkNotNullParameter(taskExecutionInterceptors, (String)"taskExecutionInterceptors");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        Intrinsics.checkNotNullParameter((Object)retriableLock, (String)"retriableLock");
        this.queue = queue;
        this.repository = repository;
        this.stageNavigator = stageNavigator;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.contextParameterProcessor = contextParameterProcessor;
        this.taskResolver = taskResolver;
        this.clock = clock;
        this.exceptionHandlers = exceptionHandlers;
        this.taskExecutionInterceptors = taskExecutionInterceptors;
        this.registry = registry;
        this.dynamicConfigService = dynamicConfigService;
        this.retriableLock = retriableLock;
        Object object = this.dynamicConfigService.getConfig(Integer.TYPE, "tasks.warningInvocationTimeMs", (Object)30000);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dynamicConfigService.get\u2026ionTimeMs\",\n    30000\n  )");
        this.warningInvocationTimeMs = ((Number)object).intValue();
        this.messageType = RunTask.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    public void handle(@NotNull RunTask message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withLocking(message, () -> RunTaskHandler.handle$lambda-0(this, message));
    }

    private final void trackResult(StageExecution stage, long thisInvocationStartTimeMs, TaskExecution taskModel, ExecutionStatus status) {
        try {
            Iterable<BasicTag> commonTags = MetricsTagHelper.Companion.commonTags(stage, taskModel, status);
            Iterable<BasicTag> detailedTags = MetricsTagHelper.Companion.detailedTaskTags(stage, taskModel, status);
            long elapsedMillis = this.clock.millis() - thisInvocationStartTimeMs;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"task.invocations.duration", (Object)CollectionsKt.plus(commonTags, (Object)new BasicTag("application", stage.getExecution().getApplication()))), TuplesKt.to((Object)"task.invocations.duration.withType", (Object)CollectionsKt.plus(commonTags, detailedTags))};
            MapsKt.hashMapOf((Pair[])pairArray).forEach((arg_0, arg_1) -> RunTaskHandler.trackResult$lambda-1(this, elapsedMillis, arg_0, arg_1));
            if (elapsedMillis >= (long)this.warningInvocationTimeMs) {
                this.getLog().info("Task invocation took over " + this.warningInvocationTimeMs + "ms (taskType: " + taskModel.getImplementingClass() + ", stageType: " + stage.getType() + ", stageId: " + stage.getId() + ")");
            }
        }
        catch (Exception e) {
            this.getLog().warn("Failed to track result for stage: " + stage.getId() + ", task: " + taskModel.getId(), (Throwable)e);
        }
    }

    @NotNull
    public Class<RunTask> getMessageType() {
        return this.messageType;
    }

    private final void withTask(RunTask $this$withTask, Function3<? super StageExecution, ? super TaskExecution, ? super Task, Unit> block) {
        this.withTask((TaskLevel)$this$withTask, (Function2<? super StageExecution, ? super TaskExecution, Unit>)((Function2)new Function2<StageExecution, TaskExecution, Unit>(this, $this$withTask, block){
            final /* synthetic */ RunTaskHandler this$0;
            final /* synthetic */ RunTask $this_withTask;
            final /* synthetic */ Function3<StageExecution, TaskExecution, Task, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$this_withTask = $receiver2;
                this.$block = $block;
                super(2);
            }

            public final void invoke(@NotNull StageExecution stage, @NotNull TaskExecution taskModel) {
                Task task;
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                Intrinsics.checkNotNullParameter((Object)taskModel, (String)"taskModel");
                try {
                    task = RunTaskHandler.access$getTaskResolver$p(this.this$0).getTask(taskModel.getImplementingClass());
                }
                catch (TaskResolver.NoSuchTaskException e) {
                    Task task2;
                    try {
                        task2 = RunTaskHandler.access$getTaskResolver$p(this.this$0).getTask(this.$this_withTask.getTaskType());
                    }
                    catch (TaskResolver.NoSuchTaskException e2) {
                        Queue queue = this.this$0.getQueue();
                        StageLevel stageLevel = this.$this_withTask;
                        String string = this.$this_withTask.getTaskType().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskType.name");
                        queue.push((Message)new InvalidTaskType(stageLevel, string));
                        task2 = null;
                    }
                    task = task2;
                }
                Task task3 = task;
                if (task3 != null) {
                    task = task3;
                    Function3<StageExecution, TaskExecution, Task, Unit> function3 = this.$block;
                    boolean bl = false;
                    boolean bl2 = false;
                    Task it = task;
                    boolean bl3 = false;
                    function3.invoke((Object)stage, (Object)taskModel, (Object)it);
                }
            }
        }));
    }

    private final void withLocking(RunTask $this$withLocking, Runnable action) {
        RetriableLock.RetriableLockOptions lockOptions = new RetriableLock.RetriableLockOptions($this$withLocking.getStageId());
        Boolean lockAcquired = this.retriableLock.lock(lockOptions, action);
        if (!lockAcquired.booleanValue()) {
            this.getLog().warn("Failed to obtain lock for stage: {}. Pushing original message back to queue");
            this.getQueue().push((Message)$this$withLocking);
        }
    }

    private final TemporalAmount backoffPeriod(Task $this$backoffPeriod, TaskExecution taskModel, StageExecution stage) {
        TemporalAmount temporalAmount;
        Task task = $this$backoffPeriod;
        if (task instanceof RetryableTask) {
            Duration duration = Duration.ofMillis(RangesKt.coerceAtMost((long)this.retryableBackOffPeriod((RetryableTask)$this$backoffPeriod, taskModel, stage), (long)this.maxBackoff(this.taskExecutionInterceptors)));
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n        retrya\u2026ors.maxBackoff())\n      )");
            temporalAmount = duration;
        } else {
            Duration duration = Duration.ofMillis(1000L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(1000)");
            temporalAmount = duration;
        }
        return temporalAmount;
    }

    private final long retryableBackOffPeriod(RetryableTask $this$retryableBackOffPeriod, TaskExecution taskModel, StageExecution stage) {
        Object object = taskModel.getStartTime();
        Object[] objectArray = object == null ? Long.valueOf(0L) : object;
        long dynamicBackOffPeriod = $this$retryableBackOffPeriod.getDynamicBackoffPeriod(stage, Duration.ofMillis(System.currentTimeMillis() - ((Number)objectArray).longValue()));
        object = new Long[2];
        object[0] = dynamicBackOffPeriod;
        Object object2 = this.dynamicConfigService.getConfig(Long.TYPE, "tasks.global.backOffPeriod", (Object)dynamicBackOffPeriod);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"dynamicConfigService.get\u2026amicBackOffPeriod\n      )");
        object[1] = (Long)object2;
        List backOffs = CollectionsKt.mutableListOf((Object[])object);
        if ($this$retryableBackOffPeriod instanceof CloudProviderAware && ((CloudProviderAware)$this$retryableBackOffPeriod).hasCloudProvider(stage)) {
            object = this.dynamicConfigService.getConfig(Long.TYPE, "tasks." + ((CloudProviderAware)$this$retryableBackOffPeriod).getCloudProvider(stage) + ".backOffPeriod", (Object)dynamicBackOffPeriod);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dynamicConfigService.get\u2026icBackOffPeriod\n        )");
            backOffs.add(object);
            if (((CloudProviderAware)$this$retryableBackOffPeriod).hasCredentials(stage)) {
                object = this.dynamicConfigService.getConfig(Long.TYPE, "tasks." + ((CloudProviderAware)$this$retryableBackOffPeriod).getCloudProvider(stage) + "." + ((CloudProviderAware)$this$retryableBackOffPeriod).getCredentials(stage) + ".backOffPeriod", (Object)dynamicBackOffPeriod);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dynamicConfigService.get\u2026BackOffPeriod\n          )");
                backOffs.add(object);
            }
        }
        return (object = (Long)CollectionsKt.maxOrNull((Iterable)backOffs)) == null ? dynamicBackOffPeriod : (Long)object;
    }

    /*
     * WARNING - void declaration
     */
    private final long maxBackoff(List<? extends TaskExecutionInterceptor> $this$maxBackoff) {
        void $this$fold$iv;
        Iterable iterable = $this$maxBackoff;
        long initial$iv = Long.MAX_VALUE;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void interceptor;
            TaskExecutionInterceptor taskExecutionInterceptor = (TaskExecutionInterceptor)element$iv;
            long backoff = accumulator$iv;
            boolean bl = false;
            accumulator$iv = RangesKt.coerceAtMost((long)backoff, (long)interceptor.maxTaskBackoff());
        }
        return accumulator$iv;
    }

    private final String formatTimeout(long timeout) {
        String string = DurationFormatUtils.formatDurationWords((long)timeout, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDurationWords(timeout, true, true)");
        return string;
    }

    private final void checkForTimeout(Task $this$checkForTimeout, StageExecution stage, TaskExecution taskModel, Message message) {
        if (Intrinsics.areEqual((Object)stage.getType(), (Object)"restrictExecutionDuringTimeWindow")) {
            return;
        }
        this.checkForStageTimeout(stage);
        this.checkForTaskTimeout($this$checkForTimeout, taskModel, stage, message);
    }

    private final void checkForTaskTimeout(Task $this$checkForTaskTimeout, TaskExecution taskModel, StageExecution stage, Message message) {
        Instant startTime;
        if ($this$checkForTaskTimeout instanceof RetryableTask && (startTime = TimeKt.toInstant(taskModel.getStartTime())) != null) {
            Duration actualTimeout;
            Duration duration;
            PipelineExecution pipelineExecution = stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
            Duration pausedDuration = this.pausedDurationRelativeTo(pipelineExecution, startTime);
            Duration elapsedTime = Duration.between(startTime, this.clock.instant());
            if ($this$checkForTaskTimeout instanceof OverridableTimeoutRetryableTask && stage.getParentWithTimeout().isPresent()) {
                Object t = ((StageExecution)stage.getParentWithTimeout().get()).getTimeout().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"stage.parentWithTimeout.get().timeout.get()");
                duration = TimeKt.toDuration(((Number)t).longValue());
            } else {
                duration = actualTimeout = TimeKt.toDuration(((RetryableTask)$this$checkForTaskTimeout).getDynamicTimeout(stage));
            }
            if (elapsedTime.minus(pausedDuration).compareTo(actualTimeout) > 0) {
                String durationString = this.formatTimeout(elapsedTime.toMillis());
                StringBuilder msg = new StringBuilder($this$checkForTaskTimeout.getClass().getSimpleName() + " of stage " + stage.getName() + " timed out after " + durationString + ". ");
                msg.append("pausedDuration: " + this.formatTimeout(pausedDuration.toMillis()) + ", ");
                msg.append("elapsedTime: " + this.formatTimeout(elapsedTime.toMillis()) + ", ");
                msg.append("timeoutValue: " + this.formatTimeout(actualTimeout.toMillis()));
                this.getLog().info(msg.toString());
                throw new TimeoutException(msg.toString());
            }
        }
    }

    private final void checkForStageTimeout(StageExecution stage) {
        stage.getParentWithTimeout().ifPresent(arg_0 -> RunTaskHandler.checkForStageTimeout$lambda-3(this, stage, arg_0));
    }

    private StageExecution getExecutionWindow(StageExecution $this$executionWindow) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = StageKt.beforeStages((StageExecution)$this$executionWindow);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StageExecution it = (StageExecution)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"restrictExecutionDuringTimeWindow")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private Duration getDuration(StageExecution $this$duration) {
        StageExecution stageExecution = $this$duration;
        boolean bl = false;
        boolean bl2 = false;
        StageExecution $this$_get_duration__u24lambda_u2d5 = stageExecution;
        boolean bl3 = false;
        if ($this$_get_duration__u24lambda_u2d5.getStartTime() == null || $this$_get_duration__u24lambda_u2d5.getEndTime() == null) {
            throw new IllegalStateException("Only valid on completed stages");
        }
        Duration duration = Duration.between(TimeKt.toInstant($this$_get_duration__u24lambda_u2d5.getStartTime()), TimeKt.toInstant($this$_get_duration__u24lambda_u2d5.getEndTime()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"run {\n      if (startTim\u2026ndTime.toInstant())\n    }");
        return duration;
    }

    private final Counter timeoutCounter(Registry $this$timeoutCounter, ExecutionType executionType, String application, String stageType, String taskType) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"executionType", (Object)executionType.toString()), TuplesKt.to((Object)"application", (Object)application), TuplesKt.to((Object)"stageType", (Object)stageType), TuplesKt.to((Object)"taskType", (Object)taskType)};
        return $this$timeoutCounter.counter($this$timeoutCounter.createId("queue.task.timeouts").withTags(MapsKt.mapOf((Pair[])pairArray)));
    }

    private final Duration pausedDurationRelativeTo(PipelineExecution $this$pausedDurationRelativeTo, Instant instant) {
        Duration duration;
        PipelineExecution.PausedDetails pausedDetails = $this$pausedDurationRelativeTo.getPaused();
        if (pausedDetails != null) {
            Instant instant2 = TimeKt.toInstant(pausedDetails.getPauseTime());
            Duration duration2 = (instant2 == null ? false : instant2.isAfter(instant)) ? Duration.ofMillis(pausedDetails.getPausedMs()) : Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"{\n      if (pausedDetail\u2026)\n      } else ZERO\n    }");
            duration = duration2;
        } else {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            duration = duration3;
        }
        return duration;
    }

    private final void processTaskOutput(StageExecution $this$processTaskOutput, TaskResult result) {
        block4: {
            Map filteredOutputs;
            Map map;
            block3: {
                map = result.getOutputs();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"result.outputs");
                Map $this$filterKeys$iv = map;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                Map map2 = $this$filterKeys$iv;
                boolean bl = false;
                for (Map.Entry entry$iv : map2.entrySet()) {
                    String it = (String)entry$iv.getKey();
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)"stageTimeoutMs"))) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                filteredOutputs = result$iv;
                map = result.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"result.context");
                boolean bl3 = false;
                if (!map.isEmpty()) break block3;
                map = filteredOutputs;
                bl3 = false;
                if (!(!map.isEmpty())) break block4;
            }
            Map map3 = $this$processTaskOutput.getContext();
            map = result.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"result.context");
            map3.putAll(map);
            $this$processTaskOutput.getOutputs().putAll(filteredOutputs);
            this.getRepository().storeStage($this$processTaskOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withLoggingContext(StageExecution $this$withLoggingContext, TaskExecution taskModel, Function0<Unit> block) {
        try {
            MDC.put((String)"stageType", (String)$this$withLoggingContext.getType());
            MDC.put((String)"taskType", (String)taskModel.getImplementingClass());
            if (taskModel.getStartTime() != null) {
                MDC.put((String)"taskStartTime", (String)String.valueOf(taskModel.getStartTime()));
            }
            block.invoke();
        }
        finally {
            MDC.remove((String)"stageType");
            MDC.remove((String)"taskType");
            MDC.remove((String)"taskStartTime");
        }
    }

    private final TaskResult mergeOutputs(TaskResult $this$mergeOutputs, TaskResult taskResult) {
        Map it;
        if (taskResult == null) {
            return $this$mergeOutputs;
        }
        TaskResult.TaskResultBuilder taskResultBuilder = TaskResult.builder((ExecutionStatus)$this$mergeOutputs.getStatus());
        Map map = $this$mergeOutputs.getOutputs();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.outputs");
        map = MapsKt.toMutableMap((Map)map);
        boolean bl = false;
        boolean bl2 = false;
        Map map2 = map;
        TaskResult.TaskResultBuilder taskResultBuilder2 = taskResultBuilder;
        boolean bl3 = false;
        Map map3 = taskResult.getOutputs();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"taskResult.outputs");
        it.putAll(map3);
        Unit unit = Unit.INSTANCE;
        TaskResult.TaskResultBuilder taskResultBuilder3 = taskResultBuilder2.outputs(map);
        map = $this$mergeOutputs.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.context");
        map = MapsKt.toMutableMap((Map)map);
        bl = false;
        bl2 = false;
        it = map;
        taskResultBuilder2 = taskResultBuilder3;
        boolean bl4 = false;
        map3 = taskResult.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"taskResult.context");
        it.putAll(map3);
        unit = Unit.INSTANCE;
        TaskResult taskResult2 = taskResultBuilder2.context(map).build();
        Intrinsics.checkNotNullExpressionValue((Object)taskResult2, (String)"builder(this.status)\n   \u2026 }\n      )\n      .build()");
        return taskResult2;
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution stage) {
        return AuthenticationAware.DefaultImpls.retrieveAuthenticatedUser(this, stage);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    private static final void handle$lambda-0(RunTaskHandler this$0, RunTask $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        this$0.withTask($message, (Function3<? super StageExecution, ? super TaskExecution, ? super Task, Unit>)((Function3)new Function3<StageExecution, TaskExecution, Task, Unit>(this$0, $message){
            final /* synthetic */ RunTaskHandler this$0;
            final /* synthetic */ RunTask $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(3);
            }

            public final void invoke(@NotNull StageExecution origStage, @NotNull TaskExecution taskModel, @NotNull Task task) {
                Intrinsics.checkNotNullParameter((Object)origStage, (String)"origStage");
                Intrinsics.checkNotNullParameter((Object)taskModel, (String)"taskModel");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Ref.ObjectRef stage = new Ref.ObjectRef();
                stage.element = origStage;
                this.this$0.withAuth((StageExecution)stage.element, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, (Ref.ObjectRef<StageExecution>)stage, taskModel, task, this.$message){
                    final /* synthetic */ RunTaskHandler this$0;
                    final /* synthetic */ Ref.ObjectRef<StageExecution> $stage;
                    final /* synthetic */ TaskExecution $taskModel;
                    final /* synthetic */ Task $task;
                    final /* synthetic */ RunTask $message;
                    {
                        this.this$0 = $receiver;
                        this.$stage = $stage;
                        this.$taskModel = $taskModel;
                        this.$task = $task;
                        this.$message = $message;
                        super(0);
                    }

                    public final void invoke() {
                        RunTaskHandler.access$withLoggingContext(this.this$0, (StageExecution)this.$stage.element, this.$taskModel, (Function0)new Function0<Unit>(this.$task, this.this$0, this.$stage, this.$message, this.$taskModel){
                            final /* synthetic */ Task $task;
                            final /* synthetic */ RunTaskHandler this$0;
                            final /* synthetic */ Ref.ObjectRef<StageExecution> $stage;
                            final /* synthetic */ RunTask $message;
                            final /* synthetic */ TaskExecution $taskModel;
                            {
                                this.$task = $task;
                                this.this$0 = $receiver;
                                this.$stage = $stage;
                                this.$message = $message;
                                this.$taskModel = $taskModel;
                                super(0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                Object object;
                                Object $this$forEach$iv;
                                boolean $i$f$forEach2;
                                Ref.ObjectRef<StageExecution> objectRef;
                                Object[] objectArray;
                                Exception taskException;
                                TaskResult taskResult;
                                block30: {
                                    if (this.$task.getClass().isAnnotationPresent(Deprecated.class)) {
                                        this.this$0.getLog().warn("deprecated-task-run " + this.$task.getClass().getSimpleName());
                                    }
                                    long thisInvocationStartTimeMs = RunTaskHandler.access$getClock$p(this.this$0).millis();
                                    PipelineExecution pipelineExecution = ((StageExecution)this.$stage.element).getExecution();
                                    Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
                                    PipelineExecution execution = pipelineExecution;
                                    taskResult = null;
                                    taskException = null;
                                    try {
                                        boolean bl;
                                        TaskExecutionInterceptor t;
                                        Object element$iv2;
                                        block31: {
                                            Iterable iterable = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0);
                                            objectArray = this.$stage;
                                            objectRef = this.$task;
                                            $i$f$forEach2 = false;
                                            object = $this$forEach$iv.iterator();
                                            while (object.hasNext()) {
                                                element$iv2 = object.next();
                                                t = (TaskExecutionInterceptor)element$iv2;
                                                boolean bl2 = false;
                                                StageExecution stageExecution = t.beforeTaskExecution((Task)objectRef, (StageExecution)objectArray.element);
                                                Intrinsics.checkNotNullExpressionValue((Object)stageExecution, (String)"t.beforeTaskExecution(task, stage)");
                                                objectArray.element = stageExecution;
                                            }
                                            if (execution.isCanceled()) {
                                                $this$forEach$iv = this.$task.onCancelWithResult((StageExecution)this.$stage.element);
                                                if ($this$forEach$iv != null) {
                                                    objectArray = $this$forEach$iv;
                                                    objectRef = this.this$0;
                                                    Ref.ObjectRef<StageExecution> $i$f$forEach2 = this.$stage;
                                                    boolean bl3 = false;
                                                    boolean element$iv2 = false;
                                                    TaskResult $this$invoke_u24lambda_u2d1 = objectArray;
                                                    boolean bl4 = false;
                                                    RunTaskHandler.access$processTaskOutput((RunTaskHandler)objectRef, (StageExecution)$i$f$forEach2.element, $this$invoke_u24lambda_u2d1);
                                                }
                                                this.this$0.getQueue().push((Message)new CompleteTask(this.$message, ExecutionStatus.CANCELED));
                                                break block30;
                                            }
                                            if (execution.getStatus().isComplete()) {
                                                this.this$0.getQueue().push((Message)new CompleteTask(this.$message, ExecutionStatus.CANCELED));
                                                break block30;
                                            }
                                            if (execution.getStatus() == ExecutionStatus.PAUSED) {
                                                this.this$0.getQueue().push((Message)new PauseTask(this.$message));
                                                break block30;
                                            }
                                            if (StageKt.isManuallySkipped((StageExecution)((StageExecution)this.$stage.element))) {
                                                this.this$0.getQueue().push((Message)new CompleteTask(this.$message, ExecutionStatus.SKIPPED));
                                                break block30;
                                            }
                                            try {
                                                RunTaskHandler.access$checkForTimeout(this.this$0, this.$task, (StageExecution)this.$stage.element, this.$taskModel, this.$message);
                                            }
                                            catch (TimeoutException e) {
                                                Registry registry = RunTaskHandler.access$getRegistry$p(this.this$0);
                                                objectArray = ((StageExecution)this.$stage.element).getExecution().getType();
                                                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"stage.execution.type");
                                                TaskResult taskResult2 = objectArray;
                                                objectArray = ((StageExecution)this.$stage.element).getExecution().getApplication();
                                                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"stage.execution.application");
                                                Object object2 = objectArray;
                                                objectArray = ((StageExecution)this.$stage.element).getType();
                                                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"stage.type");
                                                Object object3 = objectArray;
                                                objectArray = this.$taskModel.getName();
                                                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"taskModel.name");
                                                RunTaskHandler.access$timeoutCounter(this.this$0, registry, (ExecutionType)taskResult2, (String)object2, (String)object3, (String)objectArray).increment();
                                                taskResult = this.$task.onTimeout((StageExecution)this.$stage.element);
                                                if (taskResult == null) {
                                                    throw e;
                                                }
                                                objectArray = new ExecutionStatus[]{ExecutionStatus.TERMINAL, ExecutionStatus.FAILED_CONTINUE};
                                                if (SetsKt.setOf((Object[])objectArray).contains(taskResult.getStatus())) break block31;
                                                this.this$0.getLog().error("Task " + this.$task.getClass().getName() + " returned invalid status (" + taskResult.getStatus() + ") for onTimeout");
                                                throw e;
                                            }
                                        }
                                        if (taskResult == null) {
                                            taskResult = this.$task.execute(this.this$0.withMergedContext((StageExecution)this.$stage.element));
                                            Iterable e = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0);
                                            objectArray = this.$task;
                                            objectRef = this.$stage;
                                            $i$f$forEach2 = false;
                                            object = $this$forEach$iv.iterator();
                                            while (object.hasNext()) {
                                                element$iv2 = object.next();
                                                t = (TaskExecutionInterceptor)element$iv2;
                                                bl = false;
                                                taskResult = t.afterTaskExecution((Task)objectArray, (StageExecution)objectRef.element, taskResult);
                                            }
                                        }
                                        TaskResult taskResult3 = taskResult;
                                        Intrinsics.checkNotNull(taskResult3);
                                        $this$forEach$iv = taskResult3;
                                        objectArray = this.this$0;
                                        objectRef = this.$stage;
                                        RunTask $i$f$forEach3 = this.$message;
                                        object = this.$task;
                                        element$iv2 = this.$taskModel;
                                        boolean t2 = false;
                                        bl = false;
                                        Object result = $this$forEach$iv;
                                        boolean bl5 = false;
                                        ExecutionStatus executionStatus = result.getStatus();
                                        int n = handle.1.WhenMappings.$EnumSwitchMapping$0[executionStatus.ordinal()];
                                        switch (n) {
                                            case 1: {
                                                RunTaskHandler.access$processTaskOutput((RunTaskHandler)objectArray, (StageExecution)objectRef.element, (TaskResult)result);
                                                objectArray.getQueue().push((Message)$i$f$forEach3, RunTaskHandler.access$backoffPeriod((RunTaskHandler)objectArray, (Task)object, element$iv2, (StageExecution)objectRef.element));
                                                StageExecution stageExecution = (StageExecution)objectRef.element;
                                                ExecutionStatus executionStatus2 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus2, (String)"result.status");
                                                RunTaskHandler.access$trackResult((RunTaskHandler)objectArray, stageExecution, thisInvocationStartTimeMs, element$iv2, executionStatus2);
                                                break;
                                            }
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: {
                                                RunTaskHandler.access$processTaskOutput((RunTaskHandler)objectArray, (StageExecution)objectRef.element, (TaskResult)result);
                                                Queue queue = objectArray.getQueue();
                                                TaskLevel taskLevel = $i$f$forEach3;
                                                ExecutionStatus executionStatus2 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus2, (String)"result.status");
                                                queue.push((Message)new CompleteTask(taskLevel, executionStatus2));
                                                StageExecution stageExecution = (StageExecution)objectRef.element;
                                                executionStatus2 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus2, (String)"result.status");
                                                RunTaskHandler.access$trackResult((RunTaskHandler)objectArray, stageExecution, thisInvocationStartTimeMs, element$iv2, executionStatus2);
                                                break;
                                            }
                                            case 7: {
                                                RunTaskHandler.access$processTaskOutput((RunTaskHandler)objectArray, (StageExecution)objectRef.element, RunTaskHandler.access$mergeOutputs((RunTaskHandler)objectArray, (TaskResult)result, object.onCancelWithResult((StageExecution)objectRef.element)));
                                                StageExecution stageExecution = (StageExecution)objectRef.element;
                                                ExecutionStatus executionStatus3 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus3, (String)"result.status");
                                                ExecutionStatus status = StageKt.failureStatus((StageExecution)stageExecution, (ExecutionStatus)executionStatus3);
                                                Queue queue = objectArray.getQueue();
                                                TaskLevel taskLevel = $i$f$forEach3;
                                                executionStatus3 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus3, (String)"result.status");
                                                queue.push((Message)new CompleteTask(taskLevel, status, executionStatus3));
                                                RunTaskHandler.access$trackResult((RunTaskHandler)objectArray, (StageExecution)objectRef.element, thisInvocationStartTimeMs, element$iv2, status);
                                                break;
                                            }
                                            case 8: {
                                                RunTaskHandler.access$processTaskOutput((RunTaskHandler)objectArray, (StageExecution)objectRef.element, (TaskResult)result);
                                                StageExecution stageExecution = (StageExecution)objectRef.element;
                                                ExecutionStatus executionStatus3 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus3, (String)"result.status");
                                                ExecutionStatus status = StageKt.failureStatus((StageExecution)stageExecution, (ExecutionStatus)executionStatus3);
                                                Queue queue = objectArray.getQueue();
                                                TaskLevel taskLevel = $i$f$forEach3;
                                                executionStatus3 = result.getStatus();
                                                Intrinsics.checkNotNullExpressionValue((Object)executionStatus3, (String)"result.status");
                                                queue.push((Message)new CompleteTask(taskLevel, status, executionStatus3));
                                                RunTaskHandler.access$trackResult((RunTaskHandler)objectArray, (StageExecution)objectRef.element, thisInvocationStartTimeMs, element$iv2, status);
                                                break;
                                            }
                                            default: {
                                                RunTaskHandler.access$processTaskOutput((RunTaskHandler)objectArray, (StageExecution)objectRef.element, (TaskResult)result);
                                                String string = "Unhandled task status " + result.getStatus();
                                                boolean bl6 = false;
                                                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                                            }
                                        }
                                    }
                                    catch (Exception e2) {
                                        void $this$forEach$iv2;
                                        Ref.ObjectRef<StageExecution> objectRef2;
                                        Ref.ObjectRef<StageExecution> exceptionDetails2;
                                        block32: {
                                            try {
                                                taskException = e2;
                                                objectRef2 = exceptionDetails2 = this.this$0.shouldRetry(RunTaskHandler.access$getExceptionHandlers$p(this.this$0), e2, this.$taskModel.getName());
                                                if (objectRef2 == null ? false : objectRef2.getShouldRetry()) {
                                                    this.this$0.getLog().warn("Error running " + this.$message.getTaskType().getSimpleName() + " for " + this.$message.getExecutionType() + "[" + this.$message.getExecutionId() + "]");
                                                    this.this$0.getQueue().push((Message)this.$message, RunTaskHandler.access$backoffPeriod(this.this$0, this.$task, this.$taskModel, (StageExecution)this.$stage.element));
                                                    RunTaskHandler.access$trackResult(this.this$0, (StageExecution)this.$stage.element, thisInvocationStartTimeMs, this.$taskModel, ExecutionStatus.RUNNING);
                                                    break block32;
                                                }
                                                if (e2 instanceof TimeoutException && Intrinsics.areEqual(((StageExecution)this.$stage.element).getContext().get("markSuccessfulOnTimeout"), (Object)true)) {
                                                    RunTaskHandler.access$trackResult(this.this$0, (StageExecution)this.$stage.element, thisInvocationStartTimeMs, this.$taskModel, ExecutionStatus.SUCCEEDED);
                                                    this.this$0.getQueue().push((Message)new CompleteTask(this.$message, ExecutionStatus.SUCCEEDED));
                                                    break block32;
                                                }
                                                if (!(e2 instanceof TimeoutException)) {
                                                    if (e2 instanceof UserException) {
                                                        this.this$0.getLog().warn(this.$message.getTaskType().getSimpleName() + " for " + this.$message.getExecutionType() + "[" + this.$message.getExecutionId() + "] failed, likely due to user error", (Throwable)e2);
                                                    } else {
                                                        this.this$0.getLog().error("Error running " + this.$message.getTaskType().getSimpleName() + " for " + this.$message.getExecutionType() + "[" + this.$message.getExecutionId() + "]", (Throwable)e2);
                                                    }
                                                }
                                                ExecutionStatus status = StageKt.failureStatus((StageExecution)((StageExecution)this.$stage.element), (ExecutionStatus)ExecutionStatus.TERMINAL);
                                                Map $i$f$forEach4 = ((StageExecution)this.$stage.element).getContext();
                                                Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach4, (String)"stage.context");
                                                Object object4 = "exception";
                                                boolean element$iv = false;
                                                $i$f$forEach4.put(object4, exceptionDetails2);
                                                $i$f$forEach4 = this.$taskModel.getTaskExceptionDetails();
                                                Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach4, (String)"taskModel.taskExceptionDetails");
                                                object4 = "exception";
                                                element$iv = false;
                                                $i$f$forEach4.put(object4, exceptionDetails2);
                                                this.this$0.getRepository().storeStage((StageExecution)this.$stage.element);
                                                this.this$0.getQueue().push((Message)new CompleteTask(this.$message, status, ExecutionStatus.TERMINAL));
                                                RunTaskHandler.access$trackResult(this.this$0, (StageExecution)this.$stage.element, thisInvocationStartTimeMs, this.$taskModel, status);
                                            }
                                            catch (Throwable throwable) {
                                                void $this$forEach$iv3;
                                                Iterable exceptionDetails2 = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0);
                                                Task task = this.$task;
                                                Ref.ObjectRef<StageExecution> objectRef3 = this.$stage;
                                                boolean $i$f$forEach5 = false;
                                                for (T element$iv : $this$forEach$iv3) {
                                                    TaskExecutionInterceptor t = (TaskExecutionInterceptor)element$iv;
                                                    boolean bl = false;
                                                    t.finallyAfterTaskExecution(task, (StageExecution)objectRef3.element, taskResult, taskException);
                                                }
                                                throw throwable;
                                            }
                                        }
                                        Iterable e2 = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0);
                                        exceptionDetails2 = this.$task;
                                        objectRef2 = this.$stage;
                                        boolean $i$f$forEach6 = false;
                                        for (E element$iv : $this$forEach$iv2) {
                                            TaskExecutionInterceptor t = (TaskExecutionInterceptor)element$iv;
                                            boolean bl = false;
                                            t.finallyAfterTaskExecution(exceptionDetails2, (StageExecution)objectRef2.element, taskResult, taskException);
                                        }
                                    }
                                }
                                $this$forEach$iv = RunTaskHandler.access$getTaskExecutionInterceptors$p(this.this$0);
                                objectArray = this.$task;
                                objectRef = this.$stage;
                                $i$f$forEach2 = false;
                                object = $this$forEach$iv.iterator();
                                while (object.hasNext()) {
                                    T element$iv = object.next();
                                    TaskExecutionInterceptor t = (TaskExecutionInterceptor)element$iv;
                                    boolean bl = false;
                                    t.finallyAfterTaskExecution((Task)objectArray, (StageExecution)objectRef.element, taskResult, taskException);
                                }
                            }
                        });
                    }
                }));
            }
        }));
    }

    private static final void trackResult$lambda-1(RunTaskHandler this$0, long $elapsedMillis, String name, List tags) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        this$0.registry.timer(name, (Iterable)tags).record($elapsedMillis, TimeUnit.MILLISECONDS);
    }

    private static final void checkForStageTimeout$lambda-3(RunTaskHandler this$0, StageExecution $stage, StageExecution it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stage, (String)"$stage");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Instant startTime = TimeKt.toInstant(it.getStartTime());
        if (startTime != null) {
            Duration elapsedTime = Duration.between(startTime, this$0.clock.instant());
            PipelineExecution pipelineExecution = $stage.getExecution();
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"stage.execution");
            Duration pausedDuration = this$0.pausedDurationRelativeTo(pipelineExecution, startTime);
            StageExecution stageExecution = this$0.getExecutionWindow($stage);
            Duration executionWindowDuration = stageExecution == null ? Duration.ZERO : this$0.getDuration(stageExecution);
            Object t = it.getTimeout().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"it.timeout.get()");
            Duration timeout = Duration.ofMillis(((Number)t).longValue());
            if (elapsedTime.minus(pausedDuration).minus(executionWindowDuration).compareTo(timeout) > 0) {
                throw new TimeoutException("Stage " + $stage.getName() + " timed out after " + this$0.formatTimeout(elapsedTime.toMillis()));
            }
        }
    }

    public static final /* synthetic */ TaskResolver access$getTaskResolver$p(RunTaskHandler $this) {
        return $this.taskResolver;
    }

    public static final /* synthetic */ void access$withLoggingContext(RunTaskHandler $this, StageExecution $receiver, TaskExecution taskModel, Function0 block) {
        $this.withLoggingContext($receiver, taskModel, (Function0<Unit>)block);
    }

    public static final /* synthetic */ Clock access$getClock$p(RunTaskHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ List access$getTaskExecutionInterceptors$p(RunTaskHandler $this) {
        return $this.taskExecutionInterceptors;
    }

    public static final /* synthetic */ void access$checkForTimeout(RunTaskHandler $this, Task $receiver, StageExecution stage, TaskExecution taskModel, Message message) {
        $this.checkForTimeout($receiver, stage, taskModel, message);
    }

    public static final /* synthetic */ Counter access$timeoutCounter(RunTaskHandler $this, Registry $receiver, ExecutionType executionType, String application, String stageType, String taskType) {
        return $this.timeoutCounter($receiver, executionType, application, stageType, taskType);
    }

    public static final /* synthetic */ Registry access$getRegistry$p(RunTaskHandler $this) {
        return $this.registry;
    }

    public static final /* synthetic */ List access$getExceptionHandlers$p(RunTaskHandler $this) {
        return $this.exceptionHandlers;
    }

    public static final /* synthetic */ TemporalAmount access$backoffPeriod(RunTaskHandler $this, Task $receiver, TaskExecution taskModel, StageExecution stage) {
        return $this.backoffPeriod($receiver, taskModel, stage);
    }

    public static final /* synthetic */ void access$trackResult(RunTaskHandler $this, StageExecution stage, long thisInvocationStartTimeMs, TaskExecution taskModel, ExecutionStatus status) {
        $this.trackResult(stage, thisInvocationStartTimeMs, taskModel, status);
    }

    public static final /* synthetic */ void access$processTaskOutput(RunTaskHandler $this, StageExecution $receiver, TaskResult result) {
        $this.processTaskOutput($receiver, result);
    }

    public static final /* synthetic */ TaskResult access$mergeOutputs(RunTaskHandler $this, TaskResult $receiver, TaskResult taskResult) {
        return $this.mergeOutputs($receiver, taskResult);
    }
}

