/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.ExecutionComplete;
import com.netflix.spinnaker.orca.events.ExecutionStarted;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.ext.ExecutionKt;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CancelExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartExecution;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\"*\u00020\u001fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8RX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/StartExecutionHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/StartExecution;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "handle", "", "message", "start", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "terminate", "isAfterStartTimeExpiry", "", "orca-queue"})
public class StartExecutionHandler
implements OrcaMessageHandler<StartExecution> {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final PendingExecutionService pendingExecutionService;
    @NotNull
    private final ApplicationEventPublisher publisher;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Class<StartExecution> messageType;

    public StartExecutionHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull PendingExecutionService pendingExecutionService, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"pendingExecutionService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.queue = queue;
        this.repository = repository;
        this.pendingExecutionService = pendingExecutionService;
        this.publisher = publisher;
        this.clock = clock;
        this.messageType = StartExecution.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public Class<StartExecution> getMessageType() {
        return this.messageType;
    }

    private Logger getLog() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        return logger;
    }

    public void handle(@NotNull StartExecution message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withExecution(message, (Function1<? super PipelineExecution, Unit>)((Function1)new Function1<PipelineExecution, Unit>(this, message){
            final /* synthetic */ StartExecutionHandler this$0;
            final /* synthetic */ StartExecution $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull PipelineExecution execution) {
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                if (execution.getStatus() == ExecutionStatus.NOT_STARTED && !execution.isCanceled()) {
                    if (this.this$0.shouldQueue(execution)) {
                        String string = execution.getPipelineConfigId();
                        if (string != null) {
                            String string2 = string;
                            StartExecutionHandler startExecutionHandler = this.this$0;
                            StartExecution startExecution = this.$message;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            Object[] objectArray = new Object[]{execution.getApplication(), execution.getName(), execution.getId()};
                            StartExecutionHandler.access$getLog(startExecutionHandler).info("Queueing {} {} {}", objectArray);
                            StartExecutionHandler.access$getPendingExecutionService$p(startExecutionHandler).enqueue(it, startExecution);
                        }
                    } else {
                        StartExecutionHandler.access$start(this.this$0, execution);
                    }
                } else {
                    StartExecutionHandler.access$terminate(this.this$0, execution);
                }
            }
        }));
    }

    private final void start(PipelineExecution execution) {
        if (this.isAfterStartTimeExpiry(execution)) {
            this.getLog().warn("Execution (type " + execution.getType() + ", id {}, application: {}) start was canceled becausestart time would be after defined start time expiry (now: " + this.clock.millis() + ", expiry: " + execution.getStartTimeExpiry() + ")", (Object)StructuredArguments.value((String)"executionId", (Object)execution.getId()), (Object)StructuredArguments.value((String)"application", (Object)execution.getApplication()));
            Queue queue = this.getQueue();
            Object object = execution.getType();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execution.type");
            ExecutionType executionType = object;
            object = execution.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execution.id");
            Object object2 = object;
            object = execution.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"execution.application");
            queue.push((Message)new CancelExecution(executionType, (String)object2, (String)object, "spinnaker", "Could not begin execution before start time expiry"));
        } else {
            List initialStages = ExecutionKt.initialStages((PipelineExecution)execution);
            if (initialStages.isEmpty()) {
                this.getLog().warn("No initial stages found (executionId: " + execution.getId() + ")");
                execution.updateStatus(ExecutionStatus.TERMINAL);
                this.getRepository().updateStatus(execution);
                this.publisher.publishEvent((ApplicationEvent)new ExecutionComplete((Object)this, execution));
            } else {
                execution.updateStatus(ExecutionStatus.RUNNING);
                this.getRepository().updateStatus(execution);
                Iterable $this$forEach$iv = initialStages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl = false;
                    Queue queue = this.getQueue();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    queue.push((Message)new StartStage(it));
                }
                this.publisher.publishEvent((ApplicationEvent)new ExecutionStarted((Object)this, execution));
            }
        }
    }

    private final void terminate(PipelineExecution execution) {
        if (execution.getStatus() == ExecutionStatus.CANCELED || execution.isCanceled()) {
            this.publisher.publishEvent((ApplicationEvent)new ExecutionComplete((Object)this, execution));
            String string = execution.getPipelineConfigId();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.getQueue().push((Message)new StartWaitingExecutions(it, !execution.isKeepWaitingPipelines()));
            }
        } else {
            this.getLog().warn("Execution (type: " + execution.getType() + ", id: {}, status: " + execution.getStatus() + ", application: {}) cannot be started unless state is NOT_STARTED. Ignoring StartExecution message.", (Object)StructuredArguments.value((String)"executionId", (Object)execution.getId()), (Object)StructuredArguments.value((String)"application", (Object)execution.getApplication()));
        }
    }

    private final boolean isAfterStartTimeExpiry(PipelineExecution $this$isAfterStartTimeExpiry) {
        boolean bl;
        Long l = $this$isAfterStartTimeExpiry.getStartTimeExpiry();
        if (l == null) {
            bl = false;
        } else {
            boolean bl2;
            Long l2 = l;
            boolean bl3 = false;
            boolean bl4 = false;
            long it = ((Number)l2).longValue();
            boolean bl5 = false;
            Instant instant = Instant.ofEpochMilli(it);
            bl = instant == null ? false : (bl2 = instant.isBefore(this.clock.instant()));
        }
        return bl;
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    public static final /* synthetic */ void access$start(StartExecutionHandler $this, PipelineExecution execution) {
        $this.start(execution);
    }

    public static final /* synthetic */ void access$terminate(StartExecutionHandler $this, PipelineExecution execution) {
        $this.terminate(execution);
    }

    public static final /* synthetic */ Logger access$getLog(StartExecutionHandler $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ PendingExecutionService access$getPendingExecutionService$p(StartExecutionHandler $this) {
        return $this.pendingExecutionService;
    }
}

