/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.metrics;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.notifications.AbstractPollingNotificationAgent;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.q.ZombieExecutionService;
import com.netflix.spinnaker.q.metrics.MonitorableQueue;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.logstash.logback.argument.StructuredArguments;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${queue.zombie-check.enabled:false}")
@ConditionalOnBean(value={MonitorableQueue.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0001\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00170\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u000bH\u0014J\b\u0010\u0019\u001a\u00020\u0015H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/netflix/spinnaker/orca/q/metrics/ZombieExecutionCheckingAgent;", "Lcom/netflix/spinnaker/orca/notifications/AbstractPollingNotificationAgent;", "zombieExecutionService", "Lcom/netflix/spinnaker/orca/q/ZombieExecutionService;", "registry", "Lcom/netflix/spectator/api/Registry;", "clock", "Ljava/time/Clock;", "conch", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "pollingIntervalMs", "", "zombieCheckEnabled", "", "zombieCheckCutoffMinutes", "queueEnabled", "(Lcom/netflix/spinnaker/orca/q/ZombieExecutionService;Lcom/netflix/spectator/api/Registry;Ljava/time/Clock;Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;JZJZ)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkForZombies", "", "getNotificationType", "", "getPollingInterval", "tick", "orca-queue"})
public class ZombieExecutionCheckingAgent
extends AbstractPollingNotificationAgent {
    @NotNull
    private final ZombieExecutionService zombieExecutionService;
    @NotNull
    private final Registry registry;
    @NotNull
    private final Clock clock;
    private final long pollingIntervalMs;
    private final boolean zombieCheckEnabled;
    private final long zombieCheckCutoffMinutes;
    private final boolean queueEnabled;
    private final Logger log;

    public ZombieExecutionCheckingAgent(@NotNull ZombieExecutionService zombieExecutionService, @NotNull Registry registry, @NotNull Clock clock, @NotNull NotificationClusterLock conch, @Value(value="${queue.zombie-check.interval-ms:3600000}") long pollingIntervalMs, @Value(value="${queue.zombie-check.enabled:false}") boolean zombieCheckEnabled, @Value(value="${queue.zombie-check.cutoff-minutes:10}") long zombieCheckCutoffMinutes, @Value(value="${keiko.queue.enabled:true}") boolean queueEnabled) {
        Intrinsics.checkNotNullParameter((Object)zombieExecutionService, (String)"zombieExecutionService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)conch, (String)"conch");
        super(conch);
        this.zombieExecutionService = zombieExecutionService;
        this.registry = registry;
        this.clock = clock;
        this.pollingIntervalMs = pollingIntervalMs;
        this.zombieCheckEnabled = zombieCheckEnabled;
        this.zombieCheckCutoffMinutes = zombieCheckCutoffMinutes;
        this.queueEnabled = queueEnabled;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    protected long getPollingInterval() {
        return this.pollingIntervalMs;
    }

    protected String getNotificationType() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void tick() {
        this.checkForZombies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForZombies() {
        if (!this.queueEnabled) {
            return;
        }
        if (!this.zombieCheckEnabled) {
            this.log.info("Not running zombie check: checkEnabled: " + this.zombieCheckEnabled);
            return;
        }
        try {
            MDC.put((String)"agentClass", (String)((Object)((Object)this)).getClass().getSimpleName());
            Instant startedAt = this.clock.instant();
            Duration duration = Duration.ofMinutes(this.zombieCheckCutoffMinutes);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(zombieCheckCutoffMinutes)");
            List<PipelineExecution> zombies = this.zombieExecutionService.findAllZombies(duration);
            this.log.info("Completed zombie check in " + Duration.between(startedAt, this.clock.instant()));
            Iterable $this$forEach$iv = zombies;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PipelineExecution it = (PipelineExecution)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{StructuredArguments.kv((String)"executionType", (Object)it.getType()), StructuredArguments.kv((String)"application", (Object)it.getApplication()), StructuredArguments.kv((String)"executionName", (Object)it.getName()), StructuredArguments.kv((String)"executionId", (Object)it.getId())};
                this.log.error("Found zombie {} {} {} {}", objectArray);
                Object[] objectArray2 = new Tag[]{(Tag)new BasicTag("application", it.getApplication()), (Tag)new BasicTag("type", it.getType().name())};
                List tags = CollectionsKt.mutableListOf((Object[])objectArray2);
                this.registry.counter("queue.zombies", (Iterable)tags).increment();
            }
        }
        finally {
            MDC.remove((String)"agentClass");
        }
    }
}

