/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.pending;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.DualPendingExecutionServiceConfiguration;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Primary
@Component
@ConditionalOnProperty(value={"queue.pending-execution-service.dual.enabled"})
@EnableConfigurationProperties(value={DualPendingExecutionServiceConfiguration.class})
@Order(value=-2147483648)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010!\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b0#H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0001X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0001X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/netflix/spinnaker/orca/q/pending/DualPendingExecutionService;", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "config", "Lcom/netflix/spinnaker/config/DualPendingExecutionServiceConfiguration;", "allPendingServices", "", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/netflix/spinnaker/config/DualPendingExecutionServiceConfiguration;Ljava/util/List;Lcom/netflix/spectator/api/Registry;)V", "hitFromSecondaryId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "previous", "getPrevious", "()Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "setPrevious", "(Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;)V", "primary", "getPrimary", "setPrimary", "depth", "", "pipelineConfigId", "", "enqueue", "", "message", "Lcom/netflix/spinnaker/q/Message;", "pendingIds", "popNewest", "popOldest", "purge", "callback", "Lkotlin/Function1;", "orca-queue"})
public class DualPendingExecutionService
implements PendingExecutionService {
    @NotNull
    private final Registry registry;
    private final Logger log;
    public PendingExecutionService primary;
    public PendingExecutionService previous;
    private Id hitFromSecondaryId;

    public DualPendingExecutionService(@NotNull DualPendingExecutionServiceConfiguration config, @NotNull List<? extends PendingExecutionService> allPendingServices, @NotNull Registry registry) {
        Object t;
        DualPendingExecutionService dualPendingExecutionService;
        Object element$iv2;
        block4: {
            Iterable $this$first$iv;
            boolean $i$f$first;
            PendingExecutionService it;
            block3: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Intrinsics.checkNotNullParameter(allPendingServices, (String)"allPendingServices");
                Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
                this.registry = registry;
                this.log = LoggerFactory.getLogger(this.getClass());
                this.hitFromSecondaryId = this.registry.createId("queue.pending.previous.pop");
                Iterable $this$forEach$iv = allPendingServices;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    it = (PendingExecutionService)element$iv2;
                    boolean bl = false;
                    this.log.info("Available PendingExecutionServices: " + it);
                }
                $this$forEach$iv = allPendingServices;
                dualPendingExecutionService = this;
                $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (PendingExecutionService)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getClass().getName(), (Object)config.getPrimaryClass())) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            t = element$iv2;
            dualPendingExecutionService.setPrimary((PendingExecutionService)t);
            $this$first$iv = allPendingServices;
            dualPendingExecutionService = this;
            $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                it = (PendingExecutionService)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getClass().getName(), (Object)config.getPreviousClass())) continue;
                break block4;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        t = element$iv2;
        dualPendingExecutionService.setPrevious((PendingExecutionService)t);
    }

    @NotNull
    public PendingExecutionService getPrimary() {
        PendingExecutionService pendingExecutionService = this.primary;
        if (pendingExecutionService != null) {
            return pendingExecutionService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"primary");
        return null;
    }

    public void setPrimary(@NotNull PendingExecutionService pendingExecutionService) {
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"<set-?>");
        this.primary = pendingExecutionService;
    }

    @NotNull
    public PendingExecutionService getPrevious() {
        PendingExecutionService pendingExecutionService = this.previous;
        if (pendingExecutionService != null) {
            return pendingExecutionService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"previous");
        return null;
    }

    public void setPrevious(@NotNull PendingExecutionService pendingExecutionService) {
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"<set-?>");
        this.previous = pendingExecutionService;
    }

    @Override
    public void enqueue(@NotNull String pipelineConfigId, @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getPrimary().enqueue(pipelineConfigId, message);
    }

    @Override
    @Nullable
    public Message popOldest(@NotNull String pipelineConfigId) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Message message2 = this.getPrevious().popOldest(pipelineConfigId);
        if (message2 != null) {
            this.registry.counter(this.hitFromSecondaryId).increment();
            this.log.debug("Found message from previous PendingExecutionService (" + this.getPrevious().getClass() + ") for " + pipelineConfigId);
            message = message2;
        } else {
            message = this.getPrimary().popOldest(pipelineConfigId);
        }
        return message;
    }

    @Override
    @Nullable
    public Message popNewest(@NotNull String pipelineConfigId) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Message message2 = this.getPrevious().popNewest(pipelineConfigId);
        if (message2 != null) {
            this.registry.counter(this.hitFromSecondaryId).increment();
            message = message2;
        } else {
            message = this.getPrimary().popNewest(pipelineConfigId);
        }
        return message;
    }

    @Override
    public void purge(@NotNull String pipelineConfigId, @NotNull Function1<? super Message, Unit> callback) {
        Message oldest;
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        do {
            Message message;
            if ((message = (oldest = this.popOldest(pipelineConfigId))) == null) continue;
            Message message2 = message;
            boolean bl = false;
            boolean bl2 = false;
            callback.invoke((Object)message2);
        } while (oldest != null);
    }

    @Override
    public int depth(@NotNull String pipelineConfigId) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        return this.getPrevious().depth(pipelineConfigId) + this.getPrimary().depth(pipelineConfigId);
    }

    @Override
    @NotNull
    public List<String> pendingIds() {
        throw new NotImplementedError("only implemented on SqlPendingExecutionService");
    }
}

