/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.admin;

import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.ext.StageKt;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CompleteExecution;
import com.netflix.spinnaker.orca.q.CompleteStage;
import com.netflix.spinnaker.orca.q.CompleteTask;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StartStage;
import com.netflix.spinnaker.orca.q.StartTask;
import com.netflix.spinnaker.orca.q.admin.Action;
import com.netflix.spinnaker.orca.q.admin.ActionContext;
import com.netflix.spinnaker.orca.q.admin.HydrateQueueInput;
import com.netflix.spinnaker.orca.q.admin.HydrateQueueOutput;
import com.netflix.spinnaker.orca.q.admin.ProcessedExecution;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import rx.Observable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J\u0011\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0096\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0012J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0011H\u0012J\f\u0010'\u001a\u00020\u0017*\u00020\u0011H\u0012J\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0)*\u00020\u0007H\u0012J\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0)*\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0012J\f\u0010-\u001a\u00020.*\u00020$H\u0012J\u0014\u0010-\u001a\u00020.*\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\u0012\u0012\u000e\b\u0001\u0012\n \r*\u0004\u0018\u00010\u00100\u00100\u000f*\u00020\u00118RX\u0092\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006/"}, d2={"Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueCommand;", "Lkotlin/Function1;", "Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueInput;", "Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueOutput;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/TaskResolver;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "type", "Ljava/lang/Class;", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "getType$annotations", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)V", "getType", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)Ljava/lang/Class;", "inTimeWindow", "", "input", "execution", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "invoke", "p1", "processExecution", "Lcom/netflix/spinnaker/orca/q/admin/ProcessedExecution;", "processExecution$orca_queue", "processStage", "", "Lcom/netflix/spinnaker/orca/q/admin/Action;", "stage", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "processTask", "task", "isRetryable", "retrieveRunning", "Lrx/Observable;", "retrieveSingleRunning", "executionId", "", "toActionContext", "Lcom/netflix/spinnaker/orca/q/admin/ActionContext;", "orca-queue"})
public class HydrateQueueCommand
implements Function1<HydrateQueueInput, HydrateQueueOutput> {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository executionRepository;
    @NotNull
    private final TaskResolver taskResolver;
    private final Logger log;

    public HydrateQueueCommand(@NotNull Queue queue, @NotNull ExecutionRepository executionRepository, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        this.queue = queue;
        this.executionRepository = executionRepository;
        this.taskResolver = taskResolver;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HydrateQueueOutput invoke(@NotNull HydrateQueueInput p1) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Function1 pInTimeWindow2 = (Function1)new Function1<PipelineExecution, Boolean>(this, p1){
            final /* synthetic */ HydrateQueueCommand this$0;
            final /* synthetic */ HydrateQueueInput $p1;
            {
                this.this$0 = $receiver;
                this.$p1 = $p1;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PipelineExecution execution) {
                Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
                return HydrateQueueCommand.access$inTimeWindow(this.this$0, this.$p1, execution);
            }
        };
        List targets = p1.getExecutionId() == null ? (List)this.retrieveRunning(this.executionRepository).filter(arg_0 -> HydrateQueueCommand.invoke$lambda-0(pInTimeWindow2, arg_0)).toList().toBlocking().first() : (List)this.retrieveSingleRunning(this.executionRepository, p1.getExecutionId()).toList().toBlocking().first();
        boolean bl = p1.getDryRun();
        Intrinsics.checkNotNullExpressionValue((Object)targets, (String)"targets");
        Iterable iterable = targets;
        boolean bl2 = bl;
        boolean $i$f$map = false;
        Iterator<Map.Entry<String, ProcessedExecution>> iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PipelineExecution pipelineExecution = (PipelineExecution)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(TuplesKt.to((Object)string, (Object)this.processExecution$orca_queue((PipelineExecution)it)));
        }
        collection = (List)destination$iv$iv;
        Map map = MapsKt.toMap((Iterable)collection);
        boolean bl4 = bl2;
        HydrateQueueOutput output = new HydrateQueueOutput(bl4, map);
        this.log.info("Hydrating queue from execution repository state (dryRun: " + output.getDryRun() + ")");
        Map<String, ProcessedExecution> $this$forEach$iv = output.getExecutions();
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ProcessedExecution> element$iv;
            Map.Entry<String, ProcessedExecution> it = element$iv = iterator.next();
            boolean bl5 = false;
            if (it.getValue().getCanApply()) {
                this.log.info("Hydrating execution " + it.getKey());
                Iterable $this$forEach$iv2 = it.getValue().getActions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Message message;
                    Action action = (Action)element$iv2;
                    boolean bl6 = false;
                    if (action.getMessage() == null) continue;
                    Message message2 = message;
                    boolean bl7 = false;
                    this.log.info("Hydrating execution " + it.getKey() + " with " + message2 + ": " + action.getFullDescription());
                    if (output.getDryRun()) continue;
                    this.queue.push(message2);
                }
                continue;
            }
            String reason = it.getValue().getActions().isEmpty() ? "could not determine any actions" : "unknown reasons";
            this.log.warn("Could not hydrate execution " + it.getKey() + ": " + reason);
            Iterable $this$forEach$iv3 = it.getValue().getActions();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Action action = (Action)element$iv3;
                boolean bl8 = false;
                this.log.warn("Aborted execution " + it.getKey() + " hydration: " + action.getFullDescription());
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProcessedExecution processExecution$orca_queue(@NotNull PipelineExecution execution) {
        boolean bl;
        List actions;
        block7: {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            Iterator $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
            actions = new ArrayList();
            List list = execution.getStages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution.stages");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                StageExecution it = (StageExecution)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getParent() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                StageExecution it = (StageExecution)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                actions.addAll((Collection)this.processStage(it));
            }
            List list2 = execution.getStages();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"execution.stages");
            Iterable $this$filter$iv2 = list2;
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                StageExecution it = (StageExecution)element$iv$iv;
                boolean bl4 = false;
                if (!it.downstreamStages().isEmpty()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List leafStages = (List)destination$iv$iv2;
            Iterable $this$all$iv = leafStages;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv3 : $this$all$iv) {
                    StageExecution it = (StageExecution)element$iv3;
                    boolean bl5 = false;
                    if (it.getStatus().isComplete()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            actions.add(new Action("All leaf stages are complete but execution is still running", new CompleteExecution(execution), new ActionContext(null, null, null, null, null, null, 63, null)));
        }
        return new ProcessedExecution(execution.getStartTime(), CollectionsKt.toList((Iterable)actions));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<Action> processStage(StageExecution stage) {
        block25: {
            block20: {
                block24: {
                    if (stage.getStatus() != ExecutionStatus.NOT_STARTED) break block24;
                    if (StageKt.allUpstreamStagesComplete((StageExecution)stage)) {
                        return CollectionsKt.listOf((Object)new Action("Stage is not started but all upstream stages are complete", new StartStage(stage), this.toActionContext(stage)));
                    }
                    if (StageKt.isInitial((StageExecution)stage)) {
                        return CollectionsKt.listOf((Object)new Action("Stage is not started but is an initial stage", new StartStage(stage), this.toActionContext(stage)));
                    }
                    break block25;
                }
                if (stage.getStatus() != ExecutionStatus.RUNNING) break block25;
                actions = new ArrayList<E>();
                beforeStages = StageKt.beforeStages((StageExecution)stage);
                $this$forEach$iv = beforeStages;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (StageExecution)element$iv /* !! */ ;
                    $i$a$-forEach-HydrateQueueCommand$processStage$1 = false;
                    actions.addAll((Collection)this.processStage(it));
                }
                if (beforeStages.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = beforeStages;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (StageExecution)element$iv /* !! */ ;
                        $i$a$-all-HydrateQueueCommand$processStage$2 = false;
                        if (it.getStatus().isComplete()) continue;
                        v0 = false;
                        break block20;
                    }
                    v0 = true;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                block21: {
                    v1 = stage.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"stage.tasks");
                    $this$firstOrNull$iv = v1;
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (TaskExecution)element$iv;
                        $i$a$-firstOrNull-HydrateQueueCommand$processStage$task$1 = false;
                        var11_17 = new ExecutionStatus[]{ExecutionStatus.NOT_STARTED, ExecutionStatus.RUNNING};
                        if (!CollectionsKt.listOf((Object[])var11_17).contains(it.getStatus())) continue;
                        v2 = element$iv;
                        break block21;
                    }
                    v2 = null;
                }
                task = v2;
                if (task != null) {
                    actions.add(this.processTask(stage, task));
                }
            } else {
                block22: {
                    v3 = stage.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"stage.tasks");
                    $this$all$iv = v3;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v4 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (TaskExecution)element$iv /* !! */ ;
                            $i$a$-all-HydrateQueueCommand$processStage$3 = false;
                            if (it.getStatus().isComplete()) continue;
                            v4 = false;
                            break block22;
                        }
                        v4 = true;
                    }
                }
                if (v4) {
                    $this$forEach$iv = StageKt.afterStages((StageExecution)stage);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (StageExecution)element$iv /* !! */ ;
                        $i$a$-forEach-HydrateQueueCommand$processStage$4 = false;
                        actions.addAll((Collection)this.processStage(it));
                    }
                }
            }
            if (StageKt.allBeforeStagesSuccessful((StageExecution)stage)) {
                block23: {
                    v5 = stage.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"stage.tasks");
                    $this$all$iv = v5;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v6 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            it = (TaskExecution)element$iv /* !! */ ;
                            $i$a$-all-HydrateQueueCommand$processStage$5 = false;
                            if (it.getStatus().isComplete()) continue;
                            v6 = false;
                            break block23;
                        }
                        v6 = true;
                    }
                }
                if (v6 && StageKt.allAfterStagesSuccessful((StageExecution)stage)) {
                    actions.add(new Action("All tasks and known synthetic stages are complete", new CompleteStage(stage), this.toActionContext(stage)));
                }
            }
            return CollectionsKt.toList((Iterable)actions);
        }
        return CollectionsKt.emptyList();
    }

    private Action processTask(StageExecution stage, TaskExecution task) {
        Action action;
        if (task.getStatus() == ExecutionStatus.RUNNING) {
            if (this.isRetryable(task)) {
                ExecutionType executionType = stage.getExecution().getType();
                Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"stage.execution.type");
                String string = stage.getExecution().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.execution.id");
                String string2 = stage.getExecution().getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stage.execution.application");
                String string3 = stage.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stage.id");
                String string4 = task.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"task.id");
                action = new Action("Task is running and is retryable", new RunTask(executionType, string, string2, string3, string4, this.getType(task)), this.toActionContext(task, stage));
            } else {
                action = new Action("Task is running but is not retryable", null, this.toActionContext(task, stage));
            }
        } else if (task.getStatus() == ExecutionStatus.NOT_STARTED) {
            action = new Action("Task has not started yet", new StartTask(stage, task), this.toActionContext(task, stage));
        } else if (task.getStatus().isComplete()) {
            ExecutionType executionType = stage.getExecution().getType();
            Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"stage.execution.type");
            String string = stage.getExecution().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.execution.id");
            String string5 = stage.getExecution().getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"stage.execution.application");
            String string6 = stage.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"stage.id");
            String string7 = task.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"task.id");
            ExecutionStatus executionStatus = task.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"task.status");
            action = new Action("Task is complete", new CompleteTask(executionType, string, string5, string6, string7, executionStatus, null), this.toActionContext(task, stage));
        } else {
            action = new Action("Could not determine an action to take", null, this.toActionContext(task, stage));
        }
        return action;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inTimeWindow(HydrateQueueInput input, PipelineExecution execution) {
        boolean bl;
        Long l = execution.getStartTime();
        if (l == null) return true;
        long it = ((Number)l).longValue();
        boolean bl2 = false;
        Instant instant = Instant.ofEpochMilli(it);
        if (instant == null) return true;
        Instant it2 = instant;
        boolean bl3 = false;
        Instant instant2 = input.getStart();
        if (instant2 != null) {
            if (instant2.isBefore(it2)) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        Instant instant3 = input.getEnd();
        if (instant3 == null) return true;
        if (!instant3.isAfter(it2)) return true;
        return false;
    }

    private Observable<PipelineExecution> retrieveRunning(ExecutionRepository $this$retrieveRunning) {
        ExecutionStatus[] executionStatusArray = new ExecutionStatus[]{ExecutionStatus.RUNNING};
        Observable observable = $this$retrieveRunning.retrieve(ExecutionType.ORCHESTRATION, new ExecutionRepository.ExecutionCriteria().setStatuses(executionStatusArray));
        executionStatusArray = new ExecutionStatus[]{ExecutionStatus.RUNNING};
        Observable observable2 = Observable.merge((Observable)observable, (Observable)$this$retrieveRunning.retrieve(ExecutionType.PIPELINE, new ExecutionRepository.ExecutionCriteria().setStatuses(executionStatusArray)));
        Intrinsics.checkNotNullExpressionValue((Object)observable2, (String)"merge(\n      retrieve(Ex\u2026tStatuses(RUNNING))\n    )");
        return observable2;
    }

    private Observable<PipelineExecution> retrieveSingleRunning(ExecutionRepository $this$retrieveSingleRunning, String executionId) {
        Observable observable;
        PipelineExecution pipelineExecution;
        try {
            pipelineExecution = $this$retrieveSingleRunning.retrieve(ExecutionType.ORCHESTRATION, executionId);
        }
        catch (ExecutionNotFoundException e) {
            PipelineExecution pipelineExecution2;
            try {
                pipelineExecution2 = $this$retrieveSingleRunning.retrieve(ExecutionType.PIPELINE, executionId);
            }
            catch (ExecutionNotFoundException e2) {
                pipelineExecution2 = null;
            }
            pipelineExecution = pipelineExecution2;
        }
        PipelineExecution execution = pipelineExecution;
        if (execution == null || execution.getStatus() != ExecutionStatus.RUNNING) {
            Observable observable2 = Observable.empty();
            observable = observable2;
            Intrinsics.checkNotNullExpressionValue((Object)observable2, (String)"{\n      rx.Observable.em\u2026ipelineExecution>()\n    }");
        } else {
            Observable observable3 = Observable.just((Object)execution);
            observable = observable3;
            Intrinsics.checkNotNullExpressionValue((Object)observable3, (String)"{\n      rx.Observable.just(execution)\n    }");
        }
        return observable;
    }

    private Class<? extends Task> getType(TaskExecution $this$type) {
        Class clazz = this.taskResolver.getTaskClass($this$type.getImplementingClass());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"taskResolver.getTaskClass(implementingClass)");
        return clazz;
    }

    private static /* synthetic */ void getType$annotations(TaskExecution taskExecution) {
    }

    private boolean isRetryable(TaskExecution $this$isRetryable) {
        return RetryableTask.class.isAssignableFrom(this.getType($this$isRetryable));
    }

    private ActionContext toActionContext(StageExecution $this$toActionContext) {
        return new ActionContext($this$toActionContext.getId(), $this$toActionContext.getType(), $this$toActionContext.getStartTime(), null, null, null, 56, null);
    }

    private ActionContext toActionContext(TaskExecution $this$toActionContext, StageExecution stage) {
        return ActionContext.copy$default(this.toActionContext(stage), null, null, null, $this$toActionContext.getId(), $this$toActionContext.getName(), $this$toActionContext.getStartTime(), 7, null);
    }

    private static final Boolean invoke$lambda-0(Function1 $tmp0, PipelineExecution p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ boolean access$inTimeWindow(HydrateQueueCommand $this, HydrateQueueInput input, PipelineExecution execution) {
        return $this.inTimeWindow(input, execution);
    }
}

