/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.q.Message;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="runTask")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bB/\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000fB=\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0006\u0012\u0006\u0010\u0013\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u0014J\t\u0010\"\u001a\u00020\u0011H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\u0006H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u00c6\u0003JM\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0019\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00060"}, d2={"Lcom/netflix/spinnaker/orca/q/RunTask;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/TaskLevel;", "message", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "taskId", "", "taskType", "Ljava/lang/Class;", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "(Lcom/netflix/spinnaker/orca/q/StageLevel;Ljava/lang/String;Ljava/lang/Class;)V", "(Lcom/netflix/spinnaker/orca/q/TaskLevel;Ljava/lang/Class;)V", "source", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "stageId", "(Lcom/netflix/spinnaker/orca/q/ExecutionLevel;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "ackTimeoutMs", "", "getAckTimeoutMs", "()Ljava/lang/Long;", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStageId", "getTaskId", "getTaskType", "()Ljava/lang/Class;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class RunTask
extends Message
implements TaskLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @NotNull
    private final String stageId;
    @NotNull
    private final String taskId;
    @NotNull
    private final Class<? extends Task> taskType;
    private final long ackTimeoutMs;

    public RunTask(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId, @NotNull String taskId, @NotNull Class<? extends Task> taskType) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter(taskType, (String)"taskType");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.stageId = stageId;
        this.taskId = taskId;
        this.taskType = taskType;
        this.ackTimeoutMs = Duration.ofMinutes(10L).toMillis();
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public String getStageId() {
        return this.stageId;
    }

    @Override
    @NotNull
    public String getTaskId() {
        return this.taskId;
    }

    @NotNull
    public final Class<? extends Task> getTaskType() {
        return this.taskType;
    }

    @NotNull
    public Long getAckTimeoutMs() {
        return this.ackTimeoutMs;
    }

    public RunTask(@NotNull StageLevel message, @NotNull String taskId, @NotNull Class<? extends Task> taskType) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter(taskType, (String)"taskType");
        this(message.getExecutionType(), message.getExecutionId(), message.getApplication(), message.getStageId(), taskId, taskType);
    }

    public RunTask(@NotNull TaskLevel message, @NotNull Class<? extends Task> taskType) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(taskType, (String)"taskType");
        this(message.getExecutionType(), message.getExecutionId(), message.getApplication(), message.getStageId(), message.getTaskId(), taskType);
    }

    public RunTask(@NotNull ExecutionLevel source, @NotNull String stageId, @NotNull String taskId, @NotNull Class<? extends Task> taskType) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter(taskType, (String)"taskType");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), stageId, taskId, taskType);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final String component4() {
        return this.getStageId();
    }

    @NotNull
    public final String component5() {
        return this.getTaskId();
    }

    @NotNull
    public final Class<? extends Task> component6() {
        return this.taskType;
    }

    @NotNull
    public final RunTask copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId, @NotNull String taskId, @NotNull Class<? extends Task> taskType) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter(taskType, (String)"taskType");
        return new RunTask(executionType, executionId, application, stageId, taskId, taskType);
    }

    public static /* synthetic */ RunTask copy$default(RunTask runTask, ExecutionType executionType, String string, String string2, String string3, String string4, Class clazz, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = runTask.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = runTask.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = runTask.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = runTask.getStageId();
        }
        if ((n & 0x10) != 0) {
            string4 = runTask.getTaskId();
        }
        if ((n & 0x20) != 0) {
            clazz = runTask.taskType;
        }
        return runTask.copy(executionType, string, string2, string3, string4, clazz);
    }

    @NotNull
    public String toString() {
        return "RunTask(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", stageId=" + this.getStageId() + ", taskId=" + this.getTaskId() + ", taskType=" + this.taskType + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        result = result * 31 + this.getStageId().hashCode();
        result = result * 31 + this.getTaskId().hashCode();
        result = result * 31 + this.taskType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RunTask)) {
            return false;
        }
        RunTask runTask = (RunTask)other;
        if (this.getExecutionType() != runTask.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)runTask.getExecutionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getApplication(), (Object)runTask.getApplication())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStageId(), (Object)runTask.getStageId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTaskId(), (Object)runTask.getTaskId())) {
            return false;
        }
        return Intrinsics.areEqual(this.taskType, runTask.taskType);
    }
}

