/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="startTask")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB-\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0006\u0012\u0006\u0010\u0013\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0014J\t\u0010\u001c\u001a\u00020\u0011H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006)"}, d2={"Lcom/netflix/spinnaker/orca/q/StartTask;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/TaskLevel;", "source", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "stageId", "", "taskId", "(Lcom/netflix/spinnaker/orca/q/ExecutionLevel;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/netflix/spinnaker/orca/q/StageLevel;", "(Lcom/netflix/spinnaker/orca/q/StageLevel;Ljava/lang/String;)V", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;Ljava/lang/String;)V", "task", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getStageId", "getTaskId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class StartTask
extends Message
implements TaskLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;
    @NotNull
    private final String stageId;
    @NotNull
    private final String taskId;

    public StartTask(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId, @NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
        this.stageId = stageId;
        this.taskId = taskId;
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    @Override
    @NotNull
    public String getStageId() {
        return this.stageId;
    }

    @Override
    @NotNull
    public String getTaskId() {
        return this.taskId;
    }

    public StartTask(@NotNull ExecutionLevel source, @NotNull String stageId, @NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication(), stageId, taskId);
    }

    public StartTask(@NotNull StageLevel source, @NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this(source, source.getStageId(), taskId);
    }

    public StartTask(@NotNull StageExecution source, @NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        ExecutionType executionType = source.getExecution().getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"source.execution.type");
        String string = source.getExecution().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.execution.id");
        String string2 = source.getExecution().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"source.execution.application");
        String string3 = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"source.id");
        this(executionType, string, string2, string3, taskId);
    }

    public StartTask(@NotNull StageExecution source, @NotNull TaskExecution task) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ExecutionType executionType = source.getExecution().getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"source.execution.type");
        String string = source.getExecution().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.execution.id");
        String string2 = source.getExecution().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"source.execution.application");
        String string3 = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"source.id");
        String string4 = task.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"task.id");
        this(executionType, string, string2, string3, string4);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final String component4() {
        return this.getStageId();
    }

    @NotNull
    public final String component5() {
        return this.getTaskId();
    }

    @NotNull
    public final StartTask copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application, @NotNull String stageId, @NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)stageId, (String)"stageId");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        return new StartTask(executionType, executionId, application, stageId, taskId);
    }

    public static /* synthetic */ StartTask copy$default(StartTask startTask, ExecutionType executionType, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = startTask.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = startTask.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = startTask.getApplication();
        }
        if ((n & 8) != 0) {
            string3 = startTask.getStageId();
        }
        if ((n & 0x10) != 0) {
            string4 = startTask.getTaskId();
        }
        return startTask.copy(executionType, string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "StartTask(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ", stageId=" + this.getStageId() + ", taskId=" + this.getTaskId() + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        result = result * 31 + this.getStageId().hashCode();
        result = result * 31 + this.getTaskId().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StartTask)) {
            return false;
        }
        StartTask startTask = (StartTask)other;
        if (this.getExecutionType() != startTask.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)startTask.getExecutionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getApplication(), (Object)startTask.getApplication())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStageId(), (Object)startTask.getStageId())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getTaskId(), (Object)startTask.getTaskId());
    }
}

