/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.admin.web;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.ZombieExecutionService;
import com.netflix.spinnaker.orca.q.admin.HydrateQueueCommand;
import com.netflix.spinnaker.orca.q.admin.HydrateQueueInput;
import com.netflix.spinnaker.orca.q.admin.HydrateQueueOutput;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import javassist.NotFoundException;
import javax.ws.rs.QueryParam;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/admin/queue"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\b\u0010\u0010\u001a\u00020\u0006H\u0012J=\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0017\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u000f2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0017\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\u00020\u001a2\b\b\u0001\u0010\u001f\u001a\u00020\u000f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u0016H\u0017\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u001a2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0019\u0010#\u001a\u00020\u001a2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u0016H\u0017\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020'H\u0017R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/netflix/spinnaker/orca/q/admin/web/QueueAdminController;", "", "hydrateCommand", "Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueCommand;", "zombieExecutionService", "Ljava/util/Optional;", "Lcom/netflix/spinnaker/orca/q/ZombieExecutionService;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "(Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueCommand;Ljava/util/Optional;Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;)V", "getPipelineOrOrchestration", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "executionId", "", "getZombieExecutionService", "hydrateQueue", "Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueOutput;", "dryRun", "", "startMs", "", "endMs", "(Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Lcom/netflix/spinnaker/orca/q/admin/HydrateQueueOutput;", "kickPendingExecutions", "", "pipelineConfigId", "purge", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "killApplicationZombies", "application", "minimumActivity", "(Ljava/lang/String;Ljava/lang/Long;)V", "killZombie", "killZombies", "(Ljava/lang/Long;)V", "pushMessageIntoQueue", "message", "Lcom/netflix/spinnaker/q/Message;", "orca-queue"})
public class QueueAdminController {
    @NotNull
    private final HydrateQueueCommand hydrateCommand;
    @NotNull
    private final Optional<ZombieExecutionService> zombieExecutionService;
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository executionRepository;

    public QueueAdminController(@NotNull HydrateQueueCommand hydrateCommand, @NotNull Optional<ZombieExecutionService> zombieExecutionService, @NotNull Queue queue, @NotNull ExecutionRepository executionRepository) {
        Intrinsics.checkNotNullParameter((Object)hydrateCommand, (String)"hydrateCommand");
        Intrinsics.checkNotNullParameter(zombieExecutionService, (String)"zombieExecutionService");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        this.hydrateCommand = hydrateCommand;
        this.zombieExecutionService = zombieExecutionService;
        this.queue = queue;
        this.executionRepository = executionRepository;
    }

    @PostMapping(value={"/hydrate"})
    @NotNull
    public HydrateQueueOutput hydrateQueue(@QueryParam(value="dryRun") @Nullable Boolean dryRun, @QueryParam(value="executionId") @Nullable String executionId, @QueryParam(value="startMs") @Nullable Long startMs, @QueryParam(value="endMs") @Nullable Long endMs) {
        Long l = startMs;
        Long l2 = endMs;
        Boolean bl = dryRun;
        return this.hydrateCommand.invoke(new HydrateQueueInput(executionId, l != null ? Instant.ofEpochMilli(l) : null, l2 != null ? Instant.ofEpochMilli(l2) : null, bl != null ? bl : true));
    }

    @PostMapping(value={"/zombies:kill"})
    public void killZombies(@QueryParam(value="minimumActivity") @Nullable Long minimumActivity) {
        ZombieExecutionService zombieExecutionService = this.getZombieExecutionService();
        Long l = minimumActivity;
        Duration duration = Duration.ofMinutes(l != null ? l : 60L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(minimumActivity ?: 60)");
        zombieExecutionService.killZombies(duration);
    }

    @PostMapping(value={"/zombies/{executionId}:kill"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void killZombie(@PathVariable @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.getZombieExecutionService().killZombie(this.getPipelineOrOrchestration(executionId));
    }

    @PostMapping(value={"/zombies/application/{application}:kill"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void killApplicationZombies(@PathVariable @NotNull String application, @QueryParam(value="minimumActivity") @Nullable Long minimumActivity) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        ZombieExecutionService zombieExecutionService = this.getZombieExecutionService();
        Long l = minimumActivity;
        Duration duration = Duration.ofMinutes(l != null ? l : 60L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(minimumActivity ?: 60)");
        zombieExecutionService.killZombies(application, duration);
    }

    @PostMapping(value={"kickPending"})
    public void kickPendingExecutions(@QueryParam(value="pipelineConfigId") @NotNull String pipelineConfigId, @QueryParam(value="purge") @Nullable Boolean purge) {
        Intrinsics.checkNotNullParameter((Object)pipelineConfigId, (String)"pipelineConfigId");
        Boolean bl = purge;
        this.queue.push((Message)new StartWaitingExecutions(pipelineConfigId, bl != null ? bl : false));
    }

    @PostMapping(value={"pushMessage"})
    public void pushMessageIntoQueue(@RequestBody @NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.queue.push(message);
    }

    private ZombieExecutionService getZombieExecutionService() {
        ZombieExecutionService zombieExecutionService = this.zombieExecutionService.orElseThrow(QueueAdminController::getZombieExecutionService$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)zombieExecutionService, (String)"zombieExecutionService\n \u2026tance.\"\n        )\n      }");
        return zombieExecutionService;
    }

    private PipelineExecution getPipelineOrOrchestration(String executionId) {
        PipelineExecution pipelineExecution;
        try {
            PipelineExecution pipelineExecution2 = this.executionRepository.retrieve(ExecutionType.PIPELINE, executionId);
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution2, (String)"{\n      executionReposit\u2026ELINE, executionId)\n    }");
            pipelineExecution = pipelineExecution2;
        }
        catch (NotFoundException e) {
            PipelineExecution pipelineExecution3 = this.executionRepository.retrieve(ExecutionType.ORCHESTRATION, executionId);
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution3, (String)"{\n      executionReposit\u2026ATION, executionId)\n    }");
            pipelineExecution = pipelineExecution3;
        }
        return pipelineExecution;
    }

    private static final IllegalStateException getZombieExecutionService$lambda-0() {
        return new IllegalStateException("Zombie management is unavailable. This is likely due to the queue not being enabled on this instance.");
    }
}

