/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.audit;

import com.netflix.spinnaker.kork.common.Header;
import com.netflix.spinnaker.orca.q.ApplicationAware;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.MessageHandler;
import com.netflix.spinnaker.q.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/orca/q/audit/ExecutionTrackingMessageHandlerPostProcessor;", "Lorg/springframework/beans/factory/config/BeanPostProcessor;", "()V", "postProcessAfterInitialization", "", "bean", "beanName", "", "postProcessBeforeInitialization", "ExecutionTrackingMessageHandlerProxy", "orca-queue"})
public class ExecutionTrackingMessageHandlerPostProcessor
implements BeanPostProcessor {
    @NotNull
    public Object postProcessBeforeInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        return bean;
    }

    @NotNull
    public Object postProcessAfterInitialization(@NotNull Object bean, @NotNull String beanName) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        return bean instanceof MessageHandler ? new ExecutionTrackingMessageHandlerProxy((MessageHandler)bean) : bean;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/netflix/spinnaker/orca/q/audit/ExecutionTrackingMessageHandlerPostProcessor$ExecutionTrackingMessageHandlerProxy;", "M", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/q/MessageHandler;", "delegate", "(Lcom/netflix/spinnaker/q/MessageHandler;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "handle", "", "message", "(Lcom/netflix/spinnaker/q/Message;)V", "invoke", "orca-queue"})
    private static final class ExecutionTrackingMessageHandlerProxy<M extends Message>
    implements MessageHandler<M> {
        @NotNull
        private final MessageHandler<M> delegate;

        public ExecutionTrackingMessageHandlerProxy(@NotNull MessageHandler<M> delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public Class<M> getMessageType() {
            return this.delegate.getMessageType();
        }

        @NotNull
        public Queue getQueue() {
            return this.delegate.getQueue();
        }

        public void handle(@NotNull M message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            this.delegate.handle(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(@NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                Message message2 = message;
                if (message2 instanceof TaskLevel) {
                    MDC.put((String)Header.EXECUTION_ID.getHeader(), (String)(((TaskLevel)message).getExecutionId() + ":" + ((TaskLevel)message).getStageId() + ":" + ((TaskLevel)message).getTaskId()));
                } else if (message2 instanceof StageLevel) {
                    MDC.put((String)Header.EXECUTION_ID.getHeader(), (String)(((StageLevel)message).getExecutionId() + ":" + ((StageLevel)message).getStageId()));
                } else if (message2 instanceof ExecutionLevel) {
                    MDC.put((String)Header.EXECUTION_ID.getHeader(), (String)((ExecutionLevel)message).getExecutionId());
                }
                if (message instanceof ApplicationAware) {
                    MDC.put((String)Header.APPLICATION.getHeader(), (String)((ApplicationAware)message).getApplication());
                }
                this.delegate.invoke(message);
            }
            finally {
                MDC.remove((String)Header.EXECUTION_ID.getHeader());
                MDC.remove((String)Header.APPLICATION.getHeader());
            }
        }
    }
}

