/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.CancellableStage;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.StageNavigator;
import com.netflix.spinnaker.orca.q.CancelStage;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RescheduleExecution;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.AuthenticationAware;
import com.netflix.spinnaker.orca.q.handler.CancelStageHandler;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.handler.StageBuilderAware;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n  *\u0004\u0018\u00010\u001f0\u001f0\u0013*\u00020!8RX\u0092\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/CancelStageHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/CancelStage;", "Lcom/netflix/spinnaker/orca/q/handler/StageBuilderAware;", "Lcom/netflix/spinnaker/orca/q/handler/AuthenticationAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "stageNavigator", "Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "executor", "Ljava/util/concurrent/Executor;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;Ljava/util/concurrent/Executor;Lcom/netflix/spinnaker/orca/TaskResolver;)V", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "getStageNavigator", "()Lcom/netflix/spinnaker/orca/pipeline/util/StageNavigator;", "type", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "kotlin.jvm.PlatformType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "getType$annotations", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)V", "getType", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)Ljava/lang/Class;", "handle", "", "message", "orca-queue"})
public class CancelStageHandler
implements OrcaMessageHandler<CancelStage>,
StageBuilderAware,
AuthenticationAware {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final StageNavigator stageNavigator;
    @NotNull
    private final Executor executor;
    @NotNull
    private final TaskResolver taskResolver;
    @NotNull
    private final Class<CancelStage> messageType;

    public CancelStageHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @NotNull StageNavigator stageNavigator, @Qualifier(value="cancellableStageExecutor") @NotNull Executor executor, @NotNull TaskResolver taskResolver) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)stageNavigator, (String)"stageNavigator");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        this.queue = queue;
        this.repository = repository;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.stageNavigator = stageNavigator;
        this.executor = executor;
        this.taskResolver = taskResolver;
        this.messageType = CancelStage.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    @Override
    @NotNull
    public StageNavigator getStageNavigator() {
        return this.stageNavigator;
    }

    @NotNull
    public Class<CancelStage> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull CancelStage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withStage(message, (Function1<? super StageExecution, Unit>)((Function1)new Function1<StageExecution, Unit>(this){
            final /* synthetic */ CancelStageHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull StageExecution stage) {
                CancelStageHandler cancelStageHandler;
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                if (stage.getStatus() == ExecutionStatus.RUNNING) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    List list = stage.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stage.tasks");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TaskExecution it = (TaskExecution)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getStatus() == ExecutionStatus.RUNNING)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    cancelStageHandler = this.this$0;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        TaskExecution it = (TaskExecution)element$iv;
                        boolean bl = false;
                        Queue queue = cancelStageHandler.getQueue();
                        ExecutionType executionType = stage.getExecution().getType();
                        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"stage.execution.type");
                        String string = stage.getExecution().getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stage.execution.id");
                        String string2 = stage.getExecution().getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stage.execution.application");
                        String string3 = stage.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stage.id");
                        String string4 = it.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.id");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        queue.reschedule((Message)new RunTask(executionType, string, string2, string3, string4, CancelStageHandler.access$getType(cancelStageHandler, it)));
                    }
                }
                if (stage.getStatus().isHalt()) {
                    StageDefinitionBuilder stageDefinitionBuilder = this.this$0.builder(stage);
                    cancelStageHandler = this.this$0;
                    StageDefinitionBuilder builder = stageDefinitionBuilder;
                    boolean bl = false;
                    if (builder instanceof CancellableStage) {
                        Callable cancellationClosure2 = AuthenticatedRequest.propagate(() -> handle.1.invoke$lambda-4$lambda-2(cancelStageHandler, stage, builder));
                        CancelStageHandler.access$getExecutor$p(cancelStageHandler).execute(() -> handle.1.invoke$lambda-4$lambda-3(cancellationClosure2));
                    }
                }
            }

            private static final Unit invoke$lambda-4$lambda-2(CancelStageHandler this$0, StageExecution $stage, StageDefinitionBuilder $builder) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$stage, (String)"$stage");
                Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
                this$0.withAuth($stage, (Function0<Unit>)((Function0)new Function0<Unit>($builder, $stage){
                    final /* synthetic */ StageDefinitionBuilder $builder;
                    final /* synthetic */ StageExecution $stage;
                    {
                        this.$builder = $builder;
                        this.$stage = $stage;
                        super(0);
                    }

                    public final void invoke() {
                        ((CancellableStage)this.$builder).cancel(this.$stage);
                    }
                }));
                if (StringsKt.equals((String)$stage.getType(), (String)"pipeline", (boolean)true) && $stage.getContext().containsKey("executionId")) {
                    String childId;
                    V v = $stage.getContext().get("executionId");
                    String string = childId = v instanceof String ? (String)v : null;
                    if (childId != null) {
                        PipelineExecution pipelineExecution = this$0.getRepository().retrieve(ExecutionType.PIPELINE, childId);
                        Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"repository.retrieve(PIPELINE, childId)");
                        PipelineExecution child = pipelineExecution;
                        this$0.getQueue().push((Message)new RescheduleExecution(child));
                    }
                }
                return Unit.INSTANCE;
            }

            private static final void invoke$lambda-4$lambda-3(Callable $cancellationClosure) {
                $cancellationClosure.call();
            }
        }));
    }

    private Class<? extends Task> getType(TaskExecution $this$type) {
        Class clazz = this.taskResolver.getTaskClass($this$type.getImplementingClass());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"taskResolver.getTaskClass(implementingClass)");
        return clazz;
    }

    private static /* synthetic */ void getType$annotations(TaskExecution taskExecution) {
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public StageDefinitionBuilder builder(@NotNull StageExecution $this$builder) {
        return StageBuilderAware.DefaultImpls.builder(this, $this$builder);
    }

    @Override
    public void withAuth(@NotNull StageExecution $this$withAuth, @NotNull Function0<Unit> block) {
        AuthenticationAware.DefaultImpls.withAuth(this, $this$withAuth, block);
    }

    @Override
    @Nullable
    public PipelineExecution.AuthenticationDetails retrieveAuthenticatedUser(@NotNull StageExecution stage) {
        return AuthenticationAware.DefaultImpls.retrieveAuthenticatedUser(this, stage);
    }

    public static final /* synthetic */ Class access$getType(CancelStageHandler $this, TaskExecution $receiver) {
        return $this.getType($receiver);
    }

    public static final /* synthetic */ Executor access$getExecutor$p(CancelStageHandler $this) {
        return $this.executor;
    }
}

