/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.TaskResolver;
import com.netflix.spinnaker.orca.api.pipeline.SkippableTask;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.events.TaskComplete;
import com.netflix.spinnaker.orca.events.TaskStarted;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.StageDefinitionBuilderFactory;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.util.ContextParameterProcessor;
import com.netflix.spinnaker.orca.q.CompleteTask;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RunTask;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartTask;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.ExpressionAware;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.time.Clock;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0002H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020#H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00020\"*\u00020#8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R.\u0010&\u001a\u0012\u0012\u000e\b\u0001\u0012\n '*\u0004\u0018\u00010\"0\"0\u0018*\u00020#8RX\u0092\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u00062"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/StartTaskHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/StartTask;", "Lcom/netflix/spinnaker/orca/q/handler/ExpressionAware;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "contextParameterProcessor", "Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "stageDefinitionBuilderFactory", "Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "taskResolver", "Lcom/netflix/spinnaker/orca/TaskResolver;", "clock", "Ljava/time/Clock;", "environment", "Lorg/springframework/core/env/Environment;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;Lorg/springframework/context/ApplicationEventPublisher;Lcom/netflix/spinnaker/orca/TaskResolver;Ljava/time/Clock;Lorg/springframework/core/env/Environment;)V", "getContextParameterProcessor", "()Lcom/netflix/spinnaker/orca/pipeline/util/ContextParameterProcessor;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "getStageDefinitionBuilderFactory", "()Lcom/netflix/spinnaker/orca/pipeline/StageDefinitionBuilderFactory;", "instance", "Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "getInstance", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)Lcom/netflix/spinnaker/orca/api/pipeline/Task;", "type", "kotlin.jvm.PlatformType", "getType$annotations", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)V", "getType", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;)Ljava/lang/Class;", "handle", "", "message", "isTaskEnabled", "", "task", "orca-queue"})
public class StartTaskHandler
implements OrcaMessageHandler<StartTask>,
ExpressionAware {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final ContextParameterProcessor contextParameterProcessor;
    @NotNull
    private final StageDefinitionBuilderFactory stageDefinitionBuilderFactory;
    @NotNull
    private final ApplicationEventPublisher publisher;
    @NotNull
    private final TaskResolver taskResolver;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Environment environment;
    @NotNull
    private final Class<StartTask> messageType;

    public StartTaskHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull ContextParameterProcessor contextParameterProcessor, @NotNull StageDefinitionBuilderFactory stageDefinitionBuilderFactory, @Qualifier(value="queueEventPublisher") @NotNull ApplicationEventPublisher publisher, @NotNull TaskResolver taskResolver, @NotNull Clock clock, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)contextParameterProcessor, (String)"contextParameterProcessor");
        Intrinsics.checkNotNullParameter((Object)stageDefinitionBuilderFactory, (String)"stageDefinitionBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)taskResolver, (String)"taskResolver");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.queue = queue;
        this.repository = repository;
        this.contextParameterProcessor = contextParameterProcessor;
        this.stageDefinitionBuilderFactory = stageDefinitionBuilderFactory;
        this.publisher = publisher;
        this.taskResolver = taskResolver;
        this.clock = clock;
        this.environment = environment;
        this.messageType = StartTask.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public ContextParameterProcessor getContextParameterProcessor() {
        return this.contextParameterProcessor;
    }

    @Override
    @NotNull
    public StageDefinitionBuilderFactory getStageDefinitionBuilderFactory() {
        return this.stageDefinitionBuilderFactory;
    }

    public void handle(@NotNull StartTask message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.withTask(message, (Function2<? super StageExecution, ? super TaskExecution, Unit>)((Function2)new Function2<StageExecution, TaskExecution, Unit>(this, message){
            final /* synthetic */ StartTaskHandler this$0;
            final /* synthetic */ StartTask $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2);
            }

            public final void invoke(@NotNull StageExecution stage, @NotNull TaskExecution task) {
                Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                if (this.this$0.isTaskEnabled(task)) {
                    task.setStatus(ExecutionStatus.RUNNING);
                    task.setStartTime(Long.valueOf(StartTaskHandler.access$getClock$p(this.this$0).millis()));
                    StageExecution mergedContextStage = this.this$0.withMergedContext(stage);
                    this.this$0.getRepository().storeStage(mergedContextStage);
                    Queue queue = this.this$0.getQueue();
                    StageLevel stageLevel = this.$message;
                    String string = task.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.id");
                    queue.push((Message)new RunTask(stageLevel, string, StartTaskHandler.access$getType(this.this$0, task)));
                    StartTaskHandler.access$getPublisher$p(this.this$0).publishEvent((ApplicationEvent)new TaskStarted((Object)this.this$0, mergedContextStage, task));
                } else {
                    task.setStatus(ExecutionStatus.SKIPPED);
                    StageExecution mergedContextStage = this.this$0.withMergedContext(stage);
                    this.this$0.getRepository().storeStage(mergedContextStage);
                    this.this$0.getQueue().push((Message)new CompleteTask(this.$message, ExecutionStatus.SKIPPED));
                    StartTaskHandler.access$getPublisher$p(this.this$0).publishEvent((ApplicationEvent)new TaskComplete((Object)this.this$0, mergedContextStage, task));
                }
            }
        }));
    }

    public boolean isTaskEnabled(@NotNull TaskExecution task) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.getInstance(task) instanceof SkippableTask) {
            SkippableTask asSkippableTask = (SkippableTask)this.getInstance(task);
            Boolean enabled = (Boolean)this.environment.getProperty(asSkippableTask.isEnabledPropertyName(), Boolean.TYPE, (Object)true);
            if (!enabled.booleanValue()) {
                this.getLog().debug("Skipping task.type=" + this.getType(task) + " because " + asSkippableTask.isEnabledPropertyName() + "=false");
            }
            Boolean bl2 = enabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"{\n        val asSkippabl\u2026}\n        enabled\n      }");
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public Class<StartTask> getMessageType() {
        return this.messageType;
    }

    private Class<? extends Task> getType(TaskExecution $this$type) {
        Class clazz = this.taskResolver.getTaskClass($this$type.getImplementingClass());
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"taskResolver.getTaskClass(implementingClass)");
        return clazz;
    }

    private static /* synthetic */ void getType$annotations(TaskExecution taskExecution) {
    }

    private Task getInstance(TaskExecution $this$instance) {
        Task task = this.taskResolver.getTask($this$instance.getImplementingClass());
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"taskResolver.getTask(implementingClass)");
        return task;
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return ExpressionAware.DefaultImpls.getLog(this);
    }

    @Override
    @NotNull
    public StageExecution withMergedContext(@NotNull StageExecution $this$withMergedContext) {
        return ExpressionAware.DefaultImpls.withMergedContext(this, $this$withMergedContext);
    }

    @Override
    public void includeExpressionEvaluationSummary(@NotNull StageExecution $this$includeExpressionEvaluationSummary) {
        ExpressionAware.DefaultImpls.includeExpressionEvaluationSummary(this, $this$includeExpressionEvaluationSummary);
    }

    @Override
    public boolean hasFailedExpressions(@NotNull StageExecution $this$hasFailedExpressions) {
        return ExpressionAware.DefaultImpls.hasFailedExpressions(this, $this$hasFailedExpressions);
    }

    @Override
    public boolean shouldFailOnFailedExpressionEvaluation(@NotNull StageExecution $this$shouldFailOnFailedExpressionEvaluation) {
        return ExpressionAware.DefaultImpls.shouldFailOnFailedExpressionEvaluation(this, $this$shouldFailOnFailedExpressionEvaluation);
    }

    public static final /* synthetic */ Clock access$getClock$p(StartTaskHandler $this) {
        return $this.clock;
    }

    public static final /* synthetic */ Class access$getType(StartTaskHandler $this, TaskExecution $receiver) {
        return $this.getType($receiver);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(StartTaskHandler $this) {
        return $this.publisher;
    }
}

