/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q.handler;

import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import com.netflix.spinnaker.orca.exceptions.ExceptionHandler;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.q.CancelExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.orca.q.RestartStage;
import com.netflix.spinnaker.orca.q.StageLevel;
import com.netflix.spinnaker.orca.q.StartExecution;
import com.netflix.spinnaker.orca.q.StartWaitingExecutions;
import com.netflix.spinnaker.orca.q.TaskLevel;
import com.netflix.spinnaker.orca.q.handler.OrcaMessageHandler;
import com.netflix.spinnaker.orca.q.pending.PendingExecutionService;
import com.netflix.spinnaker.q.Message;
import com.netflix.spinnaker.q.Queue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u0014\u0010\n\u001a\u00020\u000b8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/netflix/spinnaker/orca/q/handler/StartWaitingExecutionsHandler;", "Lcom/netflix/spinnaker/orca/q/handler/OrcaMessageHandler;", "Lcom/netflix/spinnaker/orca/q/StartWaitingExecutions;", "queue", "Lcom/netflix/spinnaker/q/Queue;", "repository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "pendingExecutionService", "Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;", "(Lcom/netflix/spinnaker/q/Queue;Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/orca/q/pending/PendingExecutionService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "messageType", "Ljava/lang/Class;", "getMessageType", "()Ljava/lang/Class;", "getQueue", "()Lcom/netflix/spinnaker/q/Queue;", "getRepository", "()Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "handle", "", "message", "orca-queue"})
public class StartWaitingExecutionsHandler
implements OrcaMessageHandler<StartWaitingExecutions> {
    @NotNull
    private final Queue queue;
    @NotNull
    private final ExecutionRepository repository;
    @NotNull
    private final PendingExecutionService pendingExecutionService;
    @NotNull
    private final Class<StartWaitingExecutions> messageType;

    public StartWaitingExecutionsHandler(@NotNull Queue queue, @NotNull ExecutionRepository repository, @NotNull PendingExecutionService pendingExecutionService) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pendingExecutionService, (String)"pendingExecutionService");
        this.queue = queue;
        this.repository = repository;
        this.pendingExecutionService = pendingExecutionService;
        this.messageType = StartWaitingExecutions.class;
    }

    @NotNull
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public ExecutionRepository getRepository() {
        return this.repository;
    }

    private Logger getLog() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass)");
        return logger;
    }

    @NotNull
    public Class<StartWaitingExecutions> getMessageType() {
        return this.messageType;
    }

    public void handle(@NotNull StartWaitingExecutions message) {
        block3: {
            Message message2;
            Message message3;
            Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
            if (message.getPurgeQueue()) {
                Message message4 = this.pendingExecutionService.popNewest(message.getPipelineConfigId());
                boolean bl = false;
                this.pendingExecutionService.purge(message.getPipelineConfigId(), (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(this){
                    final /* synthetic */ StartWaitingExecutionsHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Message purgedMessage) {
                        Intrinsics.checkNotNullParameter((Object)purgedMessage, (String)"purgedMessage");
                        Message message = purgedMessage;
                        if (message instanceof StartExecution) {
                            StartWaitingExecutionsHandler.access$getLog(this.this$0).info("Dropping queued pipeline {} {}", (Object)((StartExecution)purgedMessage).getApplication(), (Object)((StartExecution)purgedMessage).getExecutionId());
                            this.this$0.getQueue().push((Message)new CancelExecution((ExecutionLevel)purgedMessage, "spinnaker", "This execution was queued but then canceled because a newer queued execution superceded it. This pipeline is configured to automatically cancel waiting executions."));
                        } else if (message instanceof RestartStage) {
                            StartWaitingExecutionsHandler.access$getLog(this.this$0).info("Cancelling restart of {} {}", (Object)((RestartStage)purgedMessage).getApplication(), (Object)((RestartStage)purgedMessage).getExecutionId());
                        }
                    }
                }));
                message3 = message4;
            } else {
                message3 = message2 = this.pendingExecutionService.popOldest(message.getPipelineConfigId());
            }
            if (message2 == null) break block3;
            Message it = message2;
            boolean bl = false;
            if (it instanceof ExecutionLevel) {
                this.getLog().info("Starting queued pipeline {} {} {}", (Object)((ExecutionLevel)it).getApplication(), (Object)((ExecutionLevel)it).getExecutionId());
            }
            this.getQueue().push(it);
        }
    }

    @Override
    @Nullable
    public ExceptionHandler.Response shouldRetry(@NotNull Collection<? extends ExceptionHandler> $this$shouldRetry, @NotNull Exception ex, @Nullable String taskName) {
        return OrcaMessageHandler.DefaultImpls.shouldRetry(this, $this$shouldRetry, ex, taskName);
    }

    @Override
    public void withTask(@NotNull TaskLevel $this$withTask, @NotNull Function2<? super StageExecution, ? super TaskExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withTask(this, $this$withTask, block);
    }

    @Override
    public void withStage(@NotNull StageLevel $this$withStage, @NotNull Function1<? super StageExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withStage(this, $this$withStage, block);
    }

    @Override
    public void withExecution(@NotNull ExecutionLevel $this$withExecution, @NotNull Function1<? super PipelineExecution, Unit> block) {
        OrcaMessageHandler.DefaultImpls.withExecution(this, $this$withExecution, block);
    }

    @Override
    public void startNext(@NotNull StageExecution $this$startNext) {
        OrcaMessageHandler.DefaultImpls.startNext(this, $this$startNext);
    }

    @Override
    public boolean shouldQueue(@NotNull PipelineExecution $this$shouldQueue) {
        return OrcaMessageHandler.DefaultImpls.shouldQueue(this, $this$shouldQueue);
    }

    public void invoke(@NotNull Message message) {
        OrcaMessageHandler.DefaultImpls.invoke(this, message);
    }

    public static final /* synthetic */ Logger access$getLog(StartWaitingExecutionsHandler $this) {
        return $this.getLog();
    }
}

