/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.q;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.q.ExecutionLevel;
import com.netflix.spinnaker.q.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="completeExecution")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/netflix/spinnaker/orca/q/CompleteExecution;", "Lcom/netflix/spinnaker/q/Message;", "Lcom/netflix/spinnaker/orca/q/ExecutionLevel;", "source", "(Lcom/netflix/spinnaker/orca/q/ExecutionLevel;)V", "Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/PipelineExecution;)V", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "executionId", "", "application", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getExecutionId", "getExecutionType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "orca-queue"})
public final class CompleteExecution
extends Message
implements ExecutionLevel {
    @NotNull
    private final ExecutionType executionType;
    @NotNull
    private final String executionId;
    @NotNull
    private final String application;

    public CompleteExecution(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.executionType = executionType;
        this.executionId = executionId;
        this.application = application;
    }

    @Override
    @NotNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NotNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    @NotNull
    public String getApplication() {
        return this.application;
    }

    public CompleteExecution(@NotNull ExecutionLevel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source.getExecutionType(), source.getExecutionId(), source.getApplication());
    }

    public CompleteExecution(@NotNull PipelineExecution source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ExecutionType executionType = source.getType();
        Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"source.type");
        String string = source.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.id");
        String string2 = source.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"source.application");
        this(executionType, string, string2);
    }

    @NotNull
    public final ExecutionType component1() {
        return this.getExecutionType();
    }

    @NotNull
    public final String component2() {
        return this.getExecutionId();
    }

    @NotNull
    public final String component3() {
        return this.getApplication();
    }

    @NotNull
    public final CompleteExecution copy(@NotNull ExecutionType executionType, @NotNull String executionId, @NotNull String application) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new CompleteExecution(executionType, executionId, application);
    }

    public static /* synthetic */ CompleteExecution copy$default(CompleteExecution completeExecution, ExecutionType executionType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            executionType = completeExecution.getExecutionType();
        }
        if ((n & 2) != 0) {
            string = completeExecution.getExecutionId();
        }
        if ((n & 4) != 0) {
            string2 = completeExecution.getApplication();
        }
        return completeExecution.copy(executionType, string, string2);
    }

    @NotNull
    public String toString() {
        return "CompleteExecution(executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", application=" + this.getApplication() + ")";
    }

    public int hashCode() {
        int result = this.getExecutionType().hashCode();
        result = result * 31 + this.getExecutionId().hashCode();
        result = result * 31 + this.getApplication().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompleteExecution)) {
            return false;
        }
        CompleteExecution completeExecution = (CompleteExecution)other;
        if (this.getExecutionType() != completeExecution.getExecutionType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getExecutionId(), (Object)completeExecution.getExecutionId())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getApplication(), (Object)completeExecution.getApplication());
    }
}

