/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.telemetry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.RedisClientSelector;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.events.ExecutionComplete;
import com.netflix.spinnaker.orca.events.ExecutionEvent;
import com.netflix.spinnaker.orca.events.ExecutionStarted;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.persistence.StageSerializationException;
import com.netflix.spinnaker.orca.telemetry.RedisActiveExecutionsMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import redis.clients.jedis.commands.JedisCommands;

@Component
@ConditionalOnProperty(value={"monitor.active-executions.redis"}, matchIfMissing=true)
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\f\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u000fH\u0012J\u001c\u0010%\u001a\u0016\u0012\u0004\u0012\u00020' \u0013*\n\u0012\u0004\u0012\u00020'\u0018\u00010&0&H\u0012J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\"H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020'0&H\u0012J\u0018\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\u0006\u0010$\u001a\u00020\u000fH\u0012J\u0014\u0010/\u001a\n \u0013*\u0004\u0018\u00010\u001f0\u001f*\u00020'H\u0012R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0013*\u0004\u0018\u00010\u00160\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0013*\u0004\u0018\u00010\u00180\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0013*\u0004\u0018\u00010\u001a0\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/netflix/spinnaker/orca/telemetry/RedisActiveExecutionsMonitor;", "Lorg/springframework/context/ApplicationListener;", "Lcom/netflix/spinnaker/orca/events/ExecutionEvent;", "executionRepository", "Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;", "redisClientSelector", "Lcom/netflix/spinnaker/kork/jedis/RedisClientSelector;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "registry", "Lcom/netflix/spectator/api/Registry;", "refreshFrequencyMs", "", "cleanupFrequencyMs", "redisKey", "", "(Lcom/netflix/spinnaker/orca/pipeline/persistence/ExecutionRepository;Lcom/netflix/spinnaker/kork/jedis/RedisClientSelector;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spectator/api/Registry;JJLjava/lang/String;)V", "activeOrchestrationCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "kotlin.jvm.PlatformType", "activePipelineCounter", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "log", "Lorg/slf4j/Logger;", "redisClientDelegate", "Lcom/netflix/spinnaker/kork/jedis/RedisClientDelegate;", "getRedisKey", "()Ljava/lang/String;", "snapshot", "", "Lcom/netflix/spectator/api/Id;", "Ljava/util/concurrent/atomic/AtomicLong;", "cleanup", "", "completeExecution", "executionId", "getActiveExecutions", "", "Lcom/netflix/spinnaker/orca/telemetry/RedisActiveExecutionsMonitor$ActiveExecution;", "onApplicationEvent", "event", "refreshGauges", "snapshotActivity", "startExecution", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "getMetricId", "ActiveExecution", "orca-redis"})
public class RedisActiveExecutionsMonitor
implements ApplicationListener<ExecutionEvent> {
    private final Logger log;
    private final RedisClientDelegate redisClientDelegate;
    private final Map<Id, AtomicLong> snapshot;
    private final ScheduledExecutorService executor;
    private final AtomicInteger activePipelineCounter;
    private final AtomicInteger activeOrchestrationCounter;
    private final ExecutionRepository executionRepository;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    @NotNull
    private final String redisKey;

    /*
     * WARNING - void declaration
     */
    public void refreshGauges() {
        void $this$groupByTo$iv$iv;
        List<ActiveExecution> list = this.snapshotActivity();
        boolean bl = false;
        boolean bl2 = false;
        List<ActiveExecution> executions = list;
        boolean bl3 = false;
        this.log.info("Refreshing active execution gauges (active: " + executions.size() + ')');
        Iterable $this$groupBy$iv = executions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ActiveExecution it = (ActiveExecution)element$iv$iv;
            boolean bl4 = false;
            ExecutionType key$iv$iv = it.getType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map executionByType = destination$iv$iv;
        List list2 = (List)executionByType.get(ExecutionType.PIPELINE);
        this.activePipelineCounter.set(list2 != null ? list2.size() : 0);
        List list3 = (List)executionByType.get(ExecutionType.ORCHESTRATION);
        this.activeOrchestrationCounter.set(list3 != null ? list3.size() : 0);
    }

    /*
     * WARNING - void declaration
     */
    private List<ActiveExecution> snapshotActivity() {
        void $this$filterNotTo$iv$iv;
        Object $this$mapTo$iv$iv;
        List<ActiveExecution> activeExecutions = this.getActiveExecutions();
        boolean bl = false;
        Map working = new LinkedHashMap();
        List<ActiveExecution> list = activeExecutions;
        Intrinsics.checkNotNullExpressionValue(list, (String)"activeExecutions");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            ActiveExecution activeExecution = (ActiveExecution)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Id id = this.getMetricId((ActiveExecution)it);
            collection.add(id);
        }
        Object $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Object element$iv = $this$mapTo$iv$iv.next();
            Id it = (Id)element$iv;
            boolean bl2 = false;
            long cfr_ignored_0 = ((Number)working.computeIfAbsent(it, snapshotActivity.2.1.INSTANCE)).longValue() + 1L;
        }
        $this$forEach$iv = working;
        $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv;
        boolean element$iv = false;
        Iterator it = $this$mapTo$iv$iv.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry;
            Map.Entry it2 = entry = it.next();
            boolean bl4 = false;
            this.snapshot.computeIfAbsent((Id)it2.getKey(), snapshotActivity.3.1.INSTANCE).set(((Number)it2.getValue()).longValue());
        }
        Iterable $this$filterNot$iv = this.snapshot.keySet();
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Id it3 = (Id)element$iv$iv;
            boolean bl5 = false;
            if (working.containsKey(it3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv3 = object.next();
            Id it4 = (Id)element$iv3;
            boolean bl3 = false;
            this.snapshot.remove(it4);
        }
        return activeExecutions;
    }

    /*
     * WARNING - void declaration
     */
    public void cleanup() {
        void $this$mapTo$iv$iv;
        List<ActiveExecution> list = this.getActiveExecutions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getActiveExecutions()");
        String[] $this$map$iv = (String[])list;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Collection collection;
            block6: {
                void it;
                ActiveExecution activeExecution = (ActiveExecution)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PipelineExecution execution = null;
                try {
                    PipelineExecution pipelineExecution = this.executionRepository.retrieve(it.getType(), it.getId());
                    Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"executionRepository.retrieve(it.type, it.id)");
                    execution = pipelineExecution;
                }
                catch (ExecutionNotFoundException e) {
                    string = it.getId();
                    break block6;
                }
                catch (StageSerializationException e) {
                    this.log.error("Failed to deserialize " + it.getType() + ':' + it.getId() + ", removing from active execution index", (Throwable)e);
                    string = it.getId();
                    break block6;
                }
                ExecutionStatus executionStatus = execution.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)executionStatus, (String)"execution.status");
                string = executionStatus.isComplete() ? it.getId() : null;
            }
            String string2 = string;
            collection.add(string2);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] orphans = stringArray2;
        this.log.info("Cleaning up " + orphans.length + " orphaned active executions");
        String[] stringArray3 = orphans;
        boolean bl = false;
        stringArray = stringArray3;
        boolean bl2 = false;
        if (!(stringArray.length == 0)) {
            this.redisClientDelegate.withCommandsClient((Consumer)new Consumer<JedisCommands>(this, orphans){
                final /* synthetic */ RedisActiveExecutionsMonitor this$0;
                final /* synthetic */ String[] $orphans;

                public final void accept(JedisCommands redis) {
                    redis.hdel(this.this$0.getRedisKey(), Arrays.copyOf(this.$orphans, this.$orphans.length));
                }
                {
                    this.this$0 = redisActiveExecutionsMonitor;
                    this.$orphans = stringArray;
                }
            });
        }
    }

    public void onApplicationEvent(@NotNull ExecutionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof ExecutionStarted) {
            ExecutionType executionType = ((ExecutionStarted)event).getExecutionType();
            Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"event.executionType");
            String string = ((ExecutionStarted)event).getExecutionId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.executionId");
            this.startExecution(executionType, string);
        } else if (event instanceof ExecutionComplete) {
            String string = ((ExecutionComplete)event).getExecutionId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.executionId");
            this.completeExecution(string);
        }
    }

    private void startExecution(ExecutionType executionType, String executionId) {
        PipelineExecution execution = null;
        try {
            PipelineExecution pipelineExecution = this.executionRepository.retrieve(executionType, executionId);
            Intrinsics.checkNotNullExpressionValue((Object)pipelineExecution, (String)"executionRepository.retr\u2026ecutionType, executionId)");
            execution = pipelineExecution;
        }
        catch (ExecutionNotFoundException e) {
            this.log.error("Received start execution event, but was unable to read execution from the database");
            return;
        }
        this.redisClientDelegate.withCommandsClient((Consumer)new Consumer<JedisCommands>(this, execution){
            final /* synthetic */ RedisActiveExecutionsMonitor this$0;
            final /* synthetic */ PipelineExecution $execution;

            public final void accept(JedisCommands redis) {
                String string = this.this$0.getRedisKey();
                String string2 = this.$execution.getId();
                ObjectMapper objectMapper = RedisActiveExecutionsMonitor.access$getObjectMapper$p(this.this$0);
                String string3 = this.$execution.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"execution.id");
                ExecutionType executionType = this.$execution.getType();
                Intrinsics.checkNotNullExpressionValue((Object)executionType, (String)"execution.type");
                String string4 = this.$execution.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"execution.application");
                redis.hset(string, string2, objectMapper.writeValueAsString((Object)new ActiveExecution(string3, executionType, string4)));
            }
            {
                this.this$0 = redisActiveExecutionsMonitor;
                this.$execution = pipelineExecution;
            }
        });
    }

    private void completeExecution(String executionId) {
        this.redisClientDelegate.withCommandsClient((Consumer)new Consumer<JedisCommands>(this, executionId){
            final /* synthetic */ RedisActiveExecutionsMonitor this$0;
            final /* synthetic */ String $executionId;

            public final void accept(JedisCommands redis) {
                redis.hdel(this.this$0.getRedisKey(), new String[]{this.$executionId});
            }
            {
                this.this$0 = redisActiveExecutionsMonitor;
                this.$executionId = string;
            }
        });
    }

    private List<ActiveExecution> getActiveExecutions() {
        return (List)this.redisClientDelegate.withCommandsClient((Function)new Function<JedisCommands, List<? extends ActiveExecution>>(this){
            final /* synthetic */ RedisActiveExecutionsMonitor this$0;

            /*
             * WARNING - void declaration
             */
            public final List<ActiveExecution> apply(JedisCommands redis) {
                void $this$mapTo$iv$iv;
                Map map = redis.hgetAll(this.this$0.getRedisKey());
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"redis.hgetAll(redisKey)");
                Map $this$map$iv = map;
                boolean $i$f$map = false;
                Map map2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var7_7 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = var7_7.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    ActiveExecution activeExecution = (ActiveExecution)RedisActiveExecutionsMonitor.access$getObjectMapper$p(this.this$0).readValue((String)it.getValue(), ActiveExecution.class);
                    collection.add(activeExecution);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = redisActiveExecutionsMonitor;
            }
        });
    }

    private Id getMetricId(ActiveExecution $this$getMetricId) {
        return this.registry.createId("executions.active").withTag("executionType", $this$getMetricId.getType().toString());
    }

    @NotNull
    public String getRedisKey() {
        return this.redisKey;
    }

    public RedisActiveExecutionsMonitor(@NotNull ExecutionRepository executionRepository, @NotNull RedisClientSelector redisClientSelector, @NotNull ObjectMapper objectMapper, @NotNull Registry registry, @Value(value="${monitor.active-executions.refresh.frequency.ms:60000}") long refreshFrequencyMs, @Value(value="${monitor.active-executions.cleanup.frequency.ms:300000}") long cleanupFrequencyMs, @Value(value="${monitor.active-executions.key:monitor.active-executions}") @NotNull String redisKey) {
        Intrinsics.checkNotNullParameter((Object)executionRepository, (String)"executionRepository");
        Intrinsics.checkNotNullParameter((Object)redisClientSelector, (String)"redisClientSelector");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)redisKey, (String)"redisKey");
        this.executionRepository = executionRepository;
        this.objectMapper = objectMapper;
        this.registry = registry;
        this.redisKey = redisKey;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.redisClientDelegate = redisClientSelector.primary("default");
        this.snapshot = new ConcurrentHashMap();
        this.executor = Executors.newScheduledThreadPool(2);
        this.activePipelineCounter = (AtomicInteger)this.registry.gauge(this.registry.createId("executions.active").withTag("executionType", ExecutionType.PIPELINE.toString()), (Number)new AtomicInteger(0));
        this.activeOrchestrationCounter = (AtomicInteger)this.registry.gauge(this.registry.createId("executions.active").withTag("executionType", ExecutionType.ORCHESTRATION.toString()), (Number)new AtomicInteger(0));
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public final void run() {
                try {
                    this.refreshGauges();
                }
                catch (Exception e) {
                    log.error("Unable to refresh active execution gauges", (Throwable)e);
                }
            }
        }, 0L, refreshFrequencyMs, TimeUnit.MILLISECONDS);
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public final void run() {
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    log.error("Unable to cleanup orphaned active executions", (Throwable)e);
                }
            }
        }, 0L, cleanupFrequencyMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(RedisActiveExecutionsMonitor $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/netflix/spinnaker/orca/telemetry/RedisActiveExecutionsMonitor$ActiveExecution;", "", "id", "", "type", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "application", "(Ljava/lang/String;Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;Ljava/lang/String;)V", "getApplication", "()Ljava/lang/String;", "getId", "getType", "()Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "orca-redis"})
    public static final class ActiveExecution {
        @NotNull
        private final String id;
        @NotNull
        private final ExecutionType type;
        @NotNull
        private final String application;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final ExecutionType getType() {
            return this.type;
        }

        @NotNull
        public final String getApplication() {
            return this.application;
        }

        public ActiveExecution(@NotNull String id, @NotNull ExecutionType type, @NotNull String application) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.id = id;
            this.type = type;
            this.application = application;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final ExecutionType component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.application;
        }

        @NotNull
        public final ActiveExecution copy(@NotNull String id, @NotNull ExecutionType type, @NotNull String application) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            return new ActiveExecution(id, type, application);
        }

        public static /* synthetic */ ActiveExecution copy$default(ActiveExecution activeExecution, String string, ExecutionType executionType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = activeExecution.id;
            }
            if ((n & 2) != 0) {
                executionType = activeExecution.type;
            }
            if ((n & 4) != 0) {
                string2 = activeExecution.application;
            }
            return activeExecution.copy(string, executionType, string2);
        }

        @NotNull
        public String toString() {
            return "ActiveExecution(id=" + this.id + ", type=" + this.type + ", application=" + this.application + ")";
        }

        public int hashCode() {
            String string = this.id;
            ExecutionType executionType = this.type;
            String string2 = this.application;
            return ((string != null ? string.hashCode() : 0) * 31 + (executionType != null ? executionType.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActiveExecution)) break block3;
                    ActiveExecution activeExecution = (ActiveExecution)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)activeExecution.id) || !Intrinsics.areEqual((Object)this.type, (Object)activeExecution.type) || !Intrinsics.areEqual((Object)this.application, (Object)activeExecution.application)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

