/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.telemetry;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.telemetry.AbstractMetricsPostProcessor;
import java.lang.reflect.Field;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

@Component
public class RedisPoolMetricsPostProcessor
extends AbstractMetricsPostProcessor<JedisPool> {
    @Autowired
    public RedisPoolMetricsPostProcessor(Registry registry) {
        super(JedisPool.class, registry);
    }

    protected void applyMetrics(JedisPool bean, String beanName) throws NoSuchFieldException, IllegalAccessException {
        Field poolAccess = Pool.class.getDeclaredField("internalPool");
        poolAccess.setAccessible(true);
        GenericObjectPool pool = (GenericObjectPool)poolAccess.get(bean);
        this.registry.gauge(this.registry.createId("redis.connectionPool.maxIdle", new String[]{"poolName", beanName}), (Object)pool, p -> Integer.valueOf(p.getMaxIdle()).doubleValue());
        this.registry.gauge(this.registry.createId("redis.connectionPool.minIdle", new String[]{"poolName", beanName}), (Object)pool, p -> Integer.valueOf(p.getMinIdle()).doubleValue());
        this.registry.gauge(this.registry.createId("redis.connectionPool.numActive", new String[]{"poolName", beanName}), (Object)bean, p -> Integer.valueOf(p.getNumActive()).doubleValue());
        this.registry.gauge(this.registry.createId("redis.connectionPool.numIdle", new String[]{"poolName", beanName}), (Object)bean, p -> Integer.valueOf(p.getNumIdle()).doubleValue());
        this.registry.gauge(this.registry.createId("redis.connectionPool.numWaiters", new String[]{"poolName", beanName}), (Object)bean, p -> Integer.valueOf(p.getNumWaiters()).doubleValue());
    }
}

