/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.config;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import rx.Scheduler;
import rx.schedulers.Schedulers;

@Configuration
public class JedisConfiguration {
    @Bean(value={"QueryAll"})
    public ThreadPoolTaskExecutor queryAll() {
        return JedisConfiguration.newFixedThreadPool(10);
    }

    @Bean
    public Scheduler queryAllScheduler(@Qualifier(value="QueryAll") ThreadPoolTaskExecutor executor) {
        return Schedulers.from((Executor)executor);
    }

    @Bean(value={"QueryByApp"})
    public ThreadPoolTaskExecutor queryByApp(@Value(value="${thread-pool.execution-repository:150}") int threadPoolSize) {
        return JedisConfiguration.newFixedThreadPool(threadPoolSize);
    }

    @Bean
    public Scheduler queryByAppScheduler(@Qualifier(value="QueryByApp") ThreadPoolTaskExecutor executor) {
        return Schedulers.from((Executor)executor);
    }

    private static ThreadPoolTaskExecutor newFixedThreadPool(int threadPoolSize) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadPoolSize);
        executor.setMaxPoolSize(threadPoolSize);
        return executor;
    }
}

